/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.write;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import oracle.javatools.data.HashStructure;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaPreferences;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

public final class SourceComparator {
    public static Comparator hasNameComparator() {
        return HasNameComparator.getSingleton();
    }

    public static Comparator memberComparator() {
        return new MemberComparator();
    }

    static Comparator memberComparator(SourcePreferences p) {
        return new MemberComparator(p);
    }

    private static class MemberComparator
    implements Comparator,
    JavaConstants,
    JavaPreferences.MemberOrder {
        private final byte[] values;

        MemberComparator() {
            this.values = MEMBER_default;
        }

        MemberComparator(SourcePreferences p) {
            HashStructure h = p.getMemberOrderHashStructure();
            if (h != null) {
                int count = 11;
                this.values = new byte[11];
                Arrays.fill(this.values, (byte)-1);
                for (int i = 0; i < 11; ++i) {
                    String key = MEMBER_keys[i];
                    if (h.containsKey(key)) {
                        this.values[i] = (byte)h.getInt(key);
                    }
                    if (this.values[i] >= 0) continue;
                    this.values[i] = MEMBER_default[i];
                }
            } else {
                this.values = MEMBER_default;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof MemberComparator) {
                return this.equals((MemberComparator)o);
            }
            return false;
        }

        public boolean equals(MemberComparator o) {
            if (this == o) {
                return true;
            }
            return Arrays.equals(this.values, o.values);
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            Sym s1 = (Sym)o1;
            Sym s2 = (Sym)o2;
            short value1 = this.classify(s1);
            short value2 = this.classify(s2);
            return value1 - value2;
        }

        private short classify(Sym s) {
            int member;
            switch (s.symKind) {
                case 7: {
                    return Short.MIN_VALUE;
                }
                case 9: {
                    int access = s.getModifiers();
                    boolean isStatic = Modifier.isStatic(access);
                    if (Modifier.isPublic(access)) {
                        if (isStatic) {
                            member = 0;
                            break;
                        }
                        member = 4;
                        break;
                    }
                    if (Modifier.isProtected(access)) {
                        if (isStatic) {
                            member = 1;
                            break;
                        }
                        member = 5;
                        break;
                    }
                    if (Modifier.isPrivate(access)) {
                        if (isStatic) {
                            member = 3;
                            break;
                        }
                        member = 7;
                        break;
                    }
                    if (isStatic) {
                        member = 2;
                        break;
                    }
                    member = 6;
                    break;
                }
                case 6: {
                    member = 8;
                    break;
                }
                case 19: {
                    member = 9;
                    break;
                }
                case 3: {
                    member = 10;
                    break;
                }
                default: {
                    return Short.MAX_VALUE;
                }
            }
            return this.values[member];
        }
    }

    private static class HasNameComparator
    implements Comparator {
        private static HasNameComparator singleton;

        static HasNameComparator getSingleton() {
            if (singleton == null) {
                singleton = new HasNameComparator();
            }
            return singleton;
        }

        private HasNameComparator() {
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof HasNameComparator;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            String value1 = "";
            String value2 = "";
            if (o1 instanceof SourceHasName) {
                value1 = ((SourceHasName)o1).getName();
            }
            if (o2 instanceof SourceHasName) {
                value2 = ((SourceHasName)o2).getName();
            }
            return value1.compareTo(value2);
        }
    }
}

