/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.Collection;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.ImportObj;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.SourceImport;

public final class ImportSym
extends ObjectSym
implements SourceImport {
    protected static final char VALID_ACCESS = '\b';

    @Override
    public int getElementKind() {
        return 14;
    }

    public boolean isStaticImport() {
        return (this.symAccess & 8) != 0;
    }

    public boolean isNarrow() {
        String name = this.getName();
        return !name.endsWith(".*");
    }

    public boolean equals(Object o) {
        if (o instanceof SourceImport) {
            SourceImport other = (SourceImport)o;
            return this.isStatic() == other.isStatic() && this.getName().equals(other.getName());
        }
        return false;
    }

    public int hashCode() {
        return (this.isStaticImport() ? "static".hashCode() : 0) + this.getName().hashCode();
    }

    public Collection getImportedElements() {
        return this.resolveAndGetImportObj().getImportedElements();
    }

    @Override
    public int getImportedElementCount() {
        return this.resolveAndGetImportObj().getImportedElementCount();
    }

    @Override
    public JavaHasType getImportedElementAt(int index) {
        return this.resolveAndGetImportObj().getImportedElementAt(index);
    }

    @Override
    public JavaClass getQualifyingType() {
        return this.resolveAndGetImportObj().getQualifyingType();
    }

    public boolean isInvalid() {
        return (this.getObjectFlags() & 0x40) != 0;
    }

    public void setInvalid() {
        char flags = this.getObjectFlags();
        flags = (char)(flags | 0x40);
        this.setObjectFlags(flags);
    }

    @Override
    public boolean isUsed() {
        return (this.getObjectFlags() & 0x80) != 0;
    }

    public void setUsed() {
        char flags = this.getObjectFlags();
        flags = (char)(flags | 0x80);
        this.setObjectFlags(flags);
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 20: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected boolean isValidAccess(char access) {
        int allowed = 8;
        return super.isValidAccess((char)(access & 0xFFFFFFF7));
    }

    @Override
    public boolean checkSafeToInsert() {
        return true;
    }

    @Override
    public boolean checkSafeToDelete(TreeSym parent) {
        return true;
    }

    @Override
    public String printCompiledInfo() {
        if (this.isInvalid()) {
            return "<error>";
        }
        if (!this.isUsed()) {
            return "<unused>";
        }
        ImportObj importObj = this.getImportObj();
        int count = importObj.getImportedElementCount();
        if (count == 1) {
            return "imports " + importObj.getImportedElementAt(0).printCompiledInfo();
        }
        return "imports many...";
    }

    @Override
    protected JavaElement resolveImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    public ImportObj getImportObj() {
        ImportObj binding = (ImportObj)this.getInternalBinding(8);
        if (binding != null) {
            return binding;
        }
        binding = new ImportObj();
        binding.objSym = this;
        this.setInternalBinding(binding);
        return binding;
    }

    private ImportObj resolveAndGetImportObj() {
        ImportObj importObj;
        JavaElement result;
        do {
            result = this.resolve();
            importObj = this.getImportObj();
        } while (result != null && !importObj.isResolved());
        return importObj;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public void print(PrintWriter out, int ignored) {
        NameSym name = this.getNameSym();
        if (name != null) {
            out.print("import ");
            if (this.isStatic()) {
                out.print("static ");
            }
            ImportSym.print(name, out);
            out.println(";");
        }
    }
}

