/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.VardeclSym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;

public class FieldDeclSym
extends VardeclSym
implements SourceFieldDeclaration {
    @Override
    public List getVariables() {
        return this.getChildren(10);
    }

    @Override
    public String getUniqueIdentifier() {
        return this.toString();
    }

    @Override
    protected boolean isValidChild(Sym target, byte argument) {
        switch (target.symKind) {
            case 10: {
                return this.symAccess == target.symAccess;
            }
        }
        return super.isValidChild(target, argument);
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 10: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected boolean isValidAccess(char access) {
        char allowed = FieldSym.getValidFieldAccess(this, this.isFinal());
        return super.isValidAccess((char)(access & ~allowed));
    }

    @Override
    protected void linkChildTrigger(Sym added, byte filter) {
        super.linkChildTrigger(added, filter);
        if (added.symKind == 10) {
            this.clearFieldCache();
        }
    }

    @Override
    protected void unlinkChildTrigger(Sym removed, byte filter) {
        super.unlinkChildTrigger(removed, filter);
        if (removed.symKind == 10) {
            this.clearFieldCache();
        }
    }

    private void clearFieldCache() {
        ClassSym owningClass = this.getOwningClassSym();
        if (owningClass != null) {
            owningClass.clearInternalBinding(20);
        }
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        compiler.startFieldDeclarationFlowAnalysis(this);
        try {
            this.checkAccessModifiers(compiler);
            this.checkAnnotations(compiler);
            JavaElement javaElement = super.compileImpl(compiler);
            return javaElement;
        }
        finally {
            compiler.endFieldDeclarationFlowAnalysis(this);
        }
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

