/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.EnumConstantBinding;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;

public class EnumConstantSym
extends MemberSym
implements SourceEnumConstant {
    public EnumConstantSym() {
        this.objectImplicit = (char)16409;
    }

    private void storeConstructor(JavaMethod resolvedConstructor) {
        EnumConstantBinding binding = new EnumConstantBinding(resolvedConstructor);
        this.setInternalBinding(binding);
    }

    private JavaMethod retrieveConstructor() {
        EnumConstantBinding binding = (EnumConstantBinding)this.getInternalBinding(13);
        if (binding != null) {
            return binding.getResolvedConstructor();
        }
        return null;
    }

    @Override
    public int getElementKind() {
        return 5;
    }

    @Override
    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    @Override
    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    @Override
    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    @Override
    public JavaType getResolvedType() {
        for (JavaElement owner = this.getOwner(); owner != null; owner = owner.getOwner()) {
            if (!(owner instanceof ClassSym)) continue;
            return ((ClassSym)owner).getResolvedType();
        }
        return super.getResolvedType();
    }

    @Override
    public JavaField getFieldErasure() {
        return this;
    }

    @Override
    public final SourceEnumConstant getSourceElement() {
        if (this.symFile.isLightSourceFile) {
            SourceClass sourceClass;
            JavaClass owningClass = this.getOwningClass();
            if (owningClass != null && (sourceClass = owningClass.getSourceElement()) != null) {
                return (SourceEnumConstant)CommonUtilities.getSourceElement(this, sourceClass);
            }
            return null;
        }
        return this;
    }

    @Override
    public SourceExpression getInitializer() {
        return null;
    }

    @Override
    public void setInitializer(SourceExpression expr) {
        throw new UnsupportedOperationException("Not allowed on enum constant");
    }

    public boolean equals(Object o) {
        if (o instanceof EnumConstantSym) {
            return CommonUtilities.equals(this, (EnumConstantSym)o);
        }
        return false;
    }

    @Override
    public SourceVariableDeclaration getOwningDeclaration() {
        return null;
    }

    @Override
    public SourceListExpression getArguments() {
        return this.getArgumentsSym();
    }

    @Override
    public void setArguments(SourceListExpression arguments) {
        this.setSym((byte)55, (Sym)((Object)arguments));
    }

    @Override
    public SourceClass getAnonymousClass() {
        return (SourceClass)((Object)this.getChild((byte)3));
    }

    @Override
    public void setAnonymousClass(SourceClass thing) {
        this.setSym((byte)3, (Sym)((Object)thing));
    }

    public ListExpr getArgumentsSym() {
        return (ListExpr)this.getChild((byte)55);
    }

    @Override
    public boolean isEnumConstant() {
        return true;
    }

    @Override
    public Object getConstantValue() {
        return this;
    }

    @Override
    public String printCompiledInfo() {
        JavaType resolvedType = this.getResolvedType();
        if (resolvedType != null) {
            return "FieldSignature " + resolvedType.getTypeSignature();
        }
        return "FieldSignature <unknown>";
    }

    @Override
    public void separateSelf() {
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 1: 
            case 3: 
            case 20: 
            case 55: 
            case 71: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    protected synchronized JavaElement resolveImpl(CompilerDriver compiler) {
        JavaMethod constructor = this.retrieveConstructor();
        if (constructor == null) {
            constructor = compiler.resolve(this);
            this.storeConstructor(constructor);
        }
        return constructor;
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        super.compileImpl(compiler);
        if (!compiler.skipCompilations()) {
            compiler.compile(this);
        }
        return this;
    }

    @Override
    public JavaElement getCompiledObject() {
        this.resolve();
        return this.retrieveConstructor();
    }

    @Override
    public JavaMethod getResolvedConstructor() {
        return (JavaMethod)this.getCompiledObject();
    }
}

