/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectBinding;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceElement;

public class BlockSym
extends TreeSym
implements SourceBlock {
    public BlockSym() {
        this.symFlags = (byte)(this.symFlags | 1);
    }

    @Override
    public List<SourceElement> getCodeElements() {
        return this.getChildren(88);
    }

    public List getLocalClasses() {
        return this.getChildren(3);
    }

    public List<ClassSym> getLocalClasses(String name) {
        if (this.testSymFlag((byte)64)) {
            return Collections.emptyList();
        }
        ObjectBinding localsBinding = (ObjectBinding)this.getInternalBinding(23);
        if (localsBinding != null) {
            List<ClassSym> localClasses = (List<ClassSym>)((Map)localsBinding.getObject()).get(name);
            return localClasses != null ? localClasses : Collections.emptyList();
        }
        List localClasses = this.getChildren(3);
        if (localClasses.isEmpty()) {
            this.symFlags = (byte)(this.symFlags | 0x40);
            return Collections.emptyList();
        }
        LinkedHashMap<String, ArrayList<ClassSym>> localClassesByName = new LinkedHashMap<String, ArrayList<ClassSym>>(localClasses.size());
        for (ClassSym localClass : localClasses) {
            String localName = localClass.getName();
            ArrayList<ClassSym> localList = (ArrayList<ClassSym>)localClassesByName.get(localName);
            if (localList == null) {
                localList = new ArrayList<ClassSym>();
                localClassesByName.put(localName, localList);
            }
            localList.add(localClass);
        }
        this.setInternalBinding(new ObjectBinding(23, localClassesByName));
        List<ClassSym> foundLocals = (List<ClassSym>)localClassesByName.get(name);
        return foundLocals != null ? foundLocals : Collections.emptyList();
    }

    public Collection getLocalVariables() {
        if (this.testSymFlag((byte)-128)) {
            return Collections.emptyList();
        }
        return this.getSyms((byte)100);
    }

    public List<LocalVariableSym> getLocalVariables(String name) {
        if (this.testSymFlag((byte)-128)) {
            return Collections.emptyList();
        }
        ObjectBinding localsBinding = (ObjectBinding)this.getInternalBinding(22);
        if (localsBinding != null) {
            List<LocalVariableSym> locals = (List<LocalVariableSym>)((Map)localsBinding.getObject()).get(name);
            return locals != null ? locals : Collections.emptyList();
        }
        Collection locals = this.getSyms((byte)100);
        LinkedHashMap<String, ArrayList<LocalVariableSym>> localsByName = new LinkedHashMap<String, ArrayList<LocalVariableSym>>(locals.size());
        for (LocalVariableSym local : locals) {
            String localName = local.getName();
            ArrayList<LocalVariableSym> localList = (ArrayList<LocalVariableSym>)localsByName.get(localName);
            if (localList == null) {
                localList = new ArrayList<LocalVariableSym>();
                localsByName.put(localName, localList);
            }
            localList.add(local);
        }
        if (localsByName.isEmpty()) {
            this.symFlags = (byte)(this.symFlags | 0xFFFFFF80);
            return Collections.emptyList();
        }
        this.setInternalBinding(new ObjectBinding(22, localsByName));
        List<LocalVariableSym> foundLocals = (List<LocalVariableSym>)localsByName.get(name);
        return foundLocals != null ? foundLocals : Collections.emptyList();
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 3: 
            case 18: {
                return true;
            }
            case 23: {
                Sym grandpa;
                Sym parent = this.getParentSym();
                if (parent == null) {
                    return true;
                }
                if (parent.symKind != 33 || (grandpa = parent.getParentSym()) != null && grandpa.symKind != 45) break;
                return true;
            }
        }
        if (BlockSym.srcIsStmt(symKind)) {
            return true;
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected void linkChildTrigger(Sym added, byte filter) {
        super.linkChildTrigger(added, filter);
        switch (added.symKind) {
            case 3: {
                this.clearClassCache();
                break;
            }
            case 18: {
                this.clearLocalsCache();
            }
        }
    }

    @Override
    protected void unlinkChildTrigger(Sym removed, byte filter) {
        super.unlinkChildTrigger(removed, filter);
        switch (removed.symKind) {
            case 3: {
                this.clearClassCache();
                break;
            }
            case 18: {
                this.clearLocalsCache();
            }
        }
    }

    private void clearClassCache() {
        this.symFlags = (byte)(this.symFlags & 0xFFFFFFBF);
        this.clearInternalBinding(23);
    }

    private void clearLocalsCache() {
        this.symFlags = (byte)(this.symFlags & 0x7F);
        this.clearInternalBinding(22);
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        if (compiler.skipCompilations()) {
            return super.compileImpl(compiler);
        }
        compiler.startBlockFlowAnalysis(this);
        try {
            super.compileImpl(compiler);
            JavaElement javaElement = compiler.compile(this);
            return javaElement;
        }
        finally {
            compiler.endBlockFlowAnalysis(this);
        }
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

