/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import oracle.javatools.buffer.LineMap;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.WhitespaceSym;
import oracle.javatools.parser.java.v2.model.SourceLexicalBlankline;
import oracle.javatools.parser.java.v2.scanner.TokenArray;

public final class BlanklineSym
extends WhitespaceSym
implements SourceLexicalBlankline {
    public byte blanklineFollowing = (byte)-1;

    public BlanklineSym() {
        this.tokenValue = (short)5;
        this.tokenText = "\n";
    }

    private byte getFollowingCount() {
        if (this.blanklineFollowing == -1) {
            this.blanklineFollowing = 0;
            Sym parent = this.symParent;
            if (parent instanceof TreeSym) {
                Sym sibling;
                int selfStart = this.symStart;
                TreeSym treeSym = (TreeSym)parent;
                int i = treeSym.indexOf(this);
                while ((i = treeSym.indexOf((byte)78, i + 1)) != -1 && (sibling = treeSym.getNthChild(i)) != null && sibling.symStart == selfStart) {
                    this.blanklineFollowing = (byte)(this.blanklineFollowing + 1);
                }
            }
        }
        return this.blanklineFollowing;
    }

    @Override
    public final int getLineNumber() {
        LineMap lineMap = this.symFile.getLineMap();
        if (lineMap != null) {
            return this.getLineNumber(lineMap);
        }
        return -1;
    }

    private int getLineNumber(LineMap lineMap) {
        byte followingCount;
        int startOffset = super.getStartOffset();
        if (startOffset < 0) {
            return -1;
        }
        if (startOffset == 0) {
            BlanklineSym.panic("The Sym after a blank line has a zero start offset?");
        }
        if ((followingCount = this.getFollowingCount()) >= 0) {
            int tokenLine = lineMap.getLineFromOffset(startOffset);
            return tokenLine - 1 - followingCount;
        }
        return -1;
    }

    @Override
    public int getStartOffset() {
        int line;
        LineMap lineMap = this.symFile.getLineMap();
        if (lineMap != null && (line = this.getLineNumber(lineMap)) != -1) {
            return lineMap.getLineStartOffset(line);
        }
        return super.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        int line;
        LineMap lineMap = this.symFile.getLineMap();
        if (lineMap != null && (line = this.getLineNumber(lineMap)) != -1) {
            return lineMap.getLineEndOffset(line);
        }
        return super.getEndOffset();
    }

    @Override
    public void setText(String text) {
        BlanklineSym.unsupported("May not change text of a blank line.");
    }

    @Override
    protected int indexSelf(Sym[] index, int pos, TokenArray tokens) {
        return pos;
    }

    @Override
    protected Sym cloneSelfImpl(FileSym targetFile) {
        return SymFactory.createNode(targetFile, this.symKind);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

