/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.lang.reflect.Modifier;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.ObjConstants;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;

abstract class ContextImageA
extends CompilerUtilities
implements ObjConstants {
    protected boolean flag_instance = true;
    protected boolean flag_static = true;
    protected boolean flag_collect_annotation_element_names = true;
    protected boolean suppressErrors = false;
    protected final CompilerDriver compiler;
    protected final JavaClass callerClass;
    protected final Sym symCookie;
    private Sym symScope;

    ContextImageA(CompilerDriver compiler, Sym cookie) {
        this.compiler = compiler;
        this.callerClass = null;
        this.symCookie = cookie;
    }

    protected final void cleanScope() {
        this.flag_instance = true;
        this.flag_static = true;
        if (this.compiler.flag_nonFinalLocalVars != null) {
            this.compiler.flag_nonFinalLocalVars = true;
        }
        this.flag_collect_annotation_element_names = true;
    }

    protected final Sym initializeScope() {
        this.symScope = this.symCookie.getScope();
        return this.symScope;
    }

    protected final Sym cleanAndInitializeScope() {
        this.cleanScope();
        return this.initializeScope();
    }

    protected final Sym nextScope() {
        if (this.symScope == null) {
            return null;
        }
        if (this.symScope.isStatic() && (this.symCookie == null || this.symCookie.symKind != 74)) {
            this.flag_instance = false;
        }
        Sym scope = this.symScope.getScope();
        if (this.compiler.flag_nonFinalLocalVars != null && scope != null && this.symScope.symKind == 3 && scope.symKind != 4) {
            this.compiler.flag_nonFinalLocalVars = false;
        }
        this.symScope = scope;
        return scope;
    }

    protected final boolean allowAccess(JavaElement target) {
        if (target == null) {
            return true;
        }
        return this.processAccess(target, null);
    }

    protected final boolean allowAccess(JavaElement target, JavaHasType primary) {
        if (target == null) {
            return true;
        }
        return this.processAccess(target, primary);
    }

    protected final JavaElement error(short errorCode) {
        return this.error(errorCode, null, null);
    }

    protected final JavaElement error(short errorCode, Object data) {
        return this.error(errorCode, data, null);
    }

    protected final JavaElement error(short errorCode, Object data0, Object data1) {
        if (this.suppressErrors) {
            return null;
        }
        if (this.symCookie == null) {
            return null;
        }
        FileSym fileSym = this.symCookie.symFile;
        if (fileSym == null) {
            return null;
        }
        this.generateError(fileSym, this.symCookie, errorCode, data0, data1);
        return null;
    }

    private boolean processAccess(JavaElement target, JavaHasType primary) {
        int modifiers;
        boolean output;
        if (target instanceof JavaPackage) {
            return true;
        }
        switch (target.getElementKind()) {
            case 9: {
                return true;
            }
            case 7: {
                return this.compiler.flag_nonFinalLocalVars == null || this.compiler.flag_nonFinalLocalVars != false || target.isFinal();
            }
            case 15: 
            case 17: {
                return true;
            }
            case 10: {
                return true;
            }
            case 16: {
                return true;
            }
        }
        boolean isType = target instanceof JavaClass;
        if (!isType || !this.flag_static) {
            // empty if block
        }
        if (!(output = this.processAccessImpl(modifiers = target.getModifiers(), target, primary))) {
            return false;
        }
        if (!isType && !this.flag_instance) {
            JavaMethod m;
            if (target.getElementKind() == 8 && (m = (JavaMethod)target).isConstructor()) {
                return true;
            }
            if (!Modifier.isStatic(modifiers)) {
                return false;
            }
        }
        return true;
    }

    private boolean processAccessImpl(int modifiers, JavaElement target, JavaHasType primary) {
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        JavaClass owner = null;
        if (target instanceof JavaMember) {
            owner = ((JavaMember)target).getOwningClass();
        }
        if (owner == null) {
            if (target instanceof JavaType) {
                return ContextImageA.checkPackageAccess(this.getCallingPackage(), (JavaType)target);
            }
            return false;
        }
        if (owner.isPrimitive() || owner.isArray()) {
            ContextImageA.panic();
        }
        if (Modifier.isPrivate(modifiers)) {
            return ContextImageA.checkPrivateAccess(this.getCallingClass(), owner);
        }
        if (ContextImageA.checkPackageAccess(this.getCallingPackage(), owner)) {
            return true;
        }
        if (!Modifier.isProtected(modifiers)) {
            return false;
        }
        return this.checkProtectedAccess(this.symCookie, owner, target, primary, this.flag_instance);
    }

    protected final boolean processVisible(JavaMember member) {
        int modifiers = member.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        JavaClass owner = member.getOwningClass();
        if (owner == null) {
            if (member instanceof JavaType) {
                return ContextImageA.checkPackageAccess(this.getCallingPackage(), (JavaType)member);
            }
            return false;
        }
        if (owner.isArray()) {
            return false;
        }
        if (Modifier.isPrivate(modifiers)) {
            return ContextImageA.checkPrivateAccess(this.getCallingClass(), owner);
        }
        if (Modifier.isProtected(modifiers)) {
            return true;
        }
        return ContextImageA.checkPackageAccess(this.getCallingPackage(), owner);
    }

    private static boolean checkPrivateAccess(JavaClass caller, JavaType target) {
        JavaClass outermostCaller = ContextImageA.getOutermost(caller);
        JavaClass outermostTarget = ContextImageA.getOutermost(target);
        if (outermostCaller == null && outermostTarget == null) {
            return false;
        }
        if (outermostCaller != null) {
            outermostCaller = outermostCaller.getTypeErasure();
        }
        if (outermostTarget != null) {
            outermostTarget = outermostTarget.getTypeErasure();
        }
        if (outermostCaller == null && outermostTarget == null) {
            return false;
        }
        if (outermostCaller == null || outermostTarget == null) {
            return true;
        }
        return outermostCaller.equals(outermostTarget);
    }

    private static boolean checkPackageAccess(String callingPackage, JavaType target) {
        String targetPackage = target.getPackageName();
        if (callingPackage == null && targetPackage == null) {
            return true;
        }
        if (callingPackage == null || targetPackage == null) {
            return false;
        }
        return callingPackage.equals(targetPackage);
    }

    private boolean checkProtectedAccess(Sym scope, JavaType owner, JavaElement target, JavaHasType primary, boolean instanceAccess) {
        Sym parent = scope.getParentSym();
        if (target.getElementKind() == 8 && ((JavaMethod)target).isConstructor() && parent != null && parent.symKind == 59) {
            JavaType lhsType;
            SourceNewClassExpression expr = (SourceNewClassExpression)((Object)parent);
            if (expr.getAnonymousClass() != null) {
                return true;
            }
            SourceExpression lhs = expr.getLhsOperand();
            JavaType javaType = lhsType = lhs != null ? lhs.getResolvedType() : null;
            if (lhsType != null && this.allowAccess(lhsType)) {
                return true;
            }
        }
        boolean skipNextClass = false;
        while (scope != null) {
            switch (scope.symKind) {
                case 3: {
                    String primaryId;
                    if (skipNextClass) {
                        skipNextClass = false;
                        break;
                    }
                    JavaClass enclosing = (JavaClass)((Object)scope);
                    if (!enclosing.isSubtypeOf(owner)) break;
                    int elementKind = target.getElementKind();
                    if (elementKind == 3) {
                        return true;
                    }
                    if (Modifier.isStatic(target.getModifiers())) {
                        return true;
                    }
                    if (instanceAccess) {
                        return true;
                    }
                    return primary != null && primary.getResolvedType() != null && (primaryId = primary.getResolvedType().getUniqueIdentifier()).equals(enclosing.getUniqueIdentifier());
                }
                case 15: 
                case 22: {
                    skipNextClass = true;
                }
            }
            if (Modifier.isStatic(scope.getModifiers())) {
                instanceAccess = false;
            }
            scope = scope.getScope();
        }
        return false;
    }

    private JavaClass getCallingClass() {
        if (this.callerClass != null) {
            return this.callerClass;
        }
        return this.symCookie.getOwningClassSym();
    }

    private String getCallingPackage() {
        SourceFile sourceFile = this.symCookie.getOwningSourceFile();
        if (sourceFile != null) {
            return sourceFile.getPackageName();
        }
        return null;
    }

    protected static JavaClass getOutermost(JavaType subject) {
        if (subject == null) {
            return null;
        }
        JavaMember owner = null;
        if (subject.getElementKind() == 3) {
            owner = (JavaClass)subject;
        }
        JavaClass next = owner.getOwningClass();
        while (next != null) {
            owner = next;
            next = owner.getOwningClass();
        }
        return owner;
    }
}

