/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickComponent;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer3;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.CatchParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.LambdaParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.SwitchLabelSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.VariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.AssertStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.BlockStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.DoStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ExpressionStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ForStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.IfStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ReturnStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.SwitchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.SynchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ThrowStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.TryStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.WhileStmt;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;
import oracle.javatools.parser.java.v2.util.Conversions;

abstract class CompilerLayer4
extends CompilerLayer3 {
    CompilerLayer4() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaAnnotation resolve(AnnotateSym sym) {
        TypeSym typeSym = sym.getTypeSym();
        if (typeSym != null) {
            JavaType result = typeSym.getResolvedType();
            if (result == null) {
                return sym;
            }
            if (result.isAnnotation() && sym.getArgumentCount() > 0) {
                ListExpr args = sym.getArgumentListSym();
                CompilerContext savedContext = this.getCompilerContext();
                try {
                    this.setCompilerContext(this.newContext(sym));
                    this.processComponents(result, sym, args);
                }
                finally {
                    this.setCompilerContext(savedContext);
                }
            }
        }
        return sym;
    }

    public final JavaAnnotation compile(AnnotateSym sym) {
        sym.resolve();
        JavaType annotateType = sym.getResolvedType();
        if (annotateType == null) {
            return sym;
        }
        if (!annotateType.isAnnotation()) {
            this.error(sym, (short)64, annotateType);
            return sym;
        }
        if (sym.dimensionIndex > 0 && !CommonUtilities.isTypeUseAnnotation(sym, false)) {
            this.error(sym, (short)123);
            return sym;
        }
        if (sym.getArgumentCount() == 0) {
            Collection<JavaMethod> methods = annotateType.getDeclaredMethods();
            for (JavaMethod method : methods) {
                if (method.getDefaultValue() != null) continue;
                this.error(sym, (short)108, method);
                break;
            }
        }
        return sym;
    }

    public final JavaElement compile(BlockSym sym) {
        if (sym.getChild((byte)18) != null) {
            this.processDuplicates(sym.getLocalVariables());
        }
        return sym;
    }

    public final JavaElement compile(TryStmt sym) {
        List<SourceLocalVariableDeclaration> resourceVariables;
        if (sym.hasResourceVariables() && (resourceVariables = sym.getResourceVariables()).size() > 0) {
            JavaClass autoCloseable;
            this.processDuplicates(sym.getSyms((byte)100));
            if (this.jdkVersion.isJdk7OrAbove() && (autoCloseable = this.provider.getClassByVMName("java/lang/AutoCloseable")) != null) {
                for (SourceLocalVariableDeclaration decl : resourceVariables) {
                    List<SourceVariable> vars = decl.getVariables();
                    for (SourceVariable var : vars) {
                        JavaType type = var.getResolvedType();
                        if (type == null || type.isSubtypeOf(autoCloseable)) continue;
                        this.error((Sym)((Object)var), (short)86);
                    }
                }
            }
        }
        return sym;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaVariable resolve(VariableSym sym) {
        String name = sym.getName();
        if (name != null && name.length() > 0) {
            CompilerContext savedContext = this.getCompilerContext();
            try {
                this.setCompilerContext(this.newContext(sym));
                JavaVariable found = this.lookupExclusiveLocal(sym, name);
                if (found != null) {
                    this.error(sym, (short)52, name, found);
                }
            }
            finally {
                this.setCompilerContext(savedContext);
            }
        }
        return sym;
    }

    public final JavaType resolve(CatchParameterSym sym) {
        ArrayList<JavaType> resolvedTypes = new ArrayList<JavaType>();
        List<SourceTypeReference> list = sym.getSourceTypes();
        for (SourceTypeReference type : list) {
            JavaType resolvedType = type.getResolvedType();
            if (resolvedType == null) continue;
            resolvedTypes.add(resolvedType);
        }
        if (resolvedTypes.isEmpty()) {
            return null;
        }
        block1: for (int x = 0; x < resolvedTypes.size(); ++x) {
            for (int y = x + 1; y < resolvedTypes.size(); ++y) {
                String lubName;
                JavaType two;
                JavaType one = (JavaType)resolvedTypes.get(x);
                JavaType lub = CompilerUtilities.leastUpperBound(this.provider, one, two = (JavaType)resolvedTypes.get(y));
                if (lub == null || !(lubName = lub.getRawName()).equals(one.getRawName()) && !lubName.equals(two.getRawName())) continue;
                this.error(sym, (short)85);
                break block1;
            }
        }
        while (resolvedTypes.size() > 1) {
            JavaType two;
            JavaType one = (JavaType)resolvedTypes.get(0);
            JavaType lub = CompilerUtilities.leastUpperBound(this.provider, one, two = (JavaType)resolvedTypes.get(1));
            if (lub == null) {
                resolvedTypes.remove(1);
                continue;
            }
            resolvedTypes.remove(0);
            resolvedTypes.remove(0);
            resolvedTypes.add(0, lub);
        }
        return (JavaType)resolvedTypes.get(0);
    }

    public final JavaType resolve(LambdaParameterSym sym) {
        if (sym.isInferredFormalParameter()) {
            JavaMethod targetMethod;
            SourceLambdaExpression parent = sym.getOwningLambdaExpression();
            if (parent != null && (targetMethod = parent.getTargetMethod()) != null) {
                JavaType[] targetParameterTypes;
                int targetMethodIndex = -1;
                List<SourceLambdaParameter> formalParameters = parent.getFormalParameters();
                for (int x = 0; x < formalParameters.size(); ++x) {
                    if (sym != formalParameters.get(x)) continue;
                    targetMethodIndex = x;
                    break;
                }
                if (targetMethodIndex > 0 && targetMethodIndex < (targetParameterTypes = targetMethod.getParameterTypes()).length) {
                    return targetParameterTypes[targetMethodIndex];
                }
            }
            return null;
        }
        return sym.getSourceType().getResolvedType();
    }

    public final JavaElement compile(ExpressionStmt sym) {
        this.processExpressionStatement(sym.getExpressionSym());
        return null;
    }

    public final JavaElement compile(ForStmt sym) {
        Expr conditionalSym;
        if (sym.getForType() == 2) {
            Expr collectionSym = sym.getCollectionSym();
            if (collectionSym != null) {
                SourceLocalVariable localVariable;
                JavaType lhsType;
                List forVariables;
                JavaType elementType = null;
                JavaType collectionType = collectionSym.getResolvedType();
                if (collectionType != null) {
                    if (collectionType.isArray()) {
                        elementType = collectionType.getComponentType();
                    } else {
                        JavaType iterable = null;
                        if (this.isIterable(collectionType)) {
                            iterable = collectionType;
                        } else {
                            Set<JavaType> parents = collectionType.getHierarchy();
                            for (JavaType parent : parents) {
                                if (!this.isIterable(parent)) continue;
                                iterable = parent;
                                break;
                            }
                        }
                        if (iterable == null) {
                            this.error(collectionSym, (short)98);
                        } else {
                            Collection<JavaType> actualTypeArguments = iterable.getActualTypeArguments();
                            if (actualTypeArguments.size() > 0) {
                                elementType = actualTypeArguments.iterator().next();
                            }
                            if (elementType == null) {
                                elementType = this.getPreloadedClass((byte)4);
                            }
                        }
                    }
                }
                if ((forVariables = sym.getForVariables()).size() > 0 && !Conversions.applyAssignmentConversion(elementType, collectionSym, lhsType = (localVariable = (SourceLocalVariable)forVariables.get(0)).getResolvedType(), false, this.provider, this.jdkVersion)) {
                    this.error((Sym)((Object)localVariable), (short)43, elementType, lhsType);
                }
            }
        } else {
            this.processExpressionStatements(sym.getInitializationsSym());
            this.processExpressionStatements(sym.getUpdatesSym());
        }
        if (sym.getForType() != 2 && (conditionalSym = sym.getConditionalSym()) != null) {
            this.checkExpressionIsBoolean(conditionalSym);
        }
        return sym;
    }

    private boolean isIterable(JavaType javaType) {
        return javaType != null && javaType.isInterface() && "java.lang.Iterable".equals(javaType.getRawName());
    }

    public final JavaElement compile(SwitchStmt sym) {
        JavaType switchType = this.compileSwitchStmtSym(sym);
        this.compileSwitchLabels(switchType, sym);
        return null;
    }

    private void compileSwitchLabels(JavaType switchType, SwitchStmt sym) {
        BlockStmt switchStmtBlock = (BlockStmt)sym.getChild((byte)33);
        if (switchStmtBlock == null) {
            return;
        }
        Sym switchBlock = switchStmtBlock.getChild((byte)2);
        if (switchBlock == null) {
            return;
        }
        List<SourceElement> labels = switchBlock.getChildren();
        HashMap<String, SwitchLabelSym> previousLabels = new HashMap<String, SwitchLabelSym>();
        Iterator<SourceElement> labelIter = labels.iterator();
        SwitchLabelSym defaultLabel = null;
        boolean foundFirstLabel = false;
        while (labelIter.hasNext()) {
            Sym child = (Sym)labelIter.next();
            if (child.symKind == 23) {
                foundFirstLabel = true;
                SwitchLabelSym labelSym = (SwitchLabelSym)child;
                Expr expr = labelSym.getExpressionSym();
                if (expr != null) {
                    JavaType labelType;
                    Object constantValue = expr.getConstantValue();
                    if (constantValue == null) {
                        this.error(expr, (short)55);
                        continue;
                    }
                    SwitchLabelSym previous = (SwitchLabelSym)previousLabels.get(constantValue.toString());
                    if (previous != null) {
                        this.error(expr, (short)52, constantValue.toString(), previous);
                        continue;
                    }
                    previousLabels.put(constantValue.toString(), labelSym);
                    if (switchType == null || (labelType = expr.getResolvedType()) == null) continue;
                    PrimitiveType unboxedType = PrimitiveType.applyUnboxingConversion(labelType, this.jdkVersion);
                    if (unboxedType != null) {
                        labelType = unboxedType;
                    }
                    if (labelType.isPrimitive() && switchType.isPrimitive() || labelType.equals(switchType)) continue;
                    this.error(expr, (short)55, expr);
                    continue;
                }
                String labelText = labelSym.getText();
                if (labelText == null || !labelText.startsWith("default")) continue;
                if (defaultLabel != null) {
                    this.error(labelSym, (short)52, "default", defaultLabel);
                    continue;
                }
                defaultLabel = labelSym;
                continue;
            }
            if (foundFirstLabel || child.symKind >= 70 && child.symKind < 77 || child.symKind >= 77 && child.symKind < 80) continue;
            this.error(child, (short)84);
        }
    }

    private JavaType compileSwitchStmtSym(SwitchStmt sym) {
        Expr expr = sym.getExpressionSym();
        if (expr == null) {
            return null;
        }
        JavaType javaType = expr.getResolvedType();
        if (javaType != null) {
            PrimitiveType unboxed = PrimitiveType.applyUnboxingConversion(javaType, this.jdkVersion);
            if (unboxed != null) {
                javaType = unboxed;
            }
            if (javaType.isPrimitive()) {
                PrimitiveType primitive = (PrimitiveType)javaType;
                switch (primitive.primCode) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return javaType;
                    }
                }
            } else {
                if (javaType.isEnum()) {
                    return javaType;
                }
                if (this.jdkVersion.isJdk7OrAbove() && "String".equals(javaType.getName())) {
                    return javaType;
                }
            }
            this.error(expr, (short)74, javaType);
        }
        return javaType;
    }

    public final JavaElement compile(ReturnStmt sym) {
        JavaType returnType = null;
        boolean isConstructor = false;
        Conversions.ConversionType conversionType = Conversions.ConversionType.ASSIGNMENT;
        for (Sym owner = sym.getParentSym(); owner != null; owner = owner.getParentSym()) {
            Sym parent;
            if (owner.symKind != 2 || (parent = owner.getParentSym()) == null) continue;
            if (parent.isFilter((byte)86)) {
                if (parent.symKind != 19 && parent.symKind != 6) break;
                returnType = ((SourceMethod)((Object)parent)).getReturnType();
                isConstructor = parent.symKind == 6;
                break;
            }
            if (parent.symKind != 67) continue;
            returnType = ((SourceLambdaExpression)((Object)parent)).getResolvedType();
            conversionType = Conversions.ConversionType.METHOD;
            break;
        }
        Expr e = sym.getExpressionSym();
        if (CompilerLayer4.isVoidType(returnType) || isConstructor) {
            if (e != null) {
                this.error(e, (short)76);
            }
        } else if (returnType != null) {
            if (e != null) {
                JavaType type;
                JavaHasType hasType = e.getResolvedObject();
                if (hasType != null && hasType instanceof JavaType) {
                    this.error(e, (short)74, hasType);
                }
                if ((type = e.getResolvedType()) != null) {
                    this.processConversion(returnType, e, conversionType);
                }
            } else {
                this.error(sym, (short)43, PrimitiveType.getVoidType(), returnType);
            }
        }
        return null;
    }

    public final JavaElement compile(SynchStmt sym) {
        Expr e = sym.getExpressionSym();
        if (e == null) {
            return null;
        }
        JavaHasType lhs = this.processExpression(e);
        if (lhs == null) {
            return null;
        }
        if (lhs instanceof JavaType) {
            this.error(e, (short)71, lhs);
        }
        return null;
    }

    public final JavaElement compile(ThrowStmt sym) {
        JavaElement thrownObject;
        Expr e = sym.getExpressionSym();
        if (e == null) {
            return null;
        }
        if (this.jdkVersion.isJdk7OrAbove() && (thrownObject = e.getCompiledObject()) != null && thrownObject.isSourceElement() && ((SourceElement)((Object)thrownObject)).getSymbolKind() == 28) {
            return null;
        }
        JavaType type = e.getResolvedType();
        if (type == null) {
            return null;
        }
        this.checkException(sym, type);
        return null;
    }

    public final JavaElement compile(AssertStmt sym) {
        this.checkExpressionIsBoolean(sym.getExpressionSym());
        Expr e = (Expr)sym.getNthChild((byte)90, 1);
        if (e != null) {
            JavaType type = e.getResolvedType();
            if (PrimitiveType.getVoidType().equals(type)) {
                this.error(e, (short)74, type);
            }
        }
        return sym;
    }

    public final JavaElement compile(IfStmt sym) {
        this.checkExpressionIsBoolean(sym.getExpressionSym());
        return sym;
    }

    public final JavaElement compile(WhileStmt sym) {
        this.checkExpressionIsBoolean(sym.getExpressionSym());
        return sym;
    }

    public final JavaElement compile(DoStmt sym) {
        this.checkExpressionIsBoolean(sym.getExpressionSym());
        return sym;
    }

    private void checkExpressionIsBoolean(Expr e) {
        if (e == null) {
            return;
        }
        JavaType type = e.getResolvedType();
        if (type == null) {
            return;
        }
        if (CompilerUtilities.isBooleanType(type)) {
            return;
        }
        this.error(e, (short)115, PrimitiveType.getPrimitiveType(0), type);
    }

    private void processComponents(JavaType annotateType, AnnotateSym sym, ListExpr args) {
        Expr e;
        if (args == null) {
            return;
        }
        int count = args.getOperandCount();
        if (count == 0) {
            return;
        }
        HashSet<JavaMethod> nonDefaultMethods = new HashSet<JavaMethod>();
        Collection<JavaMethod> methods = annotateType.getDeclaredMethods();
        for (JavaMethod method : methods) {
            if (method.getDefaultValue() != null) continue;
            nonDefaultMethods.add(method);
        }
        if (count == 1 && (e = args.getNthOperandSym(0)) != null && e.exprOptcode != 6) {
            this.processSingleValueNoName(annotateType, sym, e, nonDefaultMethods);
            return;
        }
        for (int i = 0; i < count; ++i) {
            Expr arg = args.getNthOperandSym(i);
            this.processNormalComponent(sym, arg, nonDefaultMethods);
        }
        for (JavaMethod nonDefaultMethod : nonDefaultMethods) {
            this.error(sym, (short)108, nonDefaultMethod);
        }
    }

    private void processSingleValueNoName(JavaType annotateType, AnnotateSym sym, Expr arg, Set<JavaMethod> nonDefaultMethods) {
        JavaMethod valueM = annotateType.getDeclaredMethod("value", JavaType.EMPTY_ARRAY);
        if (valueM == null) {
            this.error(arg, (short)59, "value", annotateType, annotateType.getQualifiedName());
            if (!nonDefaultMethods.isEmpty()) {
                this.error(arg, (short)109);
            }
            return;
        }
        Collection<JavaMethod> methods = annotateType.getDeclaredMethods();
        for (JavaMethod thing : methods) {
            String name = thing.getName();
            if ("value".equals(name) || thing.getDefaultValue() != null) continue;
            this.error(sym, (short)108, thing);
            return;
        }
        JavaType expected = valueM.getResolvedType();
        Object value = this.processComponentValue(expected, arg);
        if (value != null) {
            sym.getComponents().assignValue("value", value, arg == null ? null : arg.getConstantValue());
        }
    }

    private void processNormalComponent(AnnotateSym sym, Expr arg, Set<JavaMethod> nonDefaultMethods) {
        JavaType expected;
        Object value;
        byte optCode = arg.exprOptcode;
        if (optCode != 6) {
            if (optCode != 53) {
                this.error(arg, (short)109);
            }
            return;
        }
        Expr lhs = arg.getNthOperandSym(0);
        JavaHasType result = lhs.getResolvedObject();
        if (result == null || result.getElementKind() != 4) {
            String text = lhs.getName();
            if (text == null || text.isEmpty()) {
                text = lhs.getText();
            }
            this.error(lhs, (short)111, text);
            return;
        }
        Expr rhs = arg.getNthOperandSym(1);
        QuickComponent qc = (QuickComponent)result;
        JavaMethod method = qc.getMethod();
        if (method != null) {
            nonDefaultMethods.remove(method);
        }
        if ((value = this.processComponentValue(expected = qc.getResolvedType(), rhs)) != null) {
            sym.getComponents().assignValue(qc.getName(), value, rhs == null ? null : rhs.getConstantValue());
        }
    }

    private Object processComponentValue(JavaType expected, Expr arg) {
        JavaType baseExpected;
        Object value = arg.getConstantValue();
        if (value == null) {
            this.error(arg, (short)113);
            return null;
        }
        JavaType argType = arg.getResolvedType();
        if (argType == null) {
            return null;
        }
        if (expected == null) {
            return value;
        }
        if (expected.isAssignableFrom(argType)) {
            return value;
        }
        if (expected.isArray() && ((baseExpected = expected.getComponentType()) == null || baseExpected.isAssignableFrom(argType))) {
            return new Object[]{value};
        }
        this.error(arg, (short)43, argType, expected);
        return null;
    }

    public final JavaVariable process(VariableSym sym) {
        Expr e = sym.getExpressionSym();
        if (e != null) {
            JavaType lhsType = sym.getResolvedType();
            this.processConversion(lhsType, e, Conversions.ConversionType.ASSIGNMENT);
        }
        return sym;
    }

    private JavaVariable lookupExclusiveLocal(VariableSym cookie, String name) {
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return null;
        }
        Sym scope = context.cleanAndInitializeScope();
        if (scope == null) {
            return null;
        }
        while (scope != null && scope.symKind != 3) {
            JavaVariable foundVariable;
            if (scope.symKind != 18 && (foundVariable = context.findVariable(scope, name, true)) != null && foundVariable != cookie) {
                return foundVariable;
            }
            scope = context.nextScope();
        }
        return null;
    }

    protected final void processDuplicates(Collection variables) {
        HashMap<String, VariableSym> locals = null;
        for (VariableSym thing : variables) {
            VariableSym found;
            String name = thing.getName();
            if (locals == null) {
                locals = new HashMap<String, VariableSym>();
            }
            if ((found = (VariableSym)locals.get(name)) != null) {
                Sym cookie = thing;
                NameSym nameSym = thing.getNameSym();
                if (nameSym != null) {
                    cookie = nameSym;
                }
                this.error(cookie, (short)52, name, found);
            }
            locals.put(name, thing);
        }
    }

    protected final void processMethodDuplicates(Collection methods) {
        HashMap<String, ArrayList<MethodSym>> previousMethodList = new HashMap<String, ArrayList<MethodSym>>(methods.size());
        for (MethodSym method : methods) {
            String methodName = method.getName();
            List<MethodSym> previousMethods = (ArrayList<MethodSym>)previousMethodList.get(methodName);
            if (previousMethods == null) {
                previousMethods = new ArrayList<MethodSym>();
                previousMethodList.put(methodName, (ArrayList<MethodSym>)previousMethods);
            }
            previousMethods.add(method);
        }
        HashMap<String, MethodSym> methodSignatureList = new HashMap<String, MethodSym>();
        for (List<MethodSym> previousMethods : previousMethodList.values()) {
            if (previousMethods.size() <= 1) continue;
            for (int y = 0; y < previousMethods.size(); ++y) {
                MethodSym method = (MethodSym)previousMethods.get(y);
                String signature = CompilerLayer4.methodEquivalenceSignature(method);
                MethodSym previousMethod = (MethodSym)methodSignatureList.get(signature);
                if (previousMethod != null) {
                    JavaClass owner;
                    String errorName = method.isConstructor() ? ((owner = method.getOwningClass()) != null ? owner.getName() : method.getName()) : method.getName();
                    this.error(method, (short)52, errorName, previousMethod);
                    continue;
                }
                methodSignatureList.put(signature, method);
            }
            methodSignatureList.clear();
        }
        previousMethodList.clear();
    }

    private static String methodEquivalenceSignature(SourceMethod method) {
        StringBuilder buf = new StringBuilder();
        buf.append(method.getName());
        buf.append('(');
        List<SourceVariable> parameters = method.getSourceParameters();
        int bufLength = buf.length();
        for (int x = 0; x < parameters.size(); ++x) {
            JavaClass erasedType;
            JavaType paramType;
            SourceVariable parameter = parameters.get(x);
            if (x == 0 && method.getJdkVersion().isJdk8OrAbove() && "this".equals(parameter.getName()) || (paramType = parameter.getResolvedType()) == null || (erasedType = paramType.getTypeErasure()) == null) continue;
            if (buf.length() != bufLength) {
                buf.append(", ");
            }
            buf.append(erasedType.getTypeSignature());
        }
        buf.append(')');
        return buf.toString();
    }

    private void processConversion(JavaType lhsType, Expr e, Conversions.ConversionType conversionType) {
        Expr unwrappedExpr;
        if (e == null || lhsType == null) {
            return;
        }
        JavaType rhsType = e.getResolvedType();
        if (rhsType == null) {
            return;
        }
        for (unwrappedExpr = e; unwrappedExpr != null && unwrappedExpr.symKind == 65; unwrappedExpr = (Expr)unwrappedExpr.getNthChild((byte)90, 0)) {
        }
        if (unwrappedExpr != null) {
            JavaHasType hasType;
            lhsType = this.checkForLambdaLhs(unwrappedExpr, lhsType);
            if (unwrappedExpr.symKind == 67) {
                if (PrimitiveType.getVoidType().equals(lhsType) && !PrimitiveType.getVoidType().equals(rhsType)) {
                    this.error(e, (short)43, rhsType, lhsType);
                    return;
                }
            } else if (unwrappedExpr.symKind == 66 && PrimitiveType.getVoidType().equals(lhsType)) {
                return;
            }
            if (unwrappedExpr.symKind != 66 && unwrappedExpr.symKind != 67 && (hasType = e.getResolvedObject()) != null && hasType instanceof JavaType) {
                this.error(e, (short)74, hasType);
                return;
            }
        }
        Object constantRhsValue = e.getConstantValue();
        if (rhsType.isPrimitive() && ((PrimitiveType)rhsType).isIntegral() && constantRhsValue instanceof Number) {
            int value = ((Number)constantRhsValue).intValue();
            PrimitiveType primitiveLhs = this.getPrimitiveType(lhsType);
            if (primitiveLhs != null) {
                boolean constantValueError = false;
                boolean handled = false;
                switch (primitiveLhs.primCode) {
                    case 1: {
                        constantValueError = value > 127 || value < -128;
                        handled = true;
                        break;
                    }
                    case 2: {
                        constantValueError = value > 65535 || value < 0;
                        handled = true;
                        break;
                    }
                    case 3: {
                        constantValueError = value > Short.MAX_VALUE || value < Short.MIN_VALUE;
                        handled = true;
                    }
                }
                if (constantValueError) {
                    this.error(e, (short)43, rhsType, lhsType);
                    return;
                }
                if (handled) {
                    return;
                }
            }
        }
        if (conversionType == Conversions.ConversionType.ASSIGNMENT) {
            if (CompilerLayer4.applyAssignmentConversion(rhsType, e, lhsType, constantRhsValue != null, this.provider, this.jdkVersion)) {
                return;
            }
        } else {
            assert (conversionType == Conversions.ConversionType.METHOD);
            if (CompilerLayer4.applyMethodConversion(rhsType, lhsType, true, this.provider, this.jdkVersion)) {
                return;
            }
        }
        this.error(e, (short)43, rhsType, lhsType);
    }

    private PrimitiveType getPrimitiveType(JavaType type) {
        if (!type.isPrimitive()) {
            return PrimitiveType.applyUnboxingConversion(type, this.jdkVersion);
        }
        return (PrimitiveType)type;
    }

    public final void processExpressionStatements(ListExpr list) {
        if (list == null) {
            return;
        }
        for (Expr e : list.getOperands()) {
            this.processExpressionStatement(e);
        }
    }

    public final void processExpressionStatement(Expr e) {
        if (e == null) {
            return;
        }
        switch (e.symKind) {
            case 52: 
            case 57: 
            case 59: {
                return;
            }
            case 64: {
                switch (e.exprOptcode) {
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: {
                        return;
                    }
                }
            }
        }
        this.error(e, (short)55);
    }
}

