/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import java.util.Arrays;

public class Convert {
    public static String makeString(byte[] buf, int hibyte, int offset, int length) {
        return new String(buf, hibyte, offset, length);
    }

    public static String makeString(byte[] buf, int hibyte) {
        return Convert.makeString(buf, 0, 0, buf.length);
    }

    public static int digit2int(byte ch, int base) {
        if (48 <= ch && ch <= 57 && ch < 48 + base) {
            return ch - 48;
        }
        if (65 <= ch && ch < 65 + base - 10) {
            return ch - 65 + 10;
        }
        if (97 <= ch && ch < 97 + base - 10) {
            return ch - 97 + 10;
        }
        return -1;
    }

    public static byte int2digit(int x) {
        if (x <= 9) {
            return (byte)(x + 48);
        }
        return (byte)(x - 10 + 65);
    }

    public static byte[] source2ascii(byte[] source, int offset, int len) {
        byte[] destination = new byte[source.length * 2];
        int j = 0;
        int i = 0;
        block8: while (i < len) {
            byte b;
            if (source[offset + i] == 92 && i + 1 < len) {
                switch ((char)source[offset + ++i]) {
                    case 'n': {
                        destination[j++] = 10;
                        ++i;
                        continue block8;
                    }
                    case 't': {
                        destination[j++] = 9;
                        ++i;
                        continue block8;
                    }
                    case 'b': {
                        destination[j++] = 8;
                        ++i;
                        continue block8;
                    }
                    case 'r': {
                        destination[j++] = 13;
                        ++i;
                        continue block8;
                    }
                    case 'f': {
                        destination[j++] = 12;
                        ++i;
                        continue block8;
                    }
                    case 'u': {
                        int l;
                        for (l = i + 1; l < len && source[offset + l] == 117; ++l) {
                        }
                        if (l + 4 > len) break;
                        int code = 0;
                        int d = 0;
                        for (int k = 0; k < 4 && d >= 0; ++k) {
                            d = Convert.digit2int(source[offset + l + k], 16);
                            code = code * 16 + d;
                        }
                        if (d < 0) break;
                        if (code > 0 && code <= 127) {
                            destination[j++] = (byte)code;
                        } else if (code <= 2047) {
                            destination[j++] = (byte)(0xC0 | code >> 6);
                            destination[j++] = (byte)(0x80 | code & 0x3F);
                        } else {
                            destination[j++] = (byte)(0xE0 | code >> 12);
                            destination[j++] = (byte)(0x80 | code >> 6 & 0x3F);
                            destination[j++] = (byte)(0x80 | code & 0x3F);
                        }
                        i = l + 4;
                        continue block8;
                    }
                }
            }
            if ((b = source[offset + i++]) > 0) {
                destination[j++] = b;
                continue;
            }
            destination[j++] = (byte)(0xC0 | b >> 6 & 3);
            destination[j++] = (byte)(0x80 | b & 0x3F);
        }
        return Arrays.copyOfRange(destination, 0, j);
    }

    public static String ascii2string(byte[] ascii, int offset, int len) {
        char[] cs = new char[len];
        int i = 0;
        int j = 0;
        while (i < len) {
            int b;
            if ((b = ascii[offset + i++] & 0xFF) >= 224) {
                b = (b & 0xF) << 12;
                b |= (ascii[offset + i++] & 0x3F) << 6;
                b |= ascii[offset + i++] & 0x3F;
            } else if (b >= 192) {
                b = (b & 0x1F) << 6;
                b |= ascii[offset + i++] & 0x3F;
            }
            cs[j++] = (char)b;
        }
        return new String(cs, 0, j);
    }

    public static String source2string(byte[] source, int offset, int len) {
        byte[] destination = Convert.source2ascii(source, offset, len);
        return Convert.ascii2string(destination, 0, destination.length);
    }

    public static byte[] string2source(String s) {
        byte[] bytes = new byte[s.length() * 6];
        int j = 0;
        int len = s.length();
        block8: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': {
                    bytes[j++] = 92;
                    bytes[j++] = 110;
                    continue block8;
                }
                case '\t': {
                    bytes[j++] = 92;
                    bytes[j++] = 116;
                    continue block8;
                }
                case '\b': {
                    bytes[j++] = 92;
                    bytes[j++] = 98;
                    continue block8;
                }
                case '\r': {
                    bytes[j++] = 92;
                    bytes[j++] = 114;
                    continue block8;
                }
                case '\f': {
                    bytes[j++] = 92;
                    bytes[j++] = 102;
                    continue block8;
                }
                case '\\': {
                    bytes[j++] = 92;
                    bytes[j++] = 92;
                    continue block8;
                }
                default: {
                    if (' ' <= ch && ch <= '\u007f') {
                        bytes[j++] = (byte)ch;
                        continue block8;
                    }
                    bytes[j++] = 92;
                    bytes[j++] = 117;
                    bytes[j++] = Convert.int2digit(ch >> 12 & 0xF);
                    bytes[j++] = Convert.int2digit(ch >> 8 & 0xF);
                    bytes[j++] = Convert.int2digit(ch >> 4 & 0xF);
                    bytes[j++] = Convert.int2digit(ch & 0xF);
                }
            }
        }
        return Arrays.copyOfRange(bytes, 0, j);
    }

    public static byte[] string2ascii(String s) {
        byte[] bytes = Convert.string2source(s);
        return Convert.source2ascii(bytes, 0, bytes.length);
    }

    public static String escape(String s) {
        byte[] st = Convert.string2ascii(s);
        return Convert.makeString(st, 0, 0, st.length);
    }

    public static String escape(char c) {
        char[] s = new char[]{c};
        return Convert.escape(new String(s));
    }
}

