/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.BitSet;

public class EncoderUtils {
    private static final int _MAX_BYTES_PER_CHAR = 10;
    private static final BitSet _DONT_ENCODE_SET;
    private static final BitSet _DONT_ENCODE_SET_SMALL;

    public static String encodeURL(String text, String queryEncoding, boolean useISOForBody) throws UnsupportedEncodingException {
        StringWriter sw = new StringWriter(text.length());
        try {
            EncoderUtils.writeURL(sw, text, queryEncoding, useISOForBody);
        }
        catch (UnsupportedEncodingException uee) {
            throw uee;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    public static void writeURL(Writer out, String text, String queryEncoding, boolean useISOForBody) throws IOException, UnsupportedEncodingException {
        EncoderUtils._writeURL(out, text, queryEncoding, useISOForBody, 0, false);
    }

    public static void writeQueryParameters(Writer out, String text, String encoding, int start) throws IOException, UnsupportedEncodingException {
        EncoderUtils._encodeString(out, text, encoding, start, _DONT_ENCODE_SET, true);
    }

    public static String encodeUIXQueryParameter(String text) {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (!EncoderUtils._isSpecialQueryParameterChar(ch)) continue;
            StringBuffer buffer = new StringBuffer(text);
            buffer.setLength(i);
            EncoderUtils._appendUIXQueryParameter(buffer, text, i);
            return new String(buffer);
        }
        return text;
    }

    public static void appendUIXQueryParameter(StringBuffer buffer, String text) {
        buffer.append(text);
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (!EncoderUtils._isSpecialQueryParameterChar(ch)) continue;
            buffer.setLength(buffer.length() - (length - i));
            EncoderUtils._appendUIXQueryParameter(buffer, text, i);
            break;
        }
    }

    private static void _writeURL(Writer out, String text, String queryEncoding, boolean useISOForBody, int start, boolean inAnchor) throws IOException, UnsupportedEncodingException {
        int length = text.length();
        for (int i = start; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch < '!' || ch > '~') {
                int high;
                if (useISOForBody) {
                    EncoderUtils._writeDoubleHex(out, ch);
                    continue;
                }
                if (ch <= '\u007f') {
                    EncoderUtils._writeDoubleHex(out, ch);
                    continue;
                }
                if (ch <= '\u07ff') {
                    high = ch >> 6 | 0xC0;
                    int low = ch & 0x3F | 0x80;
                    EncoderUtils._writeDoubleHex(out, high);
                    EncoderUtils._writeDoubleHex(out, low);
                    continue;
                }
                if ((ch & 0xFC00) == 55296) {
                    int highSurrogate = ch & 0x3FF;
                    int wwww = (highSurrogate & 0x3C0) >> 6;
                    int uuuuu = wwww + 1;
                    int zzzz = (highSurrogate & 0x3C) >> 2;
                    int yyyyyy = (highSurrogate & 3) << 4 & 0x30;
                    ch = ++i < length ? text.charAt(i) : (char)'\u0000';
                    int lowSurrogate = ch & 0x3FF;
                    int xxxxxx = lowSurrogate & 0x3F;
                    int byte1 = 0xF0 | uuuuu >> 2;
                    int byte2 = 0x80 | (uuuuu & 3) << 4 & 0x30 | zzzz;
                    int byte3 = 0x80 | (yyyyyy |= (lowSurrogate & 0x3C0) >> 6);
                    int byte4 = 0x80 | xxxxxx;
                    EncoderUtils._writeDoubleHex(out, byte1);
                    EncoderUtils._writeDoubleHex(out, byte2);
                    EncoderUtils._writeDoubleHex(out, byte3);
                    EncoderUtils._writeDoubleHex(out, byte4);
                    continue;
                }
                high = ch >> 12 | 0xE0;
                int middle = (ch & 0xFC0) >> 6 | 0x80;
                int low = ch & 0x3F | 0x80;
                EncoderUtils._writeDoubleHex(out, high);
                EncoderUtils._writeDoubleHex(out, middle);
                EncoderUtils._writeDoubleHex(out, low);
                continue;
            }
            if (ch == '\"') {
                out.write("%22");
                continue;
            }
            if (ch == '?') {
                if (inAnchor) {
                    out.write("%3F");
                    continue;
                }
                out.write(63);
                EncoderUtils.writeQueryParameters(out, text, queryEncoding, i + 1);
                return;
            }
            out.write(ch);
        }
    }

    private static boolean _isSpecialQueryParameterChar(char ch) {
        return ch == '%' || ch == '+' || ch == '&' || ch == '#';
    }

    private static void _appendUIXQueryParameter(StringBuffer buffer, String text, int from) {
        int length = text.length();
        block6: for (int j = from; j < length; ++j) {
            char c = text.charAt(j);
            switch (c) {
                case '#': {
                    buffer.append("%23");
                    continue block6;
                }
                case '&': {
                    buffer.append("%26");
                    continue block6;
                }
                case '%': {
                    buffer.append("%25");
                    continue block6;
                }
                case '+': {
                    buffer.append("%2b");
                    continue block6;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
    }

    public static String encodeString(String text, String encoding) throws UnsupportedEncodingException {
        StringWriter sw = new StringWriter(text.length());
        try {
            EncoderUtils._encodeString(sw, text, encoding, 0, _DONT_ENCODE_SET_SMALL, false);
        }
        catch (UnsupportedEncodingException uee) {
            throw uee;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    public static String decodeString(String text) throws UnsupportedEncodingException {
        return EncoderUtils.decodeString(text, Charset.defaultCharset().name());
    }

    public static String decodeString(String text, String encoding) throws UnsupportedEncodingException {
        int firstPercent = text.indexOf(37);
        if (firstPercent < 0) {
            return text;
        }
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        buffer.append(text);
        buffer.setLength(firstPercent);
        byte[] bytes = null;
        int byteIndex = 0;
        for (int i = firstPercent; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch != '%') {
                if (byteIndex > 0) {
                    buffer.append(new String(bytes, 0, byteIndex, encoding));
                    byteIndex = 0;
                }
                buffer.append(ch);
                continue;
            }
            if (i + 2 < length) {
                byte b = (byte)(EncoderUtils._fromHex(text.charAt(i + 1)) << 4 | EncoderUtils._fromHex(text.charAt(i + 2)));
                if (encoding == null) {
                    buffer.append((char)b);
                } else {
                    if (bytes == null) {
                        bytes = new byte[10];
                    } else if (bytes.length == byteIndex) {
                        byte[] newBytes = new byte[byteIndex * 2];
                        System.arraycopy(bytes, 0, newBytes, 0, byteIndex);
                        bytes = newBytes;
                    }
                    bytes[byteIndex] = b;
                    ++byteIndex;
                }
            }
            i += 2;
        }
        if (byteIndex > 0) {
            buffer.append(new String(bytes, 0, byteIndex, encoding));
        }
        return buffer.toString();
    }

    private static void _encodeString(Writer out, String text, String encoding, int start, BitSet dontEncodeSet, boolean lookForAnchor) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream buf = null;
        OutputStreamWriter writer = null;
        char[] charArray = null;
        int length = text.length();
        for (int i = start; i < length; ++i) {
            char ch = text.charAt(i);
            if (lookForAnchor && '#' == ch) {
                out.write(ch);
                EncoderUtils._writeURL(out, text, encoding, false, i + 1, true);
                return;
            }
            if (dontEncodeSet.get(ch)) {
                out.write(ch);
                continue;
            }
            if (buf == null) {
                buf = new ByteArrayOutputStream(10);
                writer = encoding != null ? new OutputStreamWriter((OutputStream)buf, encoding) : new OutputStreamWriter(buf);
                charArray = new char[1];
            }
            try {
                charArray[0] = ch;
                writer.write(charArray, 0, 1);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                EncoderUtils._writeDoubleHex(out, ba[j] + 256);
            }
            buf.reset();
        }
    }

    private static void _writeDoubleHex(Writer out, int i) throws IOException {
        out.write(37);
        out.write(EncoderUtils._getHex((i >> 4) % 16));
        out.write(EncoderUtils._getHex(i % 16));
    }

    private static char _getHex(int i) {
        if (i < 10) {
            return (char)(48 + i);
        }
        return (char)(65 + (i - 10));
    }

    private static byte _fromHex(char ch) {
        if (ch >= '0' && ch <= '9') {
            return (byte)(ch - 48);
        }
        if (ch >= 'a' && ch <= 'f') {
            return (byte)(10 + (ch - 97));
        }
        return (byte)(10 + (ch - 65));
    }

    static {
        int i;
        _DONT_ENCODE_SET = new BitSet(256);
        _DONT_ENCODE_SET_SMALL = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            _DONT_ENCODE_SET.set(i);
            _DONT_ENCODE_SET_SMALL.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            _DONT_ENCODE_SET.set(i);
            _DONT_ENCODE_SET_SMALL.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            _DONT_ENCODE_SET.set(i);
            _DONT_ENCODE_SET_SMALL.set(i);
        }
        _DONT_ENCODE_SET.set(37);
        _DONT_ENCODE_SET.set(43);
        _DONT_ENCODE_SET.set(35);
        _DONT_ENCODE_SET.set(38);
        _DONT_ENCODE_SET.set(61);
        _DONT_ENCODE_SET.set(45);
        _DONT_ENCODE_SET_SMALL.set(45);
        _DONT_ENCODE_SET.set(95);
        _DONT_ENCODE_SET_SMALL.set(95);
        _DONT_ENCODE_SET.set(46);
        _DONT_ENCODE_SET_SMALL.set(46);
        _DONT_ENCODE_SET.set(42);
        _DONT_ENCODE_SET.set(126);
        _DONT_ENCODE_SET.set(47);
        _DONT_ENCODE_SET_SMALL.set(47);
        _DONT_ENCODE_SET.set(39);
        _DONT_ENCODE_SET.set(33);
        _DONT_ENCODE_SET.set(40);
        _DONT_ENCODE_SET.set(41);
    }
}

