/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.javatools.buffer.OffsetRegion;
import oracle.javatools.buffer.TextBuffer;

public final class OffsetRegionChain {
    private List<OffsetRegion> regions = new ArrayList<OffsetRegion>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegion(TextBuffer buffer, int start, int end) {
        assert (start <= end);
        buffer.readLock();
        try {
            ArrayList<OffsetRegion> removeRegions = new ArrayList<OffsetRegion>();
            for (OffsetRegion region : this.regions) {
                int rs = region.getStartOffset();
                int re = region.getEndOffset();
                if (re < start) continue;
                if (rs > end) break;
                if (start >= rs) {
                    if (end <= re) {
                        start = -1;
                        end = -1;
                        break;
                    }
                    if (start <= re) {
                        removeRegions.add(region);
                        start = rs;
                    }
                }
                if (end >= rs && end <= re) {
                    removeRegions.add(region);
                    end = re;
                }
                if (re > end) continue;
                removeRegions.add(region);
            }
            for (OffsetRegion region : removeRegions) {
                region.dispose();
                this.regions.remove(region);
            }
            if (start != -1 && end != -1) {
                this.regions.add(new OffsetRegion(buffer, start, end));
                Collections.sort(this.regions);
            }
        }
        finally {
            buffer.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegion(TextBuffer buffer, int start, int end) {
        buffer.readLock();
        ArrayList<OffsetRegion> newRegions = new ArrayList<OffsetRegion>();
        try {
            for (OffsetRegion region : this.regions) {
                int rs = region.getStartOffset();
                int re = region.getEndOffset();
                if (rs > end) {
                    newRegions.add(region);
                    continue;
                }
                if (re < start) {
                    newRegions.add(region);
                    continue;
                }
                if (rs < start && re >= start) {
                    newRegions.add(new OffsetRegion(buffer, rs, start - 1));
                }
                if (rs > end || re <= end) continue;
                newRegions.add(new OffsetRegion(buffer, end + 1, re));
            }
            Collections.sort(newRegions);
            this.regions.removeAll(newRegions);
            for (OffsetRegion region : this.regions) {
                region.dispose();
            }
            this.regions = newRegions;
        }
        finally {
            buffer.readUnlock();
        }
    }

    public boolean contains(int offset) {
        for (OffsetRegion region : this.regions) {
            if (!region.contains(offset)) continue;
            return true;
        }
        return false;
    }

    public List<OffsetRegion> getRegions() {
        return Collections.unmodifiableList(this.regions);
    }

    public boolean isOffsetAtRegionStart(int offset) {
        boolean isOffsetAtRegionStart = false;
        for (OffsetRegion region : this.regions) {
            if (!region.contains(offset)) continue;
            if (offset == region.getStartOffset()) {
                isOffsetAtRegionStart = true;
                continue;
            }
            return false;
        }
        return isOffsetAtRegionStart;
    }
}

