/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetDecoder;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.ArrayLineMap;
import oracle.javatools.buffer.DigestHash;
import oracle.javatools.buffer.EOLNormalizer;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.LinkedOffsetMark;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.buffer.UndoableTextEdit;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.util.NullArgumentException;
import oracle.javatools.util.UnexpectedExceptionError;

public abstract class AbstractTextBuffer
implements TextBuffer {
    protected static final char EOF_MARKER = '\uffff';
    protected static final char[] EMPTY_CHARS = new char[0];
    protected static String platformEOLType = "\r\n";
    private static final UndoableTextEdit START_EDIT = new UndoableTextEdit(null);
    private String bufferEOLType;
    private final CopyOnWriteArrayList<TextBufferListener> listenerList;
    private final LinkedOffsetMark marksListHead;
    protected final ReadWriteLock bufferLock;
    private boolean inChangeNotify;
    private ArrayLineMap lineMap;
    private UndoableTextEdit compoundEdit;
    private Throwable compoundEditStartTrace;
    private int nonModifiedChangeId;
    private int changeId;
    private boolean readOnlyMode;
    private boolean suppressUndo;
    private static final Logger LOG = Logger.getLogger(TextBuffer.class.getName());
    private static int globalNextId = 1001;
    private UndoState undoState;

    protected AbstractTextBuffer(ReadWriteLock lockToUse) {
        this.bufferLock = lockToUse;
        this.listenerList = new CopyOnWriteArrayList();
        this.marksListHead = new LinkedOffsetMark(-1, true);
        this.marksListHead.initializeHead();
        this.bufferEOLType = platformEOLType;
        this.inChangeNotify = false;
        this.lineMap = null;
        this.compoundEdit = null;
        this.readOnlyMode = false;
        this.nextChangeId();
        this.setSuppressUndo(false);
        this.clearModified();
        this.undoState = new UndoState(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readLock();
        try {
            this.readOnlyMode = readOnly;
            this.fireAttributeUpdate(2);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnlyMode;
    }

    @Override
    public abstract int getLength();

    @Override
    public abstract char getChar(int var1) throws IndexOutOfBoundsException;

    @Override
    public char[] getChars(int offset, int length) throws IndexOutOfBoundsException {
        if (length < 0) {
            if (length == 0) {
                return EMPTY_CHARS;
            }
            throw new IndexOutOfBoundsException("length " + length + " < 0");
        }
        return this.getCharsImpl(offset, length);
    }

    protected abstract char[] getCharsImpl(int var1, int var2) throws IndexOutOfBoundsException;

    @Override
    public String getString(int offset, int length) throws IndexOutOfBoundsException {
        return this.getStringImpl(offset, length);
    }

    protected abstract String getStringImpl(int var1, int var2) throws IndexOutOfBoundsException;

    @Override
    public void getText(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
        if (length == 0) {
            segment.array = EMPTY_CHARS;
            segment.offset = 0;
            segment.count = 0;
        } else {
            this.getTextImpl(offset, length, segment);
        }
    }

    protected abstract void getTextImpl(int var1, int var2, Segment var3) throws IndexOutOfBoundsException;

    @Override
    public UndoableEdit insert(int offset, char[] data) throws ReadOnlyException {
        try {
            EOLNormalizer normalizer = EOLNormalizer.getNormalizer(data);
            char[] normalizedData = normalizer.normalizeData();
            return this.normalizedInsert(offset, normalizedData);
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UndoableEdit normalizedInsert(int offset, char[] data) throws ReadOnlyException {
        UndoableTextEdit edit = null;
        if (data == null || data.length == 0) {
            return null;
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        boolean generateUndo = !this.isSuppressUndo();
        this.writeLock();
        try {
            if (generateUndo) {
                edit = new UndoableTextEdit(this.undoState);
                edit.recordStart();
            }
            this.insertImpl(offset, data);
            boolean modifiedChanged = this.nextChangeId();
            if (generateUndo) {
                edit.recordEdit(offset, data.length, data, true);
                edit.recordEnd();
                if (this.compoundEdit != null) {
                    if (this.compoundEdit == START_EDIT) {
                        this.compoundEdit = edit;
                    } else {
                        this.compoundEdit.addEdit(edit);
                    }
                    edit = null;
                }
            }
            this.fireInsertUpdate(offset, data, modifiedChanged);
        }
        finally {
            this.writeUnlock();
        }
        return edit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyInsert(int offset, char[] data, int oldChangeId) throws ReadOnlyException {
        if (data == null || data.length == 0) {
            throw new IllegalStateException("empty data");
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        if (this.compoundEdit != null) {
            throw new IllegalStateException("undo during edit not allowed", this.compoundEditStartTrace);
        }
        this.writeLock();
        try {
            this.insertImpl(offset, data);
            boolean modifiedChanged = this.setChangeId(oldChangeId);
            this.fireInsertUpdate(offset, data, modifiedChanged);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UndoableEdit append(char[] data) throws ReadOnlyException {
        UndoableEdit edit = null;
        this.writeLock();
        try {
            int offset = this.getLength();
            edit = this.insert(offset, data);
        }
        finally {
            this.writeUnlock();
        }
        return edit;
    }

    protected void insertImpl(int offset, char[] data) {
        this.insertImpl(offset, data, 0, data.length);
    }

    protected abstract void insertImpl(int var1, char[] var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInsertUpdate(int offset, char[] data, boolean fireModified) {
        this.inChangeNotify = true;
        try {
            int dataLength = data.length;
            if (this.lineMap != null) {
                this.lineMap.insertUpdate(offset, dataLength, data);
            }
            int markInsertOffset = offset == 0 ? 1 : offset;
            for (LinkedOffsetMark currentMark = this.marksListHead.nextMark(); currentMark != this.marksListHead; currentMark = currentMark.nextMark()) {
                currentMark.insertUpdate(markInsertOffset, dataLength);
            }
            if (fireModified) {
                this.fireAttributeUpdate(5);
            }
            for (TextBufferListener listener : this.listenerList) {
                try {
                    listener.insertUpdate(this, offset, dataLength, data);
                }
                catch (Throwable e) {
                    LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " inserting " + data.length + " at " + offset, e);
                }
            }
        }
        finally {
            this.inChangeNotify = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UndoableEdit remove(int offset, int count) throws ReadOnlyException {
        UndoableTextEdit edit = null;
        if (count == 0) {
            return null;
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        boolean generateUndo = !this.isSuppressUndo();
        this.writeLock();
        try {
            if (generateUndo) {
                edit = new UndoableTextEdit(this.undoState);
                edit.recordStart();
            }
            char[] data = this.getChars(offset, count);
            this.removeImpl(offset, count);
            boolean modifiedChanged = this.nextChangeId();
            if (generateUndo) {
                edit.recordEdit(offset, count, data, false);
                edit.recordEnd();
                if (this.compoundEdit != null) {
                    if (this.compoundEdit == START_EDIT) {
                        this.compoundEdit = edit;
                    } else {
                        this.compoundEdit.addEdit(edit);
                    }
                    edit = null;
                }
            }
            this.fireRemoveUpdate(offset, data, modifiedChanged);
        }
        finally {
            this.writeUnlock();
        }
        return edit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyRemove(int offset, char[] data, int oldChangeId) throws ReadOnlyException {
        if (data == null || data.length == 0) {
            throw new IllegalStateException("empty data");
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        if (this.compoundEdit != null) {
            throw new IllegalStateException("undo during edit not allowed");
        }
        this.writeLock();
        try {
            int count = data.length;
            this.removeImpl(offset, count);
            boolean modifiedChanged = this.setChangeId(oldChangeId);
            this.fireRemoveUpdate(offset, data, modifiedChanged);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UndoableEdit removeToEnd(int offset) throws ReadOnlyException {
        UndoableEdit edit = null;
        this.writeLock();
        try {
            int count = this.getLength() - offset;
            edit = this.remove(offset, count);
        }
        finally {
            this.writeUnlock();
        }
        return edit;
    }

    protected abstract void removeImpl(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoveUpdate(int offset, char[] data, boolean fireModified) {
        this.inChangeNotify = true;
        try {
            int dataLength = data.length;
            if (this.lineMap != null) {
                this.lineMap.removeUpdate(offset, dataLength, data);
            }
            for (LinkedOffsetMark currentMark = this.marksListHead.nextMark(); currentMark != this.marksListHead; currentMark = currentMark.nextMark()) {
                currentMark.removeUpdate(offset, dataLength);
            }
            if (fireModified) {
                this.fireAttributeUpdate(5);
            }
            for (TextBufferListener listener : this.listenerList) {
                try {
                    listener.removeUpdate(this, offset, dataLength, data);
                }
                catch (Throwable e) {
                    LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " removing " + data.length + " from " + offset, e);
                }
            }
        }
        finally {
            this.inChangeNotify = false;
        }
    }

    @Override
    public LineMap getLineMap() {
        if (this.lineMap == null) {
            this.readLock();
            try {
                this.lineMap = new ArrayLineMap(this);
            }
            finally {
                this.readUnlock();
            }
        }
        return this.lineMap;
    }

    @Override
    public void addTextBufferListener(TextBufferListener listener) {
        this.listenerList.addIfAbsent(listener);
    }

    @Override
    public void removeTextBufferListener(TextBufferListener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    public void readLock() {
        this.bufferLock.readLock();
    }

    @Override
    public void readLockInterruptibly() throws InterruptedException {
        this.bufferLock.readLockInterruptibly();
    }

    @Override
    public boolean tryReadLock() {
        return this.bufferLock.tryReadLock();
    }

    @Override
    public void readUnlock() {
        this.bufferLock.readUnlock();
    }

    @Override
    public int getLockStatus() {
        if (this.bufferLock.isWriteLockHeld()) {
            return 2;
        }
        if (this.bufferLock.isReadLockHeld()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void writeLock() throws ReadOnlyException {
        this.writeLock(true);
    }

    @Override
    public void writeLockInterruptibly() throws InterruptedException, ReadOnlyException {
        if (this.isReadOnly()) {
            throw new ReadOnlyException();
        }
        this.bufferLock.writeLockInterruptibly();
    }

    @Override
    public void writeLock(boolean checkIfReadOnly) throws ReadOnlyException {
        if (checkIfReadOnly && this.isReadOnly()) {
            throw new ReadOnlyException();
        }
        this.bufferLock.writeLock();
    }

    @Override
    public boolean tryWriteLock() throws ReadOnlyException {
        if (this.isReadOnly()) {
            throw new ReadOnlyException();
        }
        return this.bufferLock.tryWriteLock();
    }

    @Override
    public void writeUnlock() {
        this.bufferLock.writeUnlock();
    }

    @Override
    public boolean addWriteLockRequestListener(WriteLockRequestListener listener) {
        if (listener == null) {
            throw new NullArgumentException("null listener");
        }
        return this.bufferLock.addWriteLockRequestListener(listener);
    }

    @Override
    public void removeWriteLockRequestListener(WriteLockRequestListener listener) {
        if (listener == null) {
            throw new NullArgumentException("null listener");
        }
        this.bufferLock.removeWriteLockRequestListener(listener);
    }

    @Override
    public void beginEdit() throws ReadOnlyException {
        this.writeLock();
        if (this.compoundEdit != null) {
            this.writeUnlock();
            throw new IllegalStateException("Already in compound edit");
        }
        this.fireAttributeUpdate(6);
        this.compoundEditStartTrace = new Throwable("beginEdit diagnostic trace");
        this.compoundEdit = START_EDIT;
    }

    @Override
    public UndoableEdit endEdit() {
        if (this.compoundEdit == null) {
            throw new IllegalStateException("Not in compound edit");
        }
        UndoableTextEdit edit = null;
        if (this.compoundEdit != START_EDIT) {
            edit = this.compoundEdit;
        }
        this.compoundEdit = null;
        this.compoundEditStartTrace = null;
        this.fireAttributeUpdate(7);
        this.writeUnlock();
        return edit;
    }

    @Override
    public boolean isModified() {
        boolean isModified = this.nonModifiedChangeId != this.getChangeId();
        return isModified;
    }

    @Override
    public void clearModified() {
        this.clearModified(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearModified(boolean sendEvent) {
        int changeId = this.getChangeId();
        boolean wasModified = changeId != this.nonModifiedChangeId;
        this.nonModifiedChangeId = changeId;
        if (wasModified && sendEvent) {
            this.writeLock();
            try {
                this.fireAttributeUpdate(5);
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    @Override
    public int getChangeId() {
        return this.changeId;
    }

    private boolean setChangeId(int changeId) {
        boolean wasModified = this.isModified();
        this.changeId = changeId;
        return wasModified != this.isModified();
    }

    private static synchronized int requestNextChangeId() {
        return globalNextId++;
    }

    private boolean nextChangeId() {
        int nextId = AbstractTextBuffer.requestNextChangeId();
        return this.setChangeId(nextId);
    }

    private void setSuppressUndo(boolean suppressUndo) {
        this.suppressUndo = suppressUndo;
    }

    private boolean isSuppressUndo() {
        return this.suppressUndo;
    }

    @Override
    public void read(Reader reader) throws IOException {
        EOLNormalizer normalizer = EOLNormalizer.getNormalizer(reader);
        this.read(normalizer);
    }

    public void read(FileChannel channel, CharsetDecoder decoder) throws IOException {
        EOLNormalizer normalizer = EOLNormalizer.getNormalizer(channel, decoder);
        this.read(normalizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(EOLNormalizer normalizer) throws IOException {
        this.setReadOnly(false);
        this.writeLock();
        try {
            if (this.compoundEdit != null) {
                throw new IllegalStateException("no read() during compound edit");
            }
            this.fireAttributeUpdate(3);
            try {
                this.setSuppressUndo(true);
                this.removeToEnd(0);
                char[] data = normalizer.normalizeData();
                this.normalizedInsert(0, data);
                String normalizedEOLType = normalizer.getEOLType();
                if (!platformEOLType.equals(normalizedEOLType) || this.getEOLType() != normalizedEOLType) {
                    this.setEOLType(normalizedEOLType);
                }
                this.clearModified();
                this.setSuppressUndo(false);
            }
            finally {
                this.fireAttributeUpdate(4);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UndoableEdit insert(int offset, Reader reader) throws IOException, ReadOnlyException {
        UndoableEdit edit = null;
        this.writeLock();
        try {
            EOLNormalizer normalizer = EOLNormalizer.getNormalizer(reader);
            char[] data = normalizer.normalizeData();
            edit = this.normalizedInsert(offset, data);
        }
        finally {
            this.writeUnlock();
        }
        return edit;
    }

    @Override
    public void write(Writer writer) throws IOException {
        this.write(writer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Writer writer, boolean clearModified) throws IOException {
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        this.readLock();
        try {
            int length;
            int lineEnd;
            int lineStart;
            if (this.compoundEdit != null) {
                throw new IllegalStateException("no write() during compound edit", this.compoundEditStartTrace);
            }
            Segment segment = new Segment();
            LineMap lineMap = this.getLineMap();
            int lineCount = lineMap.getLineCount() - 1;
            for (int i = 0; i < lineCount; ++i) {
                lineStart = lineMap.getLineStartOffset(i);
                lineEnd = lineMap.getLineEndOffset(i) - 1;
                length = lineEnd - lineStart;
                if (length > 0) {
                    this.getText(lineStart, length, segment);
                    writer.write(segment.array, segment.offset, segment.count);
                }
                writer.write(this.bufferEOLType);
            }
            lineStart = lineMap.getLineStartOffset(lineCount);
            lineEnd = lineMap.getLineEndOffset(lineCount);
            length = lineEnd - lineStart;
            if (length > 0) {
                this.getText(lineStart, length, segment);
                writer.write(segment.array, segment.offset, segment.count);
            }
            writer.close();
        }
        finally {
            this.readUnlock();
        }
        boolean wasModified = this.isModified();
        int wasModifiedId = this.getChangeId();
        if (clearModified && wasModified) {
            this.bufferLock.writeLockFromReadLock();
            try {
                if (wasModifiedId == this.getChangeId()) {
                    this.clearModified(true);
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    @Override
    public String getPlatformEOLType() {
        return platformEOLType;
    }

    @Override
    public String getEOLType() {
        return this.bufferEOLType;
    }

    @Override
    public void setEOLType(String eolType) throws ReadOnlyException {
        this.writeLock();
        try {
            this.bufferEOLType = eolType;
            this.fireAttributeUpdate(1);
        }
        finally {
            this.writeUnlock();
        }
    }

    void fireAttributeUpdate(int attribute) {
        for (TextBufferListener listener : this.listenerList) {
            try {
                listener.attributeUpdate(this, attribute);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " updating attribute  " + attribute, e);
            }
        }
    }

    @Override
    public OffsetMark addOffsetMark(int offset) {
        return this.addOffsetMark(offset, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OffsetMark addOffsetMark(int offset, boolean bias) {
        LinkedOffsetMark newMark = null;
        this.readLock();
        try {
            newMark = new LinkedOffsetMark(offset, bias);
            LinkedOffsetMark linkedOffsetMark = this.marksListHead;
            synchronized (linkedOffsetMark) {
                newMark.attachBefore(this.marksListHead);
            }
        }
        finally {
            this.readUnlock();
        }
        return newMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOffsetMark(OffsetMark offsetMark) {
        this.readLock();
        try {
            LinkedOffsetMark linkedOffsetMark = this.marksListHead;
            synchronized (linkedOffsetMark) {
                LinkedOffsetMark linkedMark = (LinkedOffsetMark)offsetMark;
                linkedMark.detach();
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UndoState detachUndoState() {
        this.writeLock(false);
        try {
            boolean success = this.undoState.detachAndSaveState();
            UndoState savedState = success ? this.undoState : null;
            this.undoState = new UndoState(this);
            UndoState undoState = savedState;
            return undoState;
        }
        finally {
            this.writeUnlock();
        }
    }

    protected UndoState copyUndoState() {
        UndoState state = new UndoState(this);
        state.detachAndSaveState();
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean attachUndoState(UndoState state) {
        if (state == null) {
            return false;
        }
        this.writeLock(false);
        try {
            boolean success = state.attachAndRestoreState(this);
            if (success) {
                this.undoState.detachAndDiscard();
                this.undoState = state;
            }
            boolean bl = success;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    static {
        String lineSeparator = System.getProperty("line.separator");
        if (lineSeparator != null && lineSeparator.length() == 1) {
            char c = lineSeparator.charAt(0);
            platformEOLType = c == '\r' ? "\r" : "\n";
        }
    }

    public static final class UndoState {
        private AbstractTextBuffer _textBuffer;
        private int _changeId;
        private DigestHash _digestHash;

        UndoState(AbstractTextBuffer textBuffer) {
            this._textBuffer = textBuffer;
            this._digestHash = null;
            this._changeId = -1;
        }

        AbstractTextBuffer getTextBuffer() {
            return this._textBuffer;
        }

        private void detachAndDiscard() {
            this._textBuffer = null;
            this._digestHash = null;
        }

        private boolean detachAndSaveState() {
            if (this._textBuffer == null) {
                throw new IllegalStateException("state already detached");
            }
            this._changeId = this._textBuffer.getChangeId();
            this._digestHash = DigestHash.computeDigestHash(this._textBuffer);
            this._textBuffer = null;
            return this._digestHash != null;
        }

        private boolean attachAndRestoreState(AbstractTextBuffer textBuffer) {
            if (this._textBuffer != null) {
                throw new IllegalStateException("state already attached");
            }
            if (this._digestHash == null) {
                return false;
            }
            DigestHash currentHash = DigestHash.computeDigestHash(textBuffer);
            if (!currentHash.equals(this._digestHash)) {
                return false;
            }
            this._textBuffer = textBuffer;
            textBuffer.setChangeId(this._changeId);
            textBuffer.clearModified(false);
            this._digestHash = null;
            return true;
        }

        public String toString() {
            return "UndoState (buffer " + this._textBuffer + ", id " + this._changeId + ")";
        }
    }
}

