/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.table.TableCellEditor;
import oracle.dbtools.raptor.controls.listtable.ListTableModel;
import oracle.javatools.icons.OracleIcons;

public class OLAPListTableModel<T>
extends ListTableModel<T> {
    public OLAPListTableModel(String[] stringArray, String[] stringArray2) {
        super(stringArray, stringArray2);
    }

    public AbstractAction getMoveSelectedFirstAction() {
        return this.getMoveSelectedFirstAction(null);
    }

    public AbstractAction getMoveSelectedFirstAction(Icon icon) {
        AbstractAction abstractAction = new AbstractAction("", icon == null ? OracleIcons.getIcon((String)"first.png") : icon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OLAPListTableModel.this.moveSelectedFirst();
            }

            @Override
            public boolean isEnabled() {
                return OLAPListTableModel.this.isMovePrevFirstEnabled();
            }
        };
        return abstractAction;
    }

    private boolean isMovePrevFirstEnabled() {
        return this.isEditable() && 0 < this.getRowSelection().min();
    }

    private void moveSelectedFirst() {
        if (this.isMovePrevFirstEnabled()) {
            this._stopEditingInTable();
            ListTableModel.IndexRange indexRange = this.getRowSelection();
            for (int i = indexRange.size(); i > 0; --i) {
                this.getRowList().add(0, this.getRowList().remove(indexRange.max()));
            }
            this.fireTableDataChanged();
            this.getTable().setRowSelectionInterval(0, indexRange.size() - 1);
        }
    }

    public AbstractAction getMoveSelectedPreviousAction() {
        return this.getMoveSelectedPreviousAction(null);
    }

    public AbstractAction getMoveSelectedPreviousAction(Icon icon) {
        AbstractAction abstractAction = new AbstractAction("", icon == null ? OracleIcons.getIcon((String)"previous.png") : icon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OLAPListTableModel.this.moveSelectedPrevious();
            }

            @Override
            public boolean isEnabled() {
                return OLAPListTableModel.this.isMovePrevFirstEnabled();
            }
        };
        return abstractAction;
    }

    private void moveSelectedPrevious() {
        if (this.isMovePrevFirstEnabled()) {
            this._stopEditingInTable();
            ListTableModel.IndexRange indexRange = this.getRowSelection();
            this.getRowList().add(indexRange.max(), this.getRowList().remove(indexRange.min() - 1));
            this.fireTableDataChanged();
            this.getTable().setRowSelectionInterval(indexRange.min() - 1, indexRange.max() - 1);
        }
    }

    public AbstractAction getMoveSelectedNextAction() {
        return this.getMoveSelectedNextAction(null);
    }

    public AbstractAction getMoveSelectedNextAction(Icon icon) {
        AbstractAction abstractAction = new AbstractAction("", icon == null ? OracleIcons.getIcon((String)"next.png") : icon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OLAPListTableModel.this.moveSelectedNext();
            }

            @Override
            public boolean isEnabled() {
                return OLAPListTableModel.this.isMoveNextLastEnabled();
            }
        };
        return abstractAction;
    }

    private boolean isMoveNextLastEnabled() {
        ListTableModel.IndexRange indexRange = this.getRowSelection();
        return this.isEditable() && 0 < indexRange.size() && indexRange.max() < this.getRowList().size() - 1;
    }

    private void moveSelectedNext() {
        if (this.isMoveNextLastEnabled()) {
            this._stopEditingInTable();
            ListTableModel.IndexRange indexRange = this.getRowSelection();
            this.getRowList().add(indexRange.min(), this.getRowList().remove(indexRange.max() + 1));
            this.fireTableDataChanged();
            this.getTable().setRowSelectionInterval(indexRange.min() + 1, indexRange.max() + 1);
        }
    }

    public AbstractAction getMoveSelectedLastAction() {
        return this.getMoveSelectedLastAction(null);
    }

    public AbstractAction getMoveSelectedLastAction(Icon icon) {
        AbstractAction abstractAction = new AbstractAction("", icon == null ? OracleIcons.getIcon((String)"last.png") : icon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OLAPListTableModel.this.moveSelectedLast();
            }

            @Override
            public boolean isEnabled() {
                return OLAPListTableModel.this.isMoveNextLastEnabled();
            }
        };
        return abstractAction;
    }

    private void moveSelectedLast() {
        if (this.isMoveNextLastEnabled()) {
            int n;
            this._stopEditingInTable();
            ListTableModel.IndexRange indexRange = this.getRowSelection();
            for (n = indexRange.size(); n > 0; --n) {
                this.getRowList().add(this.getRowList().remove(indexRange.min()));
            }
            this.fireTableDataChanged();
            n = this.getRowList().size() - 1;
            int n2 = n - (indexRange.size() - 1);
            this.getTable().setRowSelectionInterval(n2, n);
        }
    }

    private void _stopEditingInTable() {
        if (this.getTable().isEditing()) {
            int n = this.getTable().getEditingRow();
            int n2 = this.getTable().getEditingColumn();
            TableCellEditor tableCellEditor = this.getTable().getCellEditor(n, n2);
            boolean bl = tableCellEditor.stopCellEditing();
        }
    }

    protected Object getValueAt(T t, int n) {
        return null;
    }

    protected void setValueAt(Object object, T t, int n) {
    }

    protected boolean isCellEditable(T t, int n) {
        return false;
    }
}

