/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.timegen;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.util.Namespace;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;
import oracle.olap.actions.OLAPObjectHelper;
import oracle.olap.app.db.Database;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.model.CubeDimensionAttributeMap;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.model.CubeDimensionMap;
import oracle.olap.db.CubeSQL;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.timegen.TimeDimensionGenerator;
import oracle.olap.timegen.model.TimeGenAttribute;
import oracle.olap.timegen.model.TimeGenLevel;
import oracle.olap.timegen.timexml.Time;
import oracle.olap.timegen.timexml.TimeColumn;
import oracle.olap.timegen.timexml.TimeLevel;

public class TimeDimensionGeneratorDDL
implements TimeDimensionGenerator {
    @Override
    public boolean generateTimeDimension(Time time, Namespace namespace) throws Exception {
        boolean bl = true;
        DBObjectProvider dBObjectProvider = (DBObjectProvider)namespace.get("DBOBJECTPROVIDER");
        SystemObject systemObject = null;
        SystemObject systemObject2 = null;
        DDL dDL = this.createTimeDimensionDDL(time, namespace, (CubeDimension)systemObject2, (CubeDimension)systemObject);
        Collection collection = dDL.getStatements();
        boolean bl2 = false;
        CubeSQL cubeSQL = new CubeSQL((DDLDatabase)dBObjectProvider, bl2, systemObject2, systemObject, collection, true);
        String string = cubeSQL.execute();
        if (dBObjectProvider instanceof AbstractDatabase) {
            AbstractDatabase abstractDatabase = (AbstractDatabase)dBObjectProvider;
            SystemObject[] systemObjectArray = new SystemObject[]{systemObject2};
            SystemObject[] systemObjectArray2 = new SystemObject[]{systemObject};
            Difference difference = dBObjectProvider.getDiffEngine().difference((Object)systemObjectArray, (Object)systemObjectArray2);
            abstractDatabase.finishUpdates(difference);
        }
        return bl;
    }

    private DDL createTimeDimensionDDL(Time time, Namespace namespace, CubeDimension cubeDimension, CubeDimension cubeDimension2) throws Exception {
        DDL dDL = null;
        String string = (String)namespace.get("ANALYTIC_WORKSPACE");
        String string2 = (String)namespace.get("SCHEMA");
        oracle.javatools.db.Schema schema = new oracle.javatools.db.Schema(string2);
        String string3 = (String)namespace.get("DIMENSION_NAME");
        DBObject dBObject = (DBObject)namespace.get("DBOBJECT");
        Database database = (Database)namespace.get("DATABASE");
        DBObjectProvider dBObjectProvider = (DBObjectProvider)namespace.get("DBOBJECTPROVIDER");
        Connection connection = database.getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        String string4 = dBUtil.getConnectionResolver().getConnectionName(connection);
        Schema schema2 = OLAPMetadataCache.getUpdatedSchema(string4, string2);
        Dimension dimension = schema2.findDimension(string3);
        if (dimension == null) {
            cubeDimension2 = new CubeDimension();
            cubeDimension2.setAnalyticWorkspace(string);
            cubeDimension2.setSchema(schema);
            cubeDimension2.setName(string3);
            cubeDimension2.generateDescriptions();
            cubeDimension2.setHierarchyConsistencyRule("CONSISTENT");
            cubeDimension2.setAddUniqueKeys(true);
            cubeDimension2.setDimensionType("TIME");
        } else {
            cubeDimension = OLAPObjectHelper.loadDimension(dBObject, string3);
            cubeDimension2 = (CubeDimension)cubeDimension.copyTo(null, false);
        }
        this.createAttributes(cubeDimension2, time, namespace);
        this.createDimLevelsAndMap(cubeDimension2, time, namespace);
        DDLGenerator dDLGenerator = dBObjectProvider.getDDLGenerator();
        if (cubeDimension == null) {
            oracle.javatools.db.DBObject[] dBObjectArray = new oracle.javatools.db.DBObject[]{cubeDimension2};
            dDL = dDLGenerator.getCreateDDL(new DDLOptions(), dBObjectArray);
        } else {
            ResultSet resultSet = dBObjectProvider.getDiffEngine().diff((Object)cubeDimension, (Object)cubeDimension2).getResult();
            dDL = dDLGenerator.getUpdateDDL(new DDLOptions(), (Difference)resultSet);
        }
        return dDL;
    }

    private void createAttributes(CubeDimension cubeDimension, Time time, Namespace namespace) {
        List<TimeLevel> list = time.getTimeLevels();
        List list2 = (List)namespace.get("LEVELS");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TimeLevel timeLevel : list) {
            String string = timeLevel.getName();
            for (TimeGenLevel timeGenLevel : list2) {
                if (!string.equalsIgnoreCase(timeGenLevel.getName()) || !timeGenLevel.isSelected().booleanValue()) continue;
                List<TimeColumn> list3 = timeLevel.getTimeColumns();
                for (TimeColumn timeColumn : list3) {
                    String string2 = timeColumn.getAttribute();
                    List<TimeGenAttribute> list4 = timeGenLevel.getAttributes();
                    for (TimeGenAttribute timeGenAttribute : list4) {
                        if (!string2.equalsIgnoreCase(timeGenAttribute.getType()) || !timeGenAttribute.isSelected().booleanValue() || arrayList.contains(string2) || string2.equalsIgnoreCase("ID")) continue;
                        arrayList.add(string2);
                        CubeDimensionAttribute cubeDimensionAttribute = cubeDimension.findAttribute(string2);
                        if (cubeDimensionAttribute != null) continue;
                        String string3 = timeColumn.getAttributeDescription();
                        cubeDimensionAttribute = new CubeDimensionAttribute(string2);
                        cubeDimension.addAttribute(cubeDimensionAttribute);
                        if (string2.equalsIgnoreCase("LONG_DESCRIPTION") || string2.equalsIgnoreCase("SHORT_DESCRIPTION") || string2.equalsIgnoreCase("DESCRIPTION") || string2.equalsIgnoreCase("TIME_SPAN") || string2.equalsIgnoreCase("END_DATE")) {
                            cubeDimensionAttribute.setAttributeVisibleForAll(true);
                        } else {
                            cubeDimensionAttribute.setAttributeVisibleForAll(false);
                        }
                        cubeDimensionAttribute.setDescription(string3);
                        cubeDimensionAttribute.setLongDescription(string3);
                        cubeDimensionAttribute.setShortDescription(string3);
                        cubeDimensionAttribute.setIndex(true);
                        cubeDimensionAttribute.setDataType(timeColumn.getDataType());
                        if (string2.equalsIgnoreCase("LONG_DESCRIPTION")) {
                            cubeDimensionAttribute.setRole("LONG_DESCRIPTION");
                            cubeDimensionAttribute.setPersistedOrSpecial(true);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("SHORT_DESCRIPTION")) {
                            cubeDimensionAttribute.setRole("SHORT_DESCRIPTION");
                            cubeDimensionAttribute.setPersistedOrSpecial(true);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("DESCRIPTION")) {
                            cubeDimensionAttribute.setRole("description");
                            cubeDimensionAttribute.setPersistedOrSpecial(true);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("TIME_SPAN")) {
                            cubeDimensionAttribute.setRole("TIME_SPAN");
                            cubeDimensionAttribute.setPersistedOrSpecial(true);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("END_DATE")) {
                            cubeDimensionAttribute.setRole("END_DATE");
                            cubeDimensionAttribute.setPersistedOrSpecial(true);
                            continue;
                        }
                        if (!string2.equalsIgnoreCase("ID")) continue;
                    }
                }
            }
        }
    }

    private void createDimLevelsAndMap(CubeDimension cubeDimension, Time time, Namespace namespace) {
        String string = (String)namespace.get("TABLE_NAME");
        List<TimeLevel> list = time.getTimeLevels();
        List list2 = (List)namespace.get("LEVELS");
        String string2 = (String)namespace.get("HIERARCHY_NAME");
        boolean bl = true;
        if (cubeDimension.getHierarchies().length > 0) {
            bl = false;
        }
        CubeDimensionHierarchy cubeDimensionHierarchy = new CubeDimensionHierarchy(string2);
        cubeDimensionHierarchy.generateDescriptions();
        cubeDimensionHierarchy.setHierarchyDefault(bl);
        cubeDimensionHierarchy.setNotRagged(true);
        cubeDimensionHierarchy.setNotSkipLevel(true);
        cubeDimension.addHierarchy(cubeDimensionHierarchy);
        ArrayList<CubeDimensionHierarchyLevel> arrayList = new ArrayList<CubeDimensionHierarchyLevel>();
        for (TimeLevel timeLevel : list) {
            String string3 = timeLevel.getName();
            for (TimeGenLevel timeGenLevel : list2) {
                CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel;
                CubeDimensionLevel cubeDimensionLevel;
                if (!string3.equalsIgnoreCase(timeGenLevel.getName()) || !timeGenLevel.isSelected().booleanValue()) continue;
                if (!timeGenLevel.isShared().booleanValue()) {
                    string3 = String.format("%s_%s", string2, string3);
                }
                if ((cubeDimensionLevel = cubeDimension.findLevel(string3)) == null) {
                    cubeDimensionLevel = new CubeDimensionLevel(string3);
                    cubeDimensionLevel.generateDescriptions();
                    cubeDimension.addLevel(cubeDimensionLevel);
                }
                if ((cubeDimensionHierarchyLevel = cubeDimensionHierarchy.findHierarchyLevel(string3)) == null) {
                    cubeDimensionHierarchyLevel = new CubeDimensionHierarchyLevel(cubeDimensionHierarchy, cubeDimensionLevel);
                }
                arrayList.add(cubeDimensionHierarchyLevel);
                List<TimeColumn> list3 = timeLevel.getTimeColumns();
                for (TimeColumn timeColumn : list3) {
                    String string4 = timeColumn.getAttribute();
                    List<TimeGenAttribute> list4 = timeGenLevel.getAttributes();
                    for (TimeGenAttribute timeGenAttribute : list4) {
                        String[] stringArray;
                        AbstractChildDBObject abstractChildDBObject;
                        AbstractChildObjectWithDesc abstractChildObjectWithDesc;
                        if ((!string4.equalsIgnoreCase(timeGenAttribute.getType()) || !timeGenAttribute.isSelected().booleanValue()) && !string4.equalsIgnoreCase("ID")) continue;
                        String string5 = timeColumn.getColumn();
                        string5 = string + "." + string5;
                        if (string4.equalsIgnoreCase("ID")) {
                            abstractChildObjectWithDesc = cubeDimensionHierarchyLevel;
                            if (abstractChildObjectWithDesc == null) continue;
                            abstractChildDBObject = ((CubeDimensionHierarchyLevel)abstractChildObjectWithDesc).getMap();
                            if (abstractChildDBObject == null) {
                                abstractChildDBObject = new CubeDimensionMap(cubeDimension);
                            }
                            abstractChildDBObject.setKeyExpression(string5);
                            stringArray = string5.split("\\.");
                            abstractChildDBObject.setMapQuery(stringArray[0]);
                            if (abstractChildDBObject == null) continue;
                            ((CubeDimensionHierarchyLevel)abstractChildObjectWithDesc).setMap((CubeDimensionMap)abstractChildDBObject);
                            continue;
                        }
                        abstractChildObjectWithDesc = cubeDimension.findAttribute(string4);
                        if (!(string4.equalsIgnoreCase("LONG_DESCRIPTION") || string4.equalsIgnoreCase("SHORT_DESCRIPTION") || string4.equalsIgnoreCase("DESCRIPTION") || string4.equalsIgnoreCase("TIME_SPAN") || string4.equalsIgnoreCase("END_DATE"))) {
                            cubeDimensionHierarchyLevel.addVisibleAttribute((CubeDimensionAttribute)abstractChildObjectWithDesc);
                            ((CubeDimensionAttribute)abstractChildObjectWithDesc).setAttributeVisibleForAll(false);
                        }
                        if ((abstractChildDBObject = cubeDimensionHierarchyLevel) == null) continue;
                        stringArray = abstractChildDBObject.getMap();
                        CubeDimensionAttributeMap cubeDimensionAttributeMap = null;
                        if (stringArray == null) continue;
                        cubeDimensionAttributeMap = stringArray.findAttributeMap(string4);
                        if (cubeDimensionAttributeMap == null && string5 != null) {
                            cubeDimensionAttributeMap = new CubeDimensionAttributeMap((CubeDimensionAttribute)abstractChildObjectWithDesc, string5);
                            stringArray.addAttributeMap(cubeDimensionAttributeMap);
                        }
                        if (cubeDimensionAttributeMap != null && string5 != null) {
                            cubeDimensionAttributeMap.setMapExpression(string5);
                        }
                        if (cubeDimensionAttributeMap == null || string5 != null) continue;
                        stringArray.removeAttributeMap(cubeDimensionAttributeMap);
                    }
                }
            }
        }
        cubeDimensionHierarchy.setHierarchyLevels(arrayList.toArray(new CubeDimensionHierarchyLevel[arrayList.size()]));
    }

    public String getTimeDimensionSQL(Time time, Namespace namespace) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)namespace.get("DBOBJECTPROVIDER");
        String string = null;
        SystemObject systemObject = null;
        SystemObject systemObject2 = null;
        DDL dDL = null;
        try {
            dDL = this.createTimeDimensionDDL(time, namespace, (CubeDimension)systemObject2, (CubeDimension)systemObject);
            Collection collection = dDL.getStatements();
            boolean bl = false;
            CubeSQL cubeSQL = new CubeSQL((DDLDatabase)dBObjectProvider, bl, systemObject2, systemObject, collection, false);
            string = cubeSQL.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

