/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.security;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.db.model.AbstractOLAPDBObjectBuilder;
import oracle.olap.db.view.CubeAWUtil;
import oracle.olap.security.AccessControlEntry;
import oracle.olap.security.RealmConstraint;

public class RealmConstraintBuilder
extends AbstractOLAPDBObjectBuilder<RealmConstraint> {
    public RealmConstraintBuilder(OracleDatabaseImpl oracleDatabaseImpl) {
        super((AbstractDBObjectProvider)oracleDatabaseImpl, "REALM CONSTRAINT");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    public RealmConstraint createObject(String string, Schema schema, DBObjectID dBObjectID) {
        RealmConstraint realmConstraint = new RealmConstraint();
        realmConstraint.setName(string);
        realmConstraint.setSchema(schema);
        realmConstraint.setID(dBObjectID);
        return realmConstraint;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"policy", "realmOrder", "realmType", "realmStatic", "realmCondition", "description", "aces", "analyticWorkspace", "realmParentObject"})
    public void build(final RealmConstraint realmConstraint) throws DBException {
        realmConstraint.clearAces();
        String string = CubeAWUtil.getAnalyticWorkspaceName();
        realmConstraint.setAnalyticWorkspace(string);
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), "select rc.POLICY POLICY, rc.REALM_ORDER REALM_ORDER, rc.REALM_TYPE REALM_TYPE, rc.STATIC STATIC,  rc.realm REALM_COND, acl.description DESCRIPTION, acl.parent_acl PARENT_ACL  from sys.xs$olap_policy op, user_xs_realm_constraints rc, user_xs_acls acl  where op.policy_name = rc.policy and acl.name = ACL and acl.name=? and op.schema_name=?  order by op.schema_name, op.logical_name, rc.acl ", new Object[]{realmConstraint.getName(), realmConstraint.getSchema()});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        String string = resultSet.getString("POLICY");
                        BigDecimal bigDecimal = resultSet.getBigDecimal("REALM_ORDER");
                        int n = bigDecimal.intValue();
                        String string2 = resultSet.getString("REALM_TYPE");
                        String string3 = resultSet.getString("STATIC");
                        boolean bl = false;
                        if (string3.equalsIgnoreCase("STATIC")) {
                            bl = true;
                        }
                        String string4 = resultSet.getString("REALM_COND");
                        String string5 = resultSet.getString("DESCRIPTION");
                        String string6 = resultSet.getString("PARENT_ACL");
                        realmConstraint.setPolicy(string);
                        realmConstraint.setRealmOrder(n);
                        realmConstraint.setRealmType(string2);
                        realmConstraint.setRealmStatic(bl);
                        realmConstraint.setRealmCondition(string4);
                        realmConstraint.setDescription(string5);
                        realmConstraint.setParentObject(string6);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)realmConstraint, sQLException);
                }
            }
        });
        final QueryWrapper queryWrapper2 = new QueryWrapper((Database)this.getProvider(), "select ae.ACL ACL, ae.ACE_ORDER ACE_ORDER, ae.start_date START_DATE, ae.END_DATE END_DATE, ae.GRANT_TYPE GRANT_TYPE, ae.INVERTED_PRINCIPAL INVERTED_PRINCIPAL, ae.PRINCIPAL PRINCIPAL, ae.PRINCIPAL_TYPE PRINCIPAL_TYPE, ae.PRIVILEGE PRIVILEGE, ae.SECURITY_CLASS SECURITY_CLASS, ae.SECURITY_CLASS_OWNER SECURITY_CLASS_OWNER from sys.xs$olap_policy op, user_xs_realm_constraints rc, user_xs_acls acl, user_xs_aces ae where op.policy_name = rc.policy and acl.name = rc.ACL and rc.ACL = ae.ACL and acl.name=? and op.schema_name=? order by op.schema_name, op.logical_name, rc.acl, ae.principal ", new Object[]{realmConstraint.getName(), realmConstraint.getSchema()});
        queryWrapper2.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString("ACL");
                        Timestamp timestamp = resultSet.getTimestamp("START_DATE");
                        Timestamp timestamp2 = resultSet.getTimestamp("END_DATE");
                        String string2 = resultSet.getString("GRANT_TYPE");
                        String string3 = resultSet.getString("INVERTED_PRINCIPAL");
                        String string4 = resultSet.getString("PRINCIPAL");
                        String string5 = resultSet.getString("PRINCIPAL_TYPE");
                        String string6 = resultSet.getString("PRIVILEGE");
                        String string7 = resultSet.getString("SECURITY_CLASS");
                        String string8 = resultSet.getString("SECURITY_CLASS_OWNER");
                        BigDecimal bigDecimal = resultSet.getBigDecimal("ACE_ORDER");
                        int n = bigDecimal.intValue();
                        AccessControlEntry accessControlEntry = new AccessControlEntry(string, n, timestamp, timestamp2, string2, string3, string4, string5, string6, string7, string8);
                        realmConstraint.addAce(accessControlEntry);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper2.throwDBException((DBObject)realmConstraint, sQLException);
                }
            }
        });
    }
}

