/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.measure;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.Database;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.olap.OLAPResources;
import oracle.olap.app.Resources;
import oracle.olap.measure.CheckBoxTreeTable;
import oracle.olap.measure.MeasureSelector;
import oracle.olap.measure.MeasureTreeTableModel;
import oracle.olap.measurefolder.model.MeasureFolder;
import oracle.olap.measurefolder.model.MeasureID;

public class MeasureSelectorTreeTablePanel
extends BaseEditorPanel<MeasureFolder>
implements MeasureSelector,
SearchListener {
    private CheckBoxTreeTable m_treeTable;
    private MeasureTreeTableModel m_treeTableModel;
    private SearchField searchField;
    private JLabel filterLabel;
    private String owner;
    private Connection conn;
    private transient Logger LOG = Logger.getLogger(MeasureSelectorTreeTablePanel.class.getName());
    Resources resources = new OLAPResources();

    private void initUI() {
        Database database = (Database)this.getProvider();
        try {
            this.owner = database.getUserName();
            this.conn = database.getConnection();
            this.m_treeTableModel = new MeasureTreeTableModel(this.conn, this.owner);
            this.m_treeTableModel.populateTableDataModelAW(((MeasureFolder)this.getUpdatedObject()).getAnalyticWorkspace());
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
        this.m_treeTable = new CheckBoxTreeTable(this.m_treeTableModel);
        this.filterLabel = new JLabel();
        this.filterLabel.setName("filterLabel");
        this.searchField = new SearchField(SearchField.Style.FIND);
        this.searchField.setName("searchField");
        this.searchField.setAllowEmptySearch(true);
        this.searchField.addSearchListener((SearchListener)this);
        ResourceUtils.resLabel((JLabel)this.filterLabel, (Component)this.searchField, (String)this.resources.getString("SOURCE_SELECTION_DIALOG_FILTER_LABEL"));
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.m_treeTable, 30, 20);
        this.add(this.filterLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.searchField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(jScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    protected void initialisePanel() {
        List<MeasureID> list;
        this.removeAll();
        this.initUI();
        if (this.isEditing()) {
            this.m_treeTable.expandAll(true);
        }
        ((MeasureFolder)this.getUpdatedObject()).addObjectListener(new DBObjectListener(){

            public void objectUpdated(DBObjectChange dBObjectChange) {
                Map map = dBObjectChange.getPropertiesChanged();
                for (String string : map.keySet()) {
                    if (!string.equals("analyticWorkspace")) continue;
                    MeasureSelectorTreeTablePanel.this.removeAll();
                    MeasureSelectorTreeTablePanel.this.initUI();
                }
            }
        });
        if (this.isEditing() && (list = Arrays.asList(((MeasureFolder)this.getUpdatedObject()).getMeasures())) != null) {
            this.m_treeTable.setSelection(list);
        }
    }

    public void searchPerformed(SearchEvent searchEvent) {
        String string = searchEvent.getSearchText();
        this.m_treeTable.filter(string);
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
    }

    protected void commitPanel() throws TraversalException {
        List<MeasureID> list = this.m_treeTable.getSelection();
        ((MeasureFolder)this.getUpdatedObject()).clearMeasures();
        for (MeasureID measureID : list) {
            ((MeasureFolder)this.getUpdatedObject()).addMeasure(measureID);
        }
    }
}

