/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.editor;

import oracle.dbtools.raptor.runner.debug.RaptorDebuggingHelper;
import oracle.dbtools.raptor.runner.debug.jdi.DBJDIFileSystemHelperFactory;
import oracle.ide.Addin;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeListener;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.olap.dml.editor.OLAPDMLBufferPinning;
import oracle.olap.dml.editor.OLAPDMLPinningTracker;
import oracle.olap.dml.editor.OLAPDMLShowCompilePage;
import oracle.olap.dml.editor.language.OLAPDMLLanguageModule;
import oracle.olap.navigator.olapdml.OLAPDMLNode;

public class OLAPDMLAddin
implements Addin {
    private static final String ACCELERATOR_FILE = "oracle/olap/dml/editor/accelerators.xml";
    private EditorListener restoreEditorPluginSettings = new EditorListener(){

        private void restoreEditorPluginSettings(Editor editor) {
            if (editor.getContext() != null && editor.getContext().getNode() != null && editor.getContext().getNode() instanceof OLAPDMLNode) {
                OLAPDMLNode oLAPDMLNode = (OLAPDMLNode)editor.getContext().getNode();
                PlSqlFeatures.setSupportedBreadcrumbs((boolean)oLAPDMLNode.isBreadcrumbsOn());
                PlSqlFeatures.setSupportedGutterNavigation((boolean)oLAPDMLNode.isGutterNavOn());
            }
        }

        public void editorOpened(Editor editor) {
            this.restoreEditorPluginSettings(editor);
        }

        public void editorActivated(Editor editor) {
        }

        public void editorDeactivated(Editor editor) {
        }

        public void editorClosed(Editor editor) {
        }
    };

    public void initialize() {
        DBJDIFileSystemHelperFactory.initialize();
        RaptorDebuggingHelper.initialize();
        new OLAPDMLLanguageModule();
        this.addOLAPDMLEditorListener();
        this.addOLAPDMLNodeListener();
    }

    private void addOLAPDMLEditorListener() {
        EditorManager.getEditorManager().addEditorListener(this.restoreEditorPluginSettings);
        EditorManager.getEditorManager().addEditorListener((EditorListener)new OLAPDMLPinningTracker());
        EditorManager.getEditorManager().addEditorListener((EditorListener)new OLAPDMLShowCompilePage());
    }

    private void addOLAPDMLNodeListener() {
        Node.addNodeListenerForType(OLAPDMLNode.class, (NodeListener)new OLAPDMLBufferPinning());
    }
}

