/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db.view;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.OLAPArb;
import oracle.olap.db.BaseCubeVerifier;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.AbstractMappableSchemaObjectWithDesc;
import oracle.olap.db.view.ChildNameObjectEditorContext;
import oracle.olap.util.UIStringUtils;

public abstract class OLAPBaseChildTablePanel<C extends AbstractChildObjectWithDesc, P extends AbstractMappableSchemaObjectWithDesc>
extends ChildTableEditorPanel<C, P> {
    private int nameColumnIndex = 0;
    private int shortLabelColumnIndex = 1;
    private int longLabelColumnIndex = 2;
    private int descriptionColumnIndex = 3;
    protected DBObjectProvider prov;
    protected BaseCubeVerifier verifier;
    protected boolean upcaseNameFlag = false;
    private boolean isPanelInitialized = false;
    private int nameFieldKeyTyped = 0;

    public OLAPBaseChildTablePanel(String string) {
        super(string);
        this.init();
    }

    protected abstract void init();

    protected void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
    }

    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        super.initialisePanel();
        if (!this.isPanelInitialized) {
            this.scrollToFirstRow();
        }
        this.isPanelInitialized = true;
    }

    protected String[] getPropertiesForRow() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public C newChild() {
        AbstractChildObjectWithDesc abstractChildObjectWithDesc = (AbstractChildObjectWithDesc)super.newChild();
        return (C)abstractChildObjectWithDesc;
    }

    protected void initialiseComponents() {
        super.initialiseComponents();
    }

    protected void scrollToFirstRow() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GenericTable genericTable = OLAPBaseChildTablePanel.this.getWrapperTable();
                if (genericTable.getParent() instanceof JViewport) {
                    genericTable.changeSelection(0, 0, false, false);
                    genericTable.scrollToSelection();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void initialiseTableComponents() {
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                OLAPBaseChildTablePanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return c.getName();
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic2 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                OLAPBaseChildTablePanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return ((AbstractChildObjectWithDesc)c).getDescription();
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic3 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                OLAPBaseChildTablePanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return ((AbstractChildObjectWithDesc)c).getShortDescription();
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic4 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                OLAPBaseChildTablePanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return ((AbstractChildObjectWithDesc)c).getLongDescription();
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        this.addColumn(this.nameColumnIndex, OLAPArb.get("NAMESPACE_CONFLICT_PANEL_NAME_LABEL"), String.class, nonPropertyColumnLogic);
        this.addColumn(this.shortLabelColumnIndex, OLAPArb.get("DESCRIPTION_PANEL_SHORT_LABEL"), String.class, nonPropertyColumnLogic3);
        this.addColumn(this.longLabelColumnIndex, OLAPArb.get("DESCRIPTION_PANEL_LONG_LABEL"), String.class, nonPropertyColumnLogic4);
        this.addColumn(this.descriptionColumnIndex, OLAPArb.get("DESCRIPTION_PANEL_DESCRIPTION"), String.class, nonPropertyColumnLogic2);
    }

    protected void setRowPropertyValue(Object object, int n, int n2) {
        ChildTableEditorPanel.RowInfo rowInfo = this.getWrapperTableModel().getRow(n);
        AbstractChildObjectWithDesc abstractChildObjectWithDesc = (AbstractChildObjectWithDesc)rowInfo.getRowObject();
        if (n2 == this.nameColumnIndex) {
            String string = (String)object;
            abstractChildObjectWithDesc.setName(string.toUpperCase());
            if (this.upcaseNameFlag) {
                this.updateNameToUppercase(string.toUpperCase(), n, this.nameColumnIndex);
                this.upcaseNameFlag = false;
            }
            return;
        }
        if (n2 == this.shortLabelColumnIndex) {
            String string = (String)object;
            abstractChildObjectWithDesc.setShortDescription(string);
            return;
        }
        if (n2 == this.longLabelColumnIndex) {
            String string = (String)object;
            abstractChildObjectWithDesc.setLongDescription(string);
            return;
        }
        if (n2 == this.descriptionColumnIndex) {
            String string = (String)object;
            abstractChildObjectWithDesc.setDescription(string);
            return;
        }
    }

    protected void setNameColumnIndex(int n) {
        this.nameColumnIndex = n;
        this.shortLabelColumnIndex = n + 1;
        this.longLabelColumnIndex = n + 2;
        this.descriptionColumnIndex = n + 3;
    }

    protected int getNameColumnIndex() {
        return this.nameColumnIndex;
    }

    protected int getShortLabelColumnIndex() {
        return this.shortLabelColumnIndex;
    }

    protected int getLongLabelColumnIndex() {
        return this.longLabelColumnIndex;
    }

    protected int getDescriptionColumnIndex() {
        return this.descriptionColumnIndex;
    }

    protected void updateNameToUppercase(String string, int n, int n2) {
        final String string2 = string;
        final int n3 = n;
        final int n4 = n2;
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    String string = (String)OLAPBaseChildTablePanel.this.getWrapperTableModel().getValueAt(n3, n4);
                    String string22 = (String)string2;
                    if (string22 != null && string22.equalsIgnoreCase(string)) {
                        OLAPBaseChildTablePanel.this.getWrapperTableModel().setValueAt(string2, n3, n4);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(thread);
    }

    protected boolean isHorizontalSplit() {
        return false;
    }

    protected boolean preserveListOrder() {
        return false;
    }

    protected class MyBaseCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected JTextField cellTextField = new JTextField();
        protected AbstractChildObjectWithDesc abstractChildObjectWithDesc;
        protected int row;
        protected int column;
        protected KeyAdapter ka = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                OLAPBaseChildTablePanel.this.nameFieldKeyTyped = keyEvent.getKeyCode();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (MyBaseCellEditor.this.abstractChildObjectWithDesc == null) {
                    keyEvent.consume();
                    return;
                }
                if (MyBaseCellEditor.this.column == OLAPBaseChildTablePanel.this.nameColumnIndex && (keyEvent.getKeyChar() == ' ' || keyEvent.getKeyChar() == '.' || keyEvent.getKeyChar() == '\"')) {
                    Toolkit.getDefaultToolkit().beep();
                    keyEvent.consume();
                    return;
                }
                if (keyEvent.getKeyChar() == '\u001b') {
                    return;
                }
            }
        };
        protected DocumentListener dl = new DocumentListener(){

            public void common() {
                if (MyBaseCellEditor.this.abstractChildObjectWithDesc == null || MyBaseCellEditor.this.column != OLAPBaseChildTablePanel.this.nameColumnIndex) {
                    return;
                }
                if (!OLAPBaseChildTablePanel.this.isEditing() || MyBaseCellEditor.this.abstractChildObjectWithDesc.getNewObject()) {
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    String string = MyBaseCellEditor.this.cellTextField.getText();
                    if (string == null) {
                        return;
                    }
                    if (string.length() == 0 && OLAPBaseChildTablePanel.this.nameFieldKeyTyped != 8) {
                        return;
                    }
                    ChildNameObjectEditorContext childNameObjectEditorContext = ChildNameObjectEditorContext.getInstance();
                    int n = childNameObjectEditorContext.getEditingState();
                    if (n == 1) {
                        return;
                    }
                    String string2 = (String)OLAPBaseChildTablePanel.this.getWrapperTableModel().getValueAt(MyBaseCellEditor.this.row, OLAPBaseChildTablePanel.this.descriptionColumnIndex);
                    String string3 = (String)OLAPBaseChildTablePanel.this.getWrapperTableModel().getValueAt(MyBaseCellEditor.this.row, OLAPBaseChildTablePanel.this.longLabelColumnIndex);
                    String string4 = (String)OLAPBaseChildTablePanel.this.getWrapperTableModel().getValueAt(MyBaseCellEditor.this.row, OLAPBaseChildTablePanel.this.shortLabelColumnIndex);
                    if (OLAPBaseChildTablePanel.this.nameFieldKeyTyped == 8) {
                        if (string2.length() > 0) {
                            string2 = string2.substring(0, string2.length() - 1);
                            bl3 = true;
                        }
                        if (string3.length() > 0) {
                            string3 = string3.substring(0, string3.length() - 1);
                            bl2 = true;
                        }
                        if (string4.length() > 0) {
                            string4 = string4.substring(0, string4.length() - 1);
                            bl = true;
                        }
                    } else {
                        if (string.length() == string2.length() + 1) {
                            string2 = string2 + string.substring(string.length() - 1, string.length());
                            bl6 = true;
                        }
                        if (string.length() == string3.length() + 1) {
                            string3 = string3 + string.substring(string.length() - 1, string.length());
                            bl5 = true;
                        }
                        if (string.length() == string4.length() + 1) {
                            string4 = string4 + string.substring(string.length() - 1, string.length());
                            bl4 = true;
                        }
                    }
                    boolean bl7 = string2 != null && UIStringUtils.isObjectNameAndDescriptionEqual(string, string2);
                    boolean bl8 = string3 != null && UIStringUtils.isObjectNameAndDescriptionEqual(string, string3);
                    boolean bl9 = string4 != null && UIStringUtils.isObjectNameAndDescriptionEqual(string, string4);
                    boolean bl10 = false;
                    boolean bl11 = false;
                    boolean bl12 = false;
                    if (MyBaseCellEditor.this.abstractChildObjectWithDesc.getDescriptionDirty().booleanValue()) {
                        bl10 = true;
                    }
                    if (MyBaseCellEditor.this.abstractChildObjectWithDesc.getShortDescriptionDirty().booleanValue()) {
                        bl11 = true;
                    }
                    if (MyBaseCellEditor.this.abstractChildObjectWithDesc.getLongDescriptionDirty().booleanValue()) {
                        bl12 = true;
                    }
                    if (!bl9) {
                        if (!bl11 || string4.length() == 0 && string.length() < 2 && n == 0) {
                            OLAPBaseChildTablePanel.this.getWrapperTableModel().setValueAt((Object)UIStringUtils.convertDescription(string), MyBaseCellEditor.this.row, OLAPBaseChildTablePanel.this.shortLabelColumnIndex);
                            MyBaseCellEditor.this.abstractChildObjectWithDesc.markShortDescriptionDirty(false);
                        }
                    } else if (bl || bl4) {
                        string4 = UIStringUtils.convertDescription(string4);
                        OLAPBaseChildTablePanel.this.getWrapperTableModel().setValueAt((Object)string4, MyBaseCellEditor.this.row, OLAPBaseChildTablePanel.this.shortLabelColumnIndex);
                    }
                    if (!bl8) {
                        if (!bl12 || string3.length() == 0 && string.length() < 2 && n == 0) {
                            OLAPBaseChildTablePanel.this.getWrapperTableModel().setValueAt((Object)UIStringUtils.convertDescription(string), MyBaseCellEditor.this.row, OLAPBaseChildTablePanel.this.longLabelColumnIndex);
                            MyBaseCellEditor.this.abstractChildObjectWithDesc.markLongDescriptionDirty(false);
                        }
                    } else if (bl2 || bl5) {
                        string3 = UIStringUtils.convertDescription(string3);
                        OLAPBaseChildTablePanel.this.getWrapperTableModel().setValueAt((Object)string3, MyBaseCellEditor.this.row, OLAPBaseChildTablePanel.this.longLabelColumnIndex);
                    }
                    if (!bl7) {
                        if (!bl10 || string2.length() == 0 && string.length() < 2 && n == 0) {
                            OLAPBaseChildTablePanel.this.getWrapperTableModel().setValueAt((Object)UIStringUtils.convertDescription(string), MyBaseCellEditor.this.row, OLAPBaseChildTablePanel.this.descriptionColumnIndex);
                            MyBaseCellEditor.this.abstractChildObjectWithDesc.markDescriptionDirty(false);
                        }
                    } else if (bl3 || bl6) {
                        string2 = UIStringUtils.convertDescription(string2);
                        OLAPBaseChildTablePanel.this.getWrapperTableModel().setValueAt((Object)string2, MyBaseCellEditor.this.row, OLAPBaseChildTablePanel.this.descriptionColumnIndex);
                    }
                }
                OLAPBaseChildTablePanel.this.nameFieldKeyTyped = 0;
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.common();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.common();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.common();
            }
        };

        public MyBaseCellEditor() {
            this.cellTextField.addKeyListener(this.ka);
            this.cellTextField.getDocument().addDocumentListener(this.dl);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.column = n2;
            ChildTableEditorPanel.RowInfo rowInfo = OLAPBaseChildTablePanel.this.getWrapperTableModel().getRow(n);
            this.abstractChildObjectWithDesc = (AbstractChildObjectWithDesc)rowInfo.getRowObject();
            this.cellTextField.setText((String)object);
            return this.cellTextField;
        }

        @Override
        public Object getCellEditorValue() {
            String string = this.cellTextField.getText();
            return string;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.column == OLAPBaseChildTablePanel.this.longLabelColumnIndex) {
                if (this.abstractChildObjectWithDesc.getNewObject()) {
                    this.abstractChildObjectWithDesc.markLongDescriptionDirty(true);
                }
            } else if (this.column == OLAPBaseChildTablePanel.this.shortLabelColumnIndex) {
                if (this.abstractChildObjectWithDesc.getNewObject()) {
                    this.abstractChildObjectWithDesc.markShortDescriptionDirty(true);
                }
            } else if (this.column == OLAPBaseChildTablePanel.this.descriptionColumnIndex && this.abstractChildObjectWithDesc.getNewObject()) {
                this.abstractChildObjectWithDesc.markDescriptionDirty(true);
            }
            return super.stopCellEditing();
        }
    }
}

