/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db.model;

import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.property.Transient;
import oracle.olap.db.model.DescriptionGenerator;
import oracle.olap.db.model.LanguageDescription;
import oracle.olap.db.model.LanguageDescriptionsHelper;
import oracle.olap.db.model.StatefulDescriptions;

public abstract class AbstractSchemaObjectWithDesc
extends AbstractSchemaObject
implements StatefulDescriptions,
LanguageDescriptionsHelper {
    private boolean skipValidation;
    private boolean fullyLoaded;

    @Transient
    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    @Transient
    public void setFullyLoaded(boolean bl) {
        this.fullyLoaded = bl;
    }

    public void generateDescriptions() {
        String string = DescriptionGenerator.generate(this.getName());
        this.setProperty("description", string);
        this.setProperty("shortDescription", string);
        this.setProperty("longDescription", string);
    }

    public void setAnalyticWorkspace(String string) {
        this.setProperty("analyticWorkspace", string);
    }

    public String getAnalyticWorkspace() {
        return (String)this.getProperty("analyticWorkspace");
    }

    @Transient
    public String getFullAWName() {
        String string = (String)this.getProperty("analyticWorkspace");
        if (string != null && this.getSchema() != null) {
            String string2 = String.format("%s.%s", this.getSchema().getName(), string);
            return string2;
        }
        return null;
    }

    public boolean isAnalyticWorkspaceRequiredForDDL() {
        return false;
    }

    @Override
    public void setDescription(String string) {
        if (string != null && string.isEmpty() && this.getDescription() == null) {
            return;
        }
        this.setProperty("description", string);
    }

    @Override
    public String getDescription() {
        String string = (String)this.getProperty("description");
        return string;
    }

    @Override
    public void setShortDescription(String string) {
        if (string != null && string.isEmpty() && this.getShortDescription() == null) {
            return;
        }
        this.setProperty("shortDescription", string);
    }

    @Override
    public String getShortDescription() {
        return (String)this.getProperty("shortDescription");
    }

    @Override
    public void setLongDescription(String string) {
        if (string != null && string.isEmpty() && this.getLongDescription() == null) {
            return;
        }
        this.setProperty("longDescription", string);
    }

    @Override
    public String getLongDescription() {
        String string = (String)this.getProperty("longDescription");
        return string;
    }

    public void setSkipValidation(boolean bl) {
        this.skipValidation = bl;
    }

    public boolean isSkipValidation() {
        return this.skipValidation;
    }

    @Override
    public void markDescriptionDirty(boolean bl) {
        this.setProperty("descriptionDirty", bl);
    }

    @Override
    public void markShortDescriptionDirty(boolean bl) {
        this.setProperty("shortDescriptionDirty", bl);
    }

    @Override
    public void markLongDescriptionDirty(boolean bl) {
        this.setProperty("longDescriptionDirty", bl);
    }

    @Override
    public Boolean getDescriptionDirty() {
        return (Boolean)this.getProperty("descriptionDirty");
    }

    @Override
    public Boolean getShortDescriptionDirty() {
        return (Boolean)this.getProperty("shortDescriptionDirty");
    }

    @Override
    public Boolean getLongDescriptionDirty() {
        return (Boolean)this.getProperty("longDescriptionDirty");
    }

    @Override
    public void addLanguageDescription(LanguageDescription languageDescription) {
        this.getChildSupport("languageDescriptions").addChild((Object)languageDescription);
    }

    @Override
    public LanguageDescription[] getLanguageDescriptions() {
        return (LanguageDescription[])this.getChildSupport("languageDescriptions").getChildArray(LanguageDescription.class);
    }

    @Override
    public void setLanguageDescriptions(LanguageDescription[] languageDescriptionArray) {
        this.getChildSupport("languageDescriptions").setChildArray((Object[])languageDescriptionArray);
    }

    @Override
    public void removeLanguageDescription(LanguageDescription languageDescription) {
        this.getChildSupport("languageDescriptions").removeChild((Object)languageDescription);
    }

    @Override
    public void removeAllLanguageDescriptions() {
        this.getChildSupport("languageDescriptions").clearChildren();
    }

    @Override
    public LanguageDescription findLanguageDescription(String string) {
        LanguageDescription[] languageDescriptionArray;
        for (LanguageDescription languageDescription : languageDescriptionArray = this.getLanguageDescriptions()) {
            if (!languageDescription.getLanguage().equalsIgnoreCase(string)) continue;
            return languageDescription;
        }
        return null;
    }
}

