/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubeviewer;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.javatools.util.Pair;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.app.olapmetadata.SubDimension;
import oracle.olap.db.IdentifierElement;
import oracle.olap.hierarchyviewer.HierarchyET;

public class CubeET {
    private Connection conn;
    private Cube cube;
    private List<String> dimDepths;
    private Map<String, HierarchyET> dimHierarchyETMap;
    private Map<Measure, Boolean> measureSelectedMap;
    private DBUtil dbutil;
    private int numRows;
    private boolean allMeasures;

    public CubeET(Connection connection, Cube cube, int n, boolean bl) throws SQLException, IOException {
        this(connection, cube, n, Collections.EMPTY_LIST, Collections.EMPTY_LIST, bl);
    }

    public CubeET(Connection connection, Cube cube, int n, List<Measure> list, List<DimensionHierarchy> list2, boolean bl) throws SQLException, IOException {
        this.conn = connection;
        this.cube = cube;
        this.dimDepths = new ArrayList<String>();
        this.measureSelectedMap = new LinkedHashMap<Measure, Boolean>();
        this.dimHierarchyETMap = new HashMap<String, HierarchyET>();
        this.dbutil = DBUtil.getInstance((Connection)connection);
        this.dbutil.setRaiseError(true);
        this.numRows = n;
        this.allMeasures = bl;
        this.init(list, list2);
    }

    public void setNumRows(int n) {
        this.numRows = n;
    }

    private void init(List<Measure> list, List<DimensionHierarchy> list2) throws SQLException, IOException {
        if (list != null && !list.isEmpty()) {
            for (Measure iterator : list) {
                this.measureSelectedMap.put(iterator, true);
            }
        } else {
            boolean bl = true;
            if (!this.allMeasures && this.cube.getMeasures().size() > 10) {
                bl = false;
            }
            for (Measure measure : this.cube.getMeasures()) {
                boolean bl2 = true;
                if (!bl && measure.isDerived()) {
                    bl2 = false;
                }
                this.measureSelectedMap.put(measure, bl2);
            }
        }
        Object object = null;
        if (list2 != null && !list2.isEmpty()) {
            object = list2.get(0);
        }
        for (Dimension dimension : this.cube.getDimensions()) {
            String string = null;
            String string2 = dimension.getName();
            Object object2 = dimension.getDefaultHierarchy();
            if (object2 == null && dimension.getHierarchies().size() > 0) {
                object2 = dimension.getHierarchies().get(0);
            }
            if (object != null && ((SubDimension)object).getDimension().getName().equalsIgnoreCase(string2)) {
                object2 = object;
            }
            if (object2 == null) {
                this.dimDepths.add(dimension.getName());
                continue;
            }
            string = ((NamedObject)object2).getName();
            if (((DimensionHierarchy)object2).getHierarchyLevels().size() == 0) {
                this.dimDepths.add(String.format("%s=1", ((SubDimension)object2).getID()));
                continue;
            }
            DimensionHierarchyLevel dimensionHierarchyLevel = ((DimensionHierarchy)object2).getHierarchyLevels().get(0);
            this.dimDepths.add(dimensionHierarchyLevel.getID());
        }
    }

    public boolean getAllMeasures() {
        return this.allMeasures;
    }

    public Map<Measure, Boolean> getMeasureSelectedMap() {
        return this.measureSelectedMap;
    }

    public Cube getCube() {
        return this.cube;
    }

    public List<String> getDimensionDepths() {
        return this.dimDepths;
    }

    public void setDimensionDepths(List<String> list) {
        this.dimDepths = list;
    }

    public String getCubeSql() {
        String string;
        String string2;
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select \n");
        for (Dimension namedObjectWithDesc : this.cube.getDimensions()) {
            string3 = namedObjectWithDesc.getName();
            string2 = namedObjectWithDesc.getDefaultView();
            string = namedObjectWithDesc.getDisplayColumnName();
            stringBuffer.append("  ");
            if (namedObjectWithDesc.isFlat()) {
                stringBuffer.append(String.format("%s.%s as \"%s\"", string2, string, string3));
            } else {
                stringBuffer.append(String.format("lpad(' ', %s.depth * 2) || %s.%s as \"%s\"", string2, string2, string, string3));
            }
            stringBuffer.append(",\n");
        }
        for (Measure measure : this.measureSelectedMap.keySet()) {
            if (!this.measureSelectedMap.get(measure).booleanValue()) continue;
            string3 = measure.getColumnName();
            stringBuffer.append(String.format("  round(%s, 2) %s,\n", string3, string3));
        }
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length() - 1);
        stringBuffer.append(" from ");
        stringBuffer.append(this.cube.getViewName());
        stringBuffer.append(",");
        for (Dimension dimension : this.cube.getDimensions()) {
            string3 = dimension.getName();
            string2 = dimension.getDefaultView();
            stringBuffer.append("  ");
            stringBuffer.append(string2);
            stringBuffer.append(",\n");
        }
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length() - 1);
        stringBuffer.append(" where ");
        for (Dimension dimension : this.cube.getDimensions()) {
            string3 = dimension.getName();
            string2 = dimension.getDefaultView();
            string = this.cube.getDimensionColumn(string3);
            stringBuffer.append(this.cube.getViewName() + "." + string);
            stringBuffer.append(" = ");
            stringBuffer.append(string2 + ".dim_key");
            stringBuffer.append(" and \n");
            if (dimension.isFlat()) continue;
            stringBuffer.append(String.format("    %s.depth < %s", string2, this.getDepth(string3)));
            stringBuffer.append(" and \n");
        }
        stringBuffer.delete(stringBuffer.length() - 6, stringBuffer.length());
        if (this.numRows != -1) {
            stringBuffer.append(String.format(" \n and rownum <= %s \n ", this.numRows));
        }
        stringBuffer.append("\n order by ");
        for (Dimension dimension : this.cube.getDimensions()) {
            string3 = dimension.getDefaultView();
            if (dimension.isFlat()) {
                stringBuffer.append(String.format("  %s.dim_order,\n", string3));
                continue;
            }
            stringBuffer.append(String.format("  %s.hier_order,\n", string3));
        }
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        return stringBuffer.toString();
    }

    public Dimension getDimensionFromDepth(String string) {
        IdentifierElement identifierElement = new IdentifierElement(string);
        if (identifierElement.getCount() >= 0) {
            String string2 = identifierElement.getFirst();
            return this.cube.findDimension(string2);
        }
        return null;
    }

    public DimensionHierarchy getHierarchyFromDepth(String string) {
        IdentifierElement identifierElement = new IdentifierElement(string);
        if (identifierElement.getCount() > 0) {
            String string2 = identifierElement.getFirst();
            Dimension dimension = this.cube.findDimension(string2);
            if (identifierElement.getCount() > 1) {
                String string3 = identifierElement.getSecond();
                DimensionHierarchy dimensionHierarchy = dimension.findHierarchy(string3);
                return dimensionHierarchy;
            }
        }
        return null;
    }

    public Object getObjectFromDepth(String string) {
        SubDimension subDimension;
        String string2;
        IdentifierElement identifierElement = new IdentifierElement(string);
        Dimension dimension = null;
        DimensionHierarchy dimensionHierarchy = null;
        NamedObjectWithDesc namedObjectWithDesc = null;
        if (identifierElement.getCount() > 0) {
            string2 = identifierElement.getFirst();
            namedObjectWithDesc = dimension = this.cube.findDimension(string2);
        }
        if (dimension != null && identifierElement.getCount() > 1) {
            string2 = identifierElement.getSecond();
            dimensionHierarchy = dimension.findHierarchy(string2);
            if (dimensionHierarchy != null) {
                subDimension = new Pair((Object)dimensionHierarchy, (Object)identifierElement.getValue());
                namedObjectWithDesc = subDimension;
            }
            if ((subDimension = dimension.findLevel(string2)) != null) {
                for (DimensionHierarchy dimensionHierarchy2 : dimension.getHierarchies()) {
                    for (DimensionHierarchyLevel dimensionHierarchyLevel : dimensionHierarchy2.getHierarchyLevels()) {
                        if (!dimensionHierarchyLevel.getDimensionLevel().getName().equals(string2)) continue;
                        return dimensionHierarchyLevel;
                    }
                }
            }
        }
        if (dimension != null && dimensionHierarchy != null && identifierElement.getCount() > 2 && (subDimension = dimensionHierarchy.findHierarchyLevel(string2 = identifierElement.getThird())) != null) {
            return subDimension;
        }
        return namedObjectWithDesc;
    }

    private int getDepth(String string) {
        for (String string2 : this.dimDepths) {
            Dimension dimension = this.getDimensionFromDepth(string2);
            if (dimension == null || !dimension.getName().equals(string)) continue;
            Object object = this.getObjectFromDepth(string2);
            if (object instanceof Pair) {
                Pair pair = (Pair)object;
                Integer n = new Integer((String)pair.getSecond());
                return n;
            }
            if (!(object instanceof DimensionHierarchyLevel)) continue;
            DimensionHierarchyLevel dimensionHierarchyLevel = (DimensionHierarchyLevel)object;
            return dimensionHierarchyLevel.getDepth();
        }
        return 1;
    }

    private HierarchyET getHierarchyET(String string) {
        for (String string2 : this.dimDepths) {
            Dimension dimension = this.getDimensionFromDepth(string2);
            if (!dimension.getName().equals(string)) continue;
            Object object = this.getObjectFromDepth(string2);
            if (object instanceof Pair) {
                Pair pair = (Pair)object;
                HierarchyET hierarchyET = this.dimHierarchyETMap.get(((DimensionHierarchy)pair.getFirst()).getID());
                return hierarchyET;
            }
            if (object instanceof DimensionHierarchyLevel) {
                DimensionHierarchyLevel dimensionHierarchyLevel = (DimensionHierarchyLevel)object;
                String string3 = dimensionHierarchyLevel.getHierarchy().getID();
                HierarchyET hierarchyET = this.dimHierarchyETMap.get(string3);
                return hierarchyET;
            }
            if (!(object instanceof Dimension)) continue;
            Dimension dimension2 = (Dimension)object;
            HierarchyET hierarchyET = this.dimHierarchyETMap.get(dimension2.getName());
            return hierarchyET;
        }
        return null;
    }

    private Map<String, String> getBindMap(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", string);
        hashMap.put("cubeName", string2);
        return hashMap;
    }
}

