/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubeviewer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.olap.OLAPArb;
import oracle.olap.app.Resources;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.templateview.TemplateListHyperView;
import oracle.olap.app.templates.templateview.TemplateMetadata;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.app.templates.view.TemplateHyperContextImpl;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.data.CubeMetadataContext;

public class CubeDimensionConditionPanel
extends JPanel
implements PropertyChangeListener {
    private Database database;
    private TemplateListHyperView templateListHyperView;
    private CubeMetadataContext cubeMetadataContext;
    private Resources resources;
    private FetchIcon fetchIcon;
    private List<PropertyChangeListener> listeners;

    public CubeDimensionConditionPanel(CubeMetadataContext cubeMetadataContext, Resources resources, FetchIcon fetchIcon) throws SQLException, IOException {
        this.cubeMetadataContext = cubeMetadataContext;
        this.resources = resources;
        this.fetchIcon = fetchIcon;
        this.listeners = new ArrayList<PropertyChangeListener>();
        this.database = new DatabaseImpl();
        this.database.setConnection(cubeMetadataContext.getDatabase().getConnection());
        this.setupTemplates(this.database);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("VALUE_CHANGED") || propertyChangeEvent.getPropertyName().equals("TEMPLATE_ADDED") || propertyChangeEvent.getPropertyName().equals("TEMPLATE_REMOVED")) {
            for (PropertyChangeListener propertyChangeListener : this.listeners) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    public String getQuery() throws SQLException, IOException {
        return this.templateListHyperView.getExpression();
    }

    private void setupTemplates(Database database) throws SQLException, IOException {
        boolean bl = false;
        TemplateHyperContextImpl templateHyperContextImpl = new TemplateHyperContextImpl(this.cubeMetadataContext.getDatabase().getConnection(), this.resources, this.fetchIcon, TemplateHyperContext.ResizeMode.LEGACY);
        this.cubeMetadataContext.getCube().getSchema().setLoaded(true);
        TemplateContext templateContext = new TemplateContext(database, new TemplateMetadata(this.cubeMetadataContext.getCube()));
        this.templateListHyperView = new TemplateListHyperView(templateContext, templateHyperContextImpl, CubeDimensionConditionPanel.class, "dimcondition.xml");
        this.templateListHyperView.addPropertyChangeListener(this);
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(String.format("<html><b>%s</b></html>", OLAPArb.get("CUBE_QUERY_DIMENSION_CONDITION_LABEL")));
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 13, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.templateListHyperView.getPanel(), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.5, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
    }
}

