/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplateimpl;

import java.io.Reader;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.app.metadata.OLAPXML;
import oracle.olap.app.metadata.OLAPXMLExportOptions;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.table.Queries;
import oracle.olap.cubetemplate.ConflictRenameMap;
import oracle.olap.cubetemplate.ObjectType;
import oracle.olap.cubetemplate.TemplatePreprocessor;
import oracle.olap.cubetemplate.TreeNode;
import oracle.sql.CLOB;

public class PLSQLXMLImpl
implements OLAPXML {
    private final Connection conn;
    private Queries queries;
    private static final String XMLFILE = "templateplsql.xml";
    private static final String IMPORT = "IMPORT";
    private static final String IMPORT_WITH_OPTIONS = "IMPORT_WITH_OPTIONS";
    private static final String IMPORT_WITHOUT_RENAME_TABLE = "IMPORT_WITHOUT_RENAME_TABLE";
    private static final String EXPORT = "EXPORT";

    public PLSQLXMLImpl(Connection connection) {
        this.conn = connection;
        try {
            String string = "oracle.olap.app.table";
            String string2 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
            JavaXMLBind.BindToJavaStr(string2, string, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addQueries(Queries queries) {
        this.queries = queries;
    }

    @Override
    public List importXml(Reader reader, String string, boolean bl, Map<String, String> map, ConflictRenameMap conflictRenameMap) throws Exception {
        this.importXmlWithoutRenameTable(reader, string, bl, map, conflictRenameMap);
        return Collections.emptyList();
    }

    private void importXmlWithoutRenameTable(Reader reader, String string, boolean bl, Map<String, String> map, ConflictRenameMap conflictRenameMap) throws Exception {
        int n = 1;
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
        String string2 = dBUtil.getConnectionResolver().getConnectionName(this.conn);
        Schema schema = OLAPMetadataCache.getUpdatedSchema(string2, string);
        boolean bl2 = this.conn.getAutoCommit();
        this.conn.setAutoCommit(bl2);
        dBUtil.setRaiseError(false);
        TemplatePreprocessor templatePreprocessor = new TemplatePreprocessor(map, conflictRenameMap);
        CLOB cLOB = DatabaseUtils.ConvertStringToCLOB(this.conn, templatePreprocessor.preprocessDocument(reader));
        CallableStatement callableStatement = this.conn.prepareCall(this.queries.getSQL(IMPORT_WITHOUT_RENAME_TABLE));
        n = bl ? 1 : 0;
        callableStatement.setInt("modifyifexists", n);
        callableStatement.setClob("xmlclob", (Clob)cLOB);
        callableStatement.execute();
        OLAPMetadataCache.removeSchema(string2, string);
    }

    private void importXmlWithRenameTable(Reader reader, String string, boolean bl, Map<String, String> map, ConflictRenameMap conflictRenameMap) throws Exception {
        Object object;
        String string2;
        Object object2;
        int n = 1;
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE GLOBAL TEMPORARY TABLE OLAP_RENAME_MAP (\n");
        stringBuffer.append("          source_id    VARCHAR2(300),\n");
        stringBuffer.append("          new_name     VARCHAR2(30),\n");
        stringBuffer.append("          object_type  VARCHAR2(30))");
        String string3 = stringBuffer.toString();
        dBUtil.setRaiseError(false);
        dBUtil.execute(string3);
        dBUtil.setRaiseError(true);
        String string4 = dBUtil.getConnectionResolver().getConnectionName(this.conn);
        Schema schema = OLAPMetadataCache.getUpdatedSchema(string4, string);
        conflictRenameMap.resetIterator();
        boolean bl2 = this.conn.getAutoCommit();
        boolean bl3 = false;
        while (conflictRenameMap.getNextObjectName() != null) {
            Object object3;
            object2 = conflictRenameMap.getParent();
            string2 = conflictRenameMap.getCurrentObjectName();
            object = conflictRenameMap.getRenameEntry(conflictRenameMap.getType(), conflictRenameMap.getParent(), conflictRenameMap.getCurrentObjectName());
            if (object == null) continue;
            int n2 = conflictRenameMap.getType();
            String string5 = null;
            switch (n2) {
                case 3: {
                    string2 = string2 + ".AW";
                    string5 = "AW";
                    break;
                }
                case 2: {
                    string5 = "Cube";
                    break;
                }
                case 1: {
                    string5 = "StandardDimension";
                    object3 = schema.findDimension(string2);
                    if (object3 == null || !((Dimension)object3).isTime()) break;
                    string5 = "TimeDimension";
                    break;
                }
                case 4: {
                    string5 = "MeasureFolder";
                    bl3 = true;
                    break;
                }
                case 5: {
                    string5 = "Measure";
                    break;
                }
                case 6: {
                    string5 = "DerivedMeasure";
                }
            }
            object3 = String.format("insert into olap_rename_map values('%s.%s', '%s', '%s')", string, string2, object, string5);
            this.conn.setAutoCommit(false);
            dBUtil.execute((String)object3);
        }
        this.conn.setAutoCommit(bl2);
        dBUtil.setRaiseError(false);
        object2 = new TemplatePreprocessor(map, conflictRenameMap);
        string2 = DatabaseUtils.ConvertStringToCLOB(this.conn, ((TemplatePreprocessor)object2).preprocessDocument(reader));
        if (!bl3) {
            object = this.conn.prepareCall(this.queries.getSQL(IMPORT_WITH_OPTIONS));
            n = bl ? 1 : 0;
            object.setInt("modifyifexists", n);
            object.setString("renametable", "OLAP_RENAME_MAP");
            object.setClob("xmlclob", (Clob)((Object)string2));
            object.execute();
        } else {
            object = this.conn.prepareCall(this.queries.getSQL(IMPORT_WITHOUT_RENAME_TABLE));
            n = bl ? 1 : 0;
            object.setInt("modifyifexists", n);
            object.setClob("xmlclob", (Clob)((Object)string2));
            object.execute();
        }
        OLAPMetadataCache.removeSchema(string4, string);
    }

    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public void exportXml(Writer writer, List list, Map<Object, String> map, OLAPXMLExportOptions oLAPXMLExportOptions) throws Exception {
        TreeNode treeNode;
        CallableStatement callableStatement = this.conn.prepareCall(this.queries.getSQL(EXPORT));
        String string = null;
        String string2 = null;
        TemplatePreprocessor templatePreprocessor = null;
        ConflictRenameMap conflictRenameMap = new ConflictRenameMap();
        if (map != null) {
            for (Map.Entry object : map.entrySet()) {
                treeNode = (TreeNode)object.getKey();
                conflictRenameMap.addEntry(treeNode.getType(), (String)treeNode.getUserObject(), treeNode.getParentName(), (String)object.getValue());
            }
        }
        for (Object object : list) {
            treeNode = (TreeNode)object;
            if (treeNode.getParentName() == null) {
                string = (String)treeNode.getUserObject();
            } else {
                string = treeNode.getParentName();
                string2 = (String)treeNode.getUserObject();
            }
            int n = 1;
            callableStatement.setString(n++, string);
            callableStatement.setString(n++, "True");
            callableStatement.setString(n++, oLAPXMLExportOptions.isIncludeOwnerString() ? "False" : "True");
            if (oLAPXMLExportOptions.getInSchemaMapping().equals("ALL_MAPPED_QUALIFIED")) {
                callableStatement.setString(n++, "True");
            } else if (oLAPXMLExportOptions.getInSchemaMapping().equals("NON_OWNER_MAPPED_QUALIFIED")) {
                callableStatement.setString(n++, "False");
            } else if (oLAPXMLExportOptions.getInSchemaMapping().equals("NONE_MAPPED_QUALIFIED")) {
                callableStatement.setString(n++, "False");
            }
            callableStatement.setString(n++, oLAPXMLExportOptions.getTargetVersion());
            callableStatement.registerOutParameter(n, 2005);
            callableStatement.execute();
            Clob clob = callableStatement.getClob(n);
            TemplatePreprocessor templatePreprocessor2 = new TemplatePreprocessor(null, conflictRenameMap);
            templatePreprocessor2.preprocessDocument(clob.getCharacterStream());
            if (treeNode.getType() == ObjectType.DERIVED_MEASURE || treeNode.getType() == ObjectType.MEASURE) {
                templatePreprocessor2.removeXPath("/Metadata/Cube/*[name()!='Measure']");
                templatePreprocessor2.removeXPath(String.format("/Metadata/Cube/Measure[./*/@Name!='%1$s']", string2));
                templatePreprocessor2.removeXPath("/Metadata/Cube/text()");
            }
            if (templatePreprocessor == null) {
                templatePreprocessor = templatePreprocessor2;
                continue;
            }
            templatePreprocessor.addTemplate(templatePreprocessor2);
        }
        for (String string3 : oLAPXMLExportOptions.getSuppressList()) {
            templatePreprocessor.removeXPath(String.format("//@%s", string3));
        }
        writer.append(templatePreprocessor.getDocument());
    }
}

