/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import oracle.olap.app.Resources;

public class XMLPreviewPanel
extends JPanel {
    private final JTextArea textArea;
    private final JScrollPane scrollPane;
    private final JButton findButton;
    private final JTextField tf;
    private final JPanel searchPanel;

    public XMLPreviewPanel(Resources resources) {
        this.findButton = new JButton(resources.getString("DIALOG_FIND"));
        this.findButton.setName("findButton");
        this.textArea = new JTextArea("");
        this.textArea.setName("textArea");
        this.scrollPane = new JScrollPane(this.textArea);
        this.scrollPane.setName("scrollPane");
        this.tf = new JTextField();
        this.tf.setName("tf");
        this.searchPanel = new JPanel();
        this.searchPanel.setName("searchPanel");
        this.jbInit();
    }

    public void configure(File file) {
        this.configure(XMLPreviewPanel.contentsOfFile(file));
    }

    public void configure(String string) {
        this.textArea.setText(string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JViewport jViewport = XMLPreviewPanel.this.scrollPane.getViewport();
                jViewport.setViewPosition(new Point(0, 0));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String contentsOfFile(File file) {
        long l = file.length();
        String string = new String();
        char[] cArray = new char[(int)(l += 100L)];
        FileReader fileReader = null;
        try {
            int n;
            fileReader = new FileReader(file);
            while ((n = fileReader.read(cArray, 0, cArray.length)) != -1) {
                string = string + new String(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            string = "Could not load file";
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    public void clear() {
        this.textArea.setText("");
    }

    private void jbInit() {
        Dimension dimension = this.tf.getPreferredSize();
        dimension.setSize(200.0, dimension.getHeight());
        this.tf.setPreferredSize(dimension);
        this.searchPanel.setLayout(new FlowLayout());
        this.searchPanel.add(this.tf);
        this.searchPanel.add(this.findButton);
        this.textArea.setEditable(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)this.searchPanel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                String string = XMLPreviewPanel.this.textArea.getText();
                String string2 = XMLPreviewPanel.this.tf.getText();
                if (string2.length() == 0) {
                    return;
                }
                int n2 = XMLPreviewPanel.this.textArea.getSelectionStart();
                if (n2 > 0) {
                    n2 += string2.length();
                }
                if ((n = string.toLowerCase().indexOf(string2.toLowerCase(), n2)) == -1) {
                    n2 = 0;
                    n = string.toLowerCase().indexOf(string2.toLowerCase(), n2);
                }
                if (n >= 0) {
                    XMLPreviewPanel.this.textArea.setSelectionStart(n);
                    XMLPreviewPanel.this.textArea.setSelectionEnd(n + string2.length());
                    XMLPreviewPanel.this.textArea.requestFocusInWindow();
                }
            }
        });
    }
}

