/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.olap.OLAPArb;
import oracle.olap.app.ui.DataTypeUI;
import oracle.olap.cubedimension.CubeDimensionRemoveChildDispatcher;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.model.CubeSubDimension;
import oracle.olap.cubedimension.panels.CubeDimensionAttributeEditorPanel;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.db.view.ChildNameObjectEditorContext;
import oracle.olap.db.view.ChildObjectEditorPanel2;
import oracle.olap.db.view.DimensionTree;

public class CubeDimensionAttributeTableEditorPanel<T extends CubeDimensionAttribute, P extends CubeDimension>
extends ChildObjectEditorPanel2<T, P> {
    private JLabel lblName;
    private DimensionTree visibilityTree;
    private DBObjectProvider prov;
    private JCheckBox allowAutoDataTypeChangeCheckBox;
    private DataTypeUI dataTypeUI;
    private JCheckBox indexCheckBox;
    private JCheckBox starCheckBox;
    private JCheckBox langCheckBox;
    private JLabel roleLabel;
    private JComboBox roleComboBox;
    private DefaultComboBoxModel roleComboBoxModel;
    private boolean isInitializing = false;
    private boolean initialValueForVisibleToAll = false;
    private TreeSet<CubeDimensionAttribute> invalidAttributes = new TreeSet(new DBObjectComparator());

    public CubeDimensionAttributeTableEditorPanel() {
        super(CubeDimensionAttributeEditorPanel.class.getName(), "ATTRIBUTE");
        this.layoutComponents();
        CubeDimensionRemoveChildDispatcher cubeDimensionRemoveChildDispatcher = CubeDimensionRemoveChildDispatcher.getInstance();
        cubeDimensionRemoveChildDispatcher.registerObserver(this);
    }

    private void initFromAttributeData(CubeDimensionAttribute cubeDimensionAttribute) {
        if (this.getChildObject() == null) {
            this.getNameField().setText("");
            this.lblName.setEnabled(false);
            this.getNameField().setEnabled(false);
            this.visibilityTree.init((CubeDimension)this.getUpdatedObject());
        } else {
            CubeDimension cubeDimension = cubeDimensionAttribute.getCubeDimension();
            String string = ((CubeDimensionAttribute)this.getChildObject()).getName();
            if (!this.invalidAttributes.contains(this.getChildObject())) {
                // empty if block
            }
            ChildNameObjectEditorContext childNameObjectEditorContext = ChildNameObjectEditorContext.getInstance();
            childNameObjectEditorContext.setEditingState(1);
            this.getNameField().setText(string);
            this.getNameField().setEnabled(true);
            childNameObjectEditorContext.setEditingState(0);
            this.isInitializing = true;
            this.loadRoleComboBox(cubeDimension);
            this.isInitializing = false;
            String string2 = cubeDimensionAttribute.getRole();
            String string3 = this.getRoleComboBoxSelection(string2);
            if (cubeDimensionAttribute.getPersistedOrSpecial()) {
                this.enableRoleComboBox(false);
            } else {
                this.enableRoleComboBox(true);
            }
            this.allowAutoDataTypeChangeCheckBox.setSelected(true);
            this.roleComboBox.setSelectedItem(string3);
            String string4 = ((CubeDimensionAttribute)this.getChildObject()).getDataType();
            this.dataTypeUI.setSQLDataType(string4);
            this.visibilityTree.init(cubeDimension);
            this.initialValueForVisibleToAll = cubeDimensionAttribute.isAttributeVisibleForAll();
            if (cubeDimensionAttribute.isAttributeVisibleForAll()) {
                this.visibilityTree.setSelectedAll(true);
            } else {
                for (CubeDimensionLevel cubeSubDimension : cubeDimension.getLevels()) {
                    for (CubeDimensionAttribute cubeDimensionAttribute2 : cubeSubDimension.getVisibleAttributes()) {
                        if (!cubeDimensionAttribute.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute2.getOriginalAttributeName())) continue;
                        this.visibilityTree.setSelected(cubeSubDimension, true);
                    }
                }
                for (CubeSubDimension cubeSubDimension : cubeDimension.getHierarchies()) {
                    if (((CubeDimensionHierarchy)cubeSubDimension).getHierarchyValueType()) {
                        for (AbstractChildObjectWithDesc abstractChildObjectWithDesc : cubeSubDimension.getVisibleAttributes()) {
                            if (!cubeDimensionAttribute.getOriginalAttributeName().equalsIgnoreCase(((CubeDimensionAttribute)abstractChildObjectWithDesc).getOriginalAttributeName())) continue;
                            this.visibilityTree.setSelected(cubeSubDimension, true);
                        }
                        continue;
                    }
                    for (AbstractChildObjectWithDesc abstractChildObjectWithDesc : ((CubeDimensionHierarchy)cubeSubDimension).getHierarchyLevels()) {
                        for (CubeDimensionAttribute cubeDimensionAttribute3 : ((CubeSubDimension)abstractChildObjectWithDesc).getVisibleAttributes()) {
                            if (!cubeDimensionAttribute.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute3.getOriginalAttributeName())) continue;
                            this.visibilityTree.setSelected(abstractChildObjectWithDesc, true);
                        }
                    }
                }
            }
            this.visibilityTree.setExpandAll();
            if (cubeDimensionAttribute.getRole() != null && (cubeDimensionAttribute.getRole().equalsIgnoreCase("END_DATE") || cubeDimensionAttribute.getRole().equalsIgnoreCase("TIME_SPAN"))) {
                this.visibilityTree.setEnabled(false);
            } else {
                this.visibilityTree.setEnabled(true);
            }
            this.indexCheckBox.setSelected(cubeDimensionAttribute.isIndex());
            this.starCheckBox.setSelected(cubeDimensionAttribute.isStar());
            this.langCheckBox.setSelected(cubeDimensionAttribute.isNls());
            this.dataTypeUI.refreshDataTypeUI();
            if (cubeDimensionAttribute.isAttributeAllowAutoDataTypeChange()) {
                this.dataTypeUI.setEnabled(false);
                this.allowAutoDataTypeChangeCheckBox.setSelected(true);
            } else {
                this.dataTypeUI.setEnabled(true);
                this.allowAutoDataTypeChangeCheckBox.setSelected(false);
            }
            this.allowAutoDataTypeChangeCheckBox.setEnabled(true);
            if ((string2.equals("END_DATE") || string2.equals("TIME_SPAN")) && this.getOriginalObject() == null) {
                this.allowAutoDataTypeChangeCheckBox.setEnabled(false);
            }
        }
        this.validate();
        this.repaint();
    }

    private void loadRoleComboBox(CubeDimension cubeDimension) {
        this.roleComboBoxModel.removeAllElements();
        this.roleComboBoxModel.addElement(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_USER"));
        this.roleComboBoxModel.addElement(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_LONG"));
        this.roleComboBoxModel.addElement(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_SHORT"));
        CubeDimensionAttribute cubeDimensionAttribute = (CubeDimensionAttribute)this.getChildObject();
        String string = cubeDimensionAttribute.getRole();
        if (string != null && (string.equalsIgnoreCase("END_DATE") || string.equalsIgnoreCase("TIME_SPAN"))) {
            this.roleComboBoxModel.addElement(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_END_DATE"));
            this.roleComboBoxModel.addElement(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_TIME_SPAN"));
        }
    }

    private String getRoleComboBoxSelection(String string) {
        String string2 = null;
        if (string == null || string.length() == 0) {
            string = "USER";
        }
        string2 = string.equalsIgnoreCase("LONG_DESCRIPTION") ? OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_LONG") : (string.equalsIgnoreCase("SHORT_DESCRIPTION") ? OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_SHORT") : (string.equalsIgnoreCase("END_DATE") ? OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_END_DATE") : (string.equalsIgnoreCase("TIME_SPAN") ? OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_TIME_SPAN") : OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_USER"))));
        return string2;
    }

    private String getRoleComboBoxInternalSelection() {
        String string = null;
        String string2 = (String)this.roleComboBox.getSelectedItem();
        string = string2.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_LONG")) ? "LONG_DESCRIPTION" : (string2.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_SHORT")) ? "SHORT_DESCRIPTION" : (string2.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_END_DATE")) ? "END_DATE" : (string2.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_TIME_SPAN")) ? "TIME_SPAN" : "USER")));
        return string;
    }

    private void enableRoleComboBox(boolean bl) {
        this.roleLabel.setEnabled(bl);
        this.roleComboBox.setEnabled(bl);
    }

    private void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
    }

    @Override
    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        super.initialisePanel();
        this.initFromAttribute((CubeDimensionAttribute)this.getChildObject());
    }

    public void commit(CubeDimensionAttribute cubeDimensionAttribute) throws TraversalException {
        if (this.invalidAttributes.contains(cubeDimensionAttribute)) {
            this.invalidAttributes.remove(cubeDimensionAttribute);
        }
        String string = this.dataTypeUI.getSQLDataType();
        cubeDimensionAttribute.setDataType(string);
        cubeDimensionAttribute.setNls(this.langCheckBox.isSelected());
        boolean bl = this.indexCheckBox.isSelected();
        cubeDimensionAttribute.setIndex(bl);
        cubeDimensionAttribute.setRole(this.getRoleComboBoxInternalSelection());
        cubeDimensionAttribute.setStar(this.starCheckBox.isSelected());
        cubeDimensionAttribute.setAttributeAllowAutoDataTypeChange(this.allowAutoDataTypeChangeCheckBox.isSelected());
        if (this.visibilityTree.isFullySelected()) {
            cubeDimensionAttribute.setAttributeVisibleForAll(true);
            if (!this.initialValueForVisibleToAll) {
                this.processAttributeVisibility(cubeDimensionAttribute);
            }
        } else {
            cubeDimensionAttribute.setAttributeVisibleForAll(false);
            if (this.initialValueForVisibleToAll) {
                this.toggleOffAllVisibleAttributes(cubeDimensionAttribute);
            }
            this.processAttributeVisibility(cubeDimensionAttribute);
        }
    }

    private void processAttributeVisibility(CubeDimensionAttribute cubeDimensionAttribute) {
        CubeDimensionAttribute cubeDimensionAttribute2 = null;
        for (CubeDimensionLevel cubeSubDimension : ((CubeDimension)this.getUpdatedObject()).getLevels()) {
            boolean bl = this.visibilityTree.isSelected(cubeSubDimension);
            if (bl) {
                if (this.isAttributeVisibleAtLevel(cubeSubDimension, cubeDimensionAttribute)) continue;
                cubeSubDimension.addVisibleAttribute(cubeDimensionAttribute);
                continue;
            }
            CubeDimensionAttribute[] cubeDimensionAttributeArray = cubeSubDimension.getVisibleAttributes();
            cubeDimensionAttribute2 = this.getChildVisibleStoredAttribute(cubeDimensionAttributeArray, cubeDimensionAttribute);
            if (cubeDimensionAttribute2 == null) {
                cubeDimensionAttribute2 = cubeDimensionAttribute;
            }
            cubeSubDimension.removeVisibleAttribute(cubeDimensionAttribute2);
        }
        for (CubeSubDimension cubeSubDimension : ((CubeDimension)this.getUpdatedObject()).getHierarchies()) {
            if (!((CubeDimensionHierarchy)cubeSubDimension).getHierarchyLevelType()) {
                boolean bl = this.visibilityTree.isSelected(cubeSubDimension);
                if (bl) {
                    cubeSubDimension.addVisibleAttribute(cubeDimensionAttribute);
                    continue;
                }
                CubeDimensionAttribute[] cubeDimensionAttributeArray = cubeSubDimension.getVisibleAttributes();
                cubeDimensionAttribute2 = this.getChildVisibleStoredAttribute(cubeDimensionAttributeArray, cubeDimensionAttribute);
                if (cubeDimensionAttribute2 == null) {
                    cubeDimensionAttribute2 = cubeDimensionAttribute;
                }
                cubeSubDimension.removeVisibleAttribute(cubeDimensionAttribute2);
                continue;
            }
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : ((CubeDimensionHierarchy)cubeSubDimension).getHierarchyLevels()) {
                boolean bl = this.visibilityTree.isSelected(cubeDimensionHierarchyLevel);
                if (bl) {
                    if (this.isAttributeVisibleAtHierLevel(cubeDimensionHierarchyLevel, cubeDimensionAttribute)) continue;
                    cubeDimensionHierarchyLevel.addVisibleAttribute(cubeDimensionAttribute);
                    continue;
                }
                CubeDimensionAttribute[] cubeDimensionAttributeArray = cubeDimensionHierarchyLevel.getVisibleAttributes();
                cubeDimensionAttribute2 = this.getChildVisibleStoredAttribute(cubeDimensionAttributeArray, cubeDimensionAttribute);
                if (cubeDimensionAttribute2 == null) {
                    cubeDimensionAttribute2 = cubeDimensionAttribute;
                }
                cubeDimensionHierarchyLevel.removeVisibleAttribute(cubeDimensionAttribute2);
            }
        }
    }

    private void toggleOffAllVisibleAttributes(CubeDimensionAttribute cubeDimensionAttribute) {
        CubeDimensionAttribute[] cubeDimensionAttributeArray;
        for (CubeDimensionLevel cubeSubDimension : ((CubeDimension)this.getUpdatedObject()).getLevels()) {
            AbstractChildObjectWithDesc[] abstractChildObjectWithDescArray = cubeSubDimension.getVisibleAttributes();
            CubeDimensionAttribute[] cubeDimensionAttributeArray2 = abstractChildObjectWithDescArray;
            int n = cubeDimensionAttributeArray2.length;
            for (int abstractChildObjectWithDesc = 0; abstractChildObjectWithDesc < n; ++abstractChildObjectWithDesc) {
                cubeDimensionAttributeArray = cubeDimensionAttributeArray2[abstractChildObjectWithDesc];
                if (!cubeDimensionAttributeArray.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute.getOriginalAttributeName())) continue;
                cubeSubDimension.removeVisibleAttribute((CubeDimensionAttribute)cubeDimensionAttributeArray);
            }
        }
        for (CubeSubDimension cubeSubDimension : ((CubeDimension)this.getUpdatedObject()).getHierarchies()) {
            if (((CubeDimensionHierarchy)cubeSubDimension).getHierarchyLevelType()) continue;
            for (AbstractChildObjectWithDesc abstractChildObjectWithDesc : ((CubeDimensionHierarchy)cubeSubDimension).getHierarchyLevels()) {
                for (CubeDimensionAttribute cubeDimensionAttribute2 : cubeDimensionAttributeArray = ((CubeSubDimension)abstractChildObjectWithDesc).getVisibleAttributes()) {
                    if (!cubeDimensionAttribute2.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute.getOriginalAttributeName())) continue;
                    ((CubeSubDimension)abstractChildObjectWithDesc).removeVisibleAttribute(cubeDimensionAttribute2);
                }
            }
        }
    }

    private CubeDimensionAttribute getChildVisibleStoredAttribute(CubeDimensionAttribute[] cubeDimensionAttributeArray, CubeDimensionAttribute cubeDimensionAttribute) {
        CubeDimensionAttribute cubeDimensionAttribute2 = null;
        if (cubeDimensionAttributeArray != null && cubeDimensionAttributeArray.length > 0) {
            for (CubeDimensionAttribute cubeDimensionAttribute3 : cubeDimensionAttributeArray) {
                if (!cubeDimensionAttribute3.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute.getOriginalAttributeName())) continue;
                cubeDimensionAttribute2 = cubeDimensionAttribute3;
                break;
            }
        }
        return cubeDimensionAttribute2;
    }

    private boolean isAttributeVisibleAtLevel(CubeDimensionLevel cubeDimensionLevel, CubeDimensionAttribute cubeDimensionAttribute) {
        CubeDimensionAttribute[] cubeDimensionAttributeArray;
        boolean bl = false;
        for (CubeDimensionAttribute cubeDimensionAttribute2 : cubeDimensionAttributeArray = cubeDimensionLevel.getVisibleAttributes()) {
            if (!cubeDimensionAttribute2.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute.getOriginalAttributeName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isAttributeVisibleAtHierLevel(CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel, CubeDimensionAttribute cubeDimensionAttribute) {
        CubeDimensionAttribute[] cubeDimensionAttributeArray;
        boolean bl = false;
        for (CubeDimensionAttribute cubeDimensionAttribute2 : cubeDimensionAttributeArray = cubeDimensionHierarchyLevel.getVisibleAttributes()) {
            if (!cubeDimensionAttribute2.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute.getOriginalAttributeName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void initFromAttribute(CubeDimensionAttribute cubeDimensionAttribute) {
        this.initFromAttributeData(cubeDimensionAttribute);
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        CubeDimensionAttribute cubeDimensionAttribute = (CubeDimensionAttribute)this.getChildObject();
        this.commit(cubeDimensionAttribute);
        CubeDimension cubeDimension = cubeDimensionAttribute.getCubeDimension();
        if (cubeDimension.findAttribute(cubeDimensionAttribute.getName()) == null) {
            cubeDimension.addAttribute(cubeDimensionAttribute);
        }
    }

    private void layoutComponents() {
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.setBasePath(new String[]{"attributes"});
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JSplitPane jSplitPane = new JSplitPane();
        JLabel jLabel = new JLabel(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_APPLY_TO_LABEL"));
        jLabel.setName("visibilityLabel");
        this.lblName = new JLabel();
        this.lblName.setName("lblName");
        componentFactory.registerComponent(this.lblName, (Component)this.getNameField(), UIBundle.get((String)"COLUMN_INFO_LABEL_NAME"), "name", "name");
        this.allowAutoDataTypeChangeCheckBox = new JCheckBox(OLAPArb.getString("CUBE_MEASURE_ALLOWAUTODATATYPECHANGE"));
        this.roleLabel = new JLabel(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_LABEL"));
        this.roleLabel.setName("roleLabel");
        this.roleComboBoxModel = new DefaultComboBoxModel();
        this.roleComboBox = new JComboBox(this.roleComboBoxModel);
        this.roleComboBox.setName("roleComboBox");
        this.indexCheckBox = new JCheckBox();
        this.indexCheckBox.setName("indexCheckBox");
        componentFactory.registerComponent((AbstractButton)this.indexCheckBox, OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_INDEX_LABEL"), "index");
        this.starCheckBox = new JCheckBox();
        this.starCheckBox.setName("starCheckBox");
        componentFactory.registerComponent((AbstractButton)this.starCheckBox, OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_CREATE_COLUMNS_LABEL"), "star");
        this.langCheckBox = new JCheckBox();
        componentFactory.registerComponent((AbstractButton)this.langCheckBox, OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_MULTILINGUAL_LABEL"), "nls");
        this.getNameField().setColumns(30);
        this.dataTypeUI = new DataTypeUI(componentFactory);
        this.dataTypeUI.removeDataTypel("DATETIME");
        this.dataTypeUI.getDataTypeComboBox().setSelectedItem("VARCHAR2");
        this.visibilityTree = new DimensionTree();
        this.roleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CubeDimensionAttributeTableEditorPanel.this.isInitializing) {
                    CubeDimensionAttribute cubeDimensionAttribute = (CubeDimensionAttribute)CubeDimensionAttributeTableEditorPanel.this.getChildObject();
                    String string = (String)CubeDimensionAttributeTableEditorPanel.this.roleComboBox.getSelectedItem();
                    String string2 = "USER";
                    String string3 = cubeDimensionAttribute.getRole();
                    if (string3.equalsIgnoreCase("END_DATE") || string3.equalsIgnoreCase("TIME_SPAN")) {
                        return;
                    }
                    if (string.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_LONG"))) {
                        string2 = "LONG_DESCRIPTION";
                    } else if (string.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_SHORT"))) {
                        string2 = "SHORT_DESCRIPTION";
                    } else if (string.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_END_DATE"))) {
                        string2 = "END_DATE";
                    } else if (string.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_TIME_SPAN"))) {
                        string2 = "TIME_SPAN";
                    }
                    cubeDimensionAttribute.setRole(string2);
                }
            }
        });
        this.allowAutoDataTypeChangeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CubeDimensionAttributeTableEditorPanel.this.allowAutoDataTypeChangeCheckBox.isSelected()) {
                    CubeDimensionAttribute cubeDimensionAttribute = (CubeDimensionAttribute)CubeDimensionAttributeTableEditorPanel.this.getChildObject();
                    String string = cubeDimensionAttribute.getRole();
                    if (string != null && (string.equalsIgnoreCase("END_DATE") || string.equalsIgnoreCase("TIME_SPAN"))) {
                        Namespace namespace = CubeDimensionAttributeTableEditorPanel.this.getDataContext();
                        Window window = (Window)namespace.get("oracle.bali.ewt.dialog.JEWTDialog");
                        JOptionPane.showMessageDialog(window, OLAPArb.getString("AUTO_DETECT_DATA_TYPE_NOT_ALLOWED_ERROR_MSG"), OLAPArb.getString("AUTO_DETECT_DATA_TYPE_NOT_ALLOWED_ERROR_TITLE"), 0);
                        CubeDimensionAttributeTableEditorPanel.this.allowAutoDataTypeChangeCheckBox.setSelected(false);
                        CubeDimensionAttributeTableEditorPanel.this.dataTypeUI.setEnabled(true);
                    } else {
                        CubeDimensionAttributeTableEditorPanel.this.dataTypeUI.setEnabled(false);
                    }
                } else {
                    CubeDimensionAttributeTableEditorPanel.this.dataTypeUI.setEnabled(true);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_PROPERTIES_BORDER_LABEL")));
        int n = 0;
        jPanel.add((Component)this.roleLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.roleComboBox, new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.starCheckBox, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.indexCheckBox, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.allowAutoDataTypeChangeCheckBox, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.langCheckBox, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.dataTypeUI.getDataTypeLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.dataTypeUI.getDataTypeComboBox(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.dataTypeUI.getDataTypeSizeLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.dataTypeUI.getDataTypeSizeTextField(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.dataTypeUI.getDataTypeScaleLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.dataTypeUI.getDataTypeScaleTextField(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        jPanel.add((Component)new JPanel(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 12), 0, 0));
        n = 0;
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 12), 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.visibilityTree);
        jScrollPane.setName("scrollPane");
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jSplitPane.setOrientation(1);
        jSplitPane.setDividerLocation(0.4);
        jSplitPane.setLeftComponent(jPanel);
        jSplitPane.setRightComponent(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add(jSplitPane, gridBagConstraints);
    }

    @Override
    public void processRemoveChildEvent(AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc) {
        CubeDimension cubeDimension;
        if (abstractSchemaObjectWithDesc instanceof CubeDimension && (cubeDimension = (CubeDimension)abstractSchemaObjectWithDesc).getAttributes().length == 0) {
            this.enableDescriptions(false);
        }
    }

    protected void validateObject() throws TraversalException {
    }
}

