/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.model;

import java.beans.PropertyChangeEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.cube.CubeBuilder;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeCalculatedMeasure;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.cube.model.SideEffects;

public class MeasureExpressionCascade
extends DBObjectListener
implements SideEffects {
    private Pattern pat;
    private String newQualifiedName;
    private OracleDatabaseImpl oraDb;
    private CubeBuilder cubeBuilder;
    private String cubeName;
    private Cube cube;
    private ArrayList<SystemObject> affectedOld = new ArrayList();
    private ArrayList<SystemObject> affectedNew = new ArrayList();
    private final Logger LOG = Logger.getLogger(MeasureExpressionCascade.class.getName());
    private boolean dropRelatedMeasures = true;
    private String MEASURE_REGEX = "(\\\"?)%s\\1\\.(\\\"?)%s\\2\\.(\\\"?)%s\\3";
    private String CUBE_REGEX = "(\\\"?)%s\\1\\.(\\\"?)%s\\2";

    public MeasureExpressionCascade(Cube cube, OracleDatabaseImpl oracleDatabaseImpl) {
        this.cube = cube;
        this.cubeBuilder = new CubeBuilder(oracleDatabaseImpl);
        this.oraDb = oracleDatabaseImpl;
    }

    public void setDropRelatedMeasures(boolean bl) {
        this.dropRelatedMeasures = bl;
    }

    public void runRenames(String string, String string2, boolean bl) {
        if (string == null || string2 == null || string.equals(string2)) {
            return;
        }
        String string3 = this.cube.getSchema().getName();
        String string4 = null;
        if (bl) {
            this.newQualifiedName = String.format("%s.%s.%s", string3, this.cube.getName(), string2);
            string4 = String.format(this.MEASURE_REGEX, string3, this.cube.getName(), string);
            this.cubeName = this.cube.getName();
        } else {
            this.newQualifiedName = String.format("%s.%s", string3, string2);
            string4 = String.format(this.CUBE_REGEX, string3, string);
            this.cubeName = string;
        }
        this.pat = Pattern.compile(string4, 2);
        this.iterateCubes(new Renamer());
    }

    private void iterateCubes(QueryWrapper.QueryRunnable queryRunnable) {
        QueryWrapper queryWrapper = new QueryWrapper((Database)this.oraDb, "select cube_name from all_cubes where aw_name = ? and owner = ?", new Object[]{this.cube.getAnalyticWorkspace(), this.cube.getSchema().getName()});
        try {
            queryWrapper.executeQuery(queryRunnable);
        }
        catch (DBException dBException) {
            this.LOG.log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
        }
    }

    public void objectUpdated(DBObjectChange dBObjectChange) {
        if (dBObjectChange.hasNameChanged()) {
            PropertyChangeEvent propertyChangeEvent = dBObjectChange.getPropertyChange("name");
            this.runRenames((String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue(), false);
        }
        this.cube.removeObjectListener(this);
        for (DBObject dBObject : dBObjectChange.getOwnedObjectsRemoved()) {
            if (!(dBObject instanceof CubeMeasure) && !(dBObject instanceof CubeCalculatedMeasure)) continue;
            this.deleteRelatedMeasures(dBObject.getName());
        }
        this.cube.addObjectListener(this);
    }

    private Cube getCube(String string) {
        Object object2;
        if (string.equals(this.cubeName)) {
            return this.cube;
        }
        for (Object object2 : this.affectedNew) {
            if (!object2.getName().equals(string)) continue;
            return (Cube)object2;
        }
        NameBasedID nameBasedID = new NameBasedID("CUBE", this.cube.getSchema().getName(), string, (AbstractDBObjectProvider)this.oraDb);
        object2 = this.cubeBuilder.createObject(string, this.cube.getSchema(), (DBObjectID)nameBasedID);
        try {
            this.cubeBuilder.buildProperties((Cube)object2);
            this.cubeBuilder.buildDetails((Cube)object2);
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        return object2;
    }

    @Override
    public List<SystemObject> getAffectedObjectOld() {
        return this.affectedOld;
    }

    @Override
    public List<SystemObject> getAffectedObjectNew() {
        return this.affectedNew;
    }

    private void deleteRelatedMeasures(String string) {
        if (this.dropRelatedMeasures) {
            this.cubeName = this.cube.getName();
            Deleter deleter = new Deleter(string);
            while (!deleter.patterns.isEmpty()) {
                this.pat = deleter.patterns.pop();
                this.iterateCubes(deleter);
            }
            for (CubeCalculatedMeasure cubeCalculatedMeasure : deleter.relatedCalcs) {
                cubeCalculatedMeasure.getCube().removeCalculatedMeasure(cubeCalculatedMeasure);
            }
        }
    }

    private class Deleter
    implements QueryWrapper.QueryRunnable {
        Stack<Pattern> patterns = new Stack();
        ArrayList<CubeCalculatedMeasure> relatedCalcs = new ArrayList();

        public Deleter(String string) {
            this.addPattern(MeasureExpressionCascade.this.cube.getSchema().getName(), MeasureExpressionCascade.this.cube.getName(), string);
        }

        private void addPattern(String string, String string2, String string3) {
            String string4 = String.format(MeasureExpressionCascade.this.MEASURE_REGEX, string, string2, string3);
            Pattern pattern = Pattern.compile(string4);
            this.patterns.push(pattern);
        }

        public void processResultSet(ResultSet resultSet) {
            try {
                while (resultSet.next()) {
                    boolean bl = false;
                    Cube cube = MeasureExpressionCascade.this.getCube(resultSet.getString(1));
                    CubeCalculatedMeasure[] cubeCalculatedMeasureArray = cube.getCalculatedMeasures();
                    for (int i = 0; i < cubeCalculatedMeasureArray.length; ++i) {
                        CubeCalculatedMeasure cubeCalculatedMeasure = cubeCalculatedMeasureArray[i];
                        Matcher matcher = MeasureExpressionCascade.this.pat.matcher(cubeCalculatedMeasure.getMeasureExpression());
                        if (!matcher.find()) continue;
                        if (!bl && MeasureExpressionCascade.this.cube != cube) {
                            bl = true;
                            MeasureExpressionCascade.this.affectedOld.add(DBUtil.makeClonedCopy((DBObject)cube));
                            MeasureExpressionCascade.this.affectedNew.add(cube);
                        }
                        this.relatedCalcs.add(cubeCalculatedMeasure);
                        this.addPattern(cubeCalculatedMeasure.getCube().getSchema().getName(), cubeCalculatedMeasure.getCube().getName(), cubeCalculatedMeasure.getName());
                    }
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                MeasureExpressionCascade.this.LOG.log(Level.SEVERE, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
    }

    private class Renamer
    implements QueryWrapper.QueryRunnable {
        private Renamer() {
        }

        public void processResultSet(ResultSet resultSet) {
            try {
                while (resultSet.next()) {
                    boolean bl = false;
                    Cube cube = MeasureExpressionCascade.this.getCube(resultSet.getString(1));
                    CubeCalculatedMeasure[] cubeCalculatedMeasureArray = cube.getCalculatedMeasures();
                    for (int i = 0; i < cubeCalculatedMeasureArray.length; ++i) {
                        CubeCalculatedMeasure cubeCalculatedMeasure = cubeCalculatedMeasureArray[i];
                        Matcher matcher = MeasureExpressionCascade.this.pat.matcher(cubeCalculatedMeasure.getMeasureExpression());
                        StringBuffer stringBuffer = new StringBuffer();
                        while (matcher.find()) {
                            if (!bl && MeasureExpressionCascade.this.cube != cube) {
                                bl = true;
                                MeasureExpressionCascade.this.affectedOld.add(DBUtil.makeClonedCopy((DBObject)cube));
                                MeasureExpressionCascade.this.affectedNew.add(cube);
                            }
                            matcher.appendReplacement(stringBuffer, MeasureExpressionCascade.this.newQualifiedName);
                        }
                        matcher.appendTail(stringBuffer);
                        cubeCalculatedMeasure.setMeasureExpression(stringBuffer.toString());
                    }
                }
            }
            catch (SQLException sQLException) {
                MeasureExpressionCascade.this.LOG.log(Level.SEVERE, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
    }
}

