/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build.wizard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import oracle.dbtools.db.DBUtil;
import oracle.ide.component.NewFilePanel;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.ModelUtil;
import oracle.olap.OLAPArb;
import oracle.olap.build.BuildObject;
import oracle.olap.build.log.BuildLog112;
import oracle.olap.db.OracleDatabaseInfo;

public class BuildSummaryPanel
extends DefaultTraversablePanel
implements ActionListener {
    private static final String EXT = ".sql";
    private static URLFilter SQL_FILTER = new DefaultURLFilter(UIBundle.get((String)"SQL_URLFILTER_TEXT"), ".sql");
    private JButton m_btnSave;
    private final BasicEditorPane m_txtSQL = new BasicEditorPane();
    private DBEditorConfig m_config;

    public BuildSummaryPanel() {
        this.layoutComponents();
    }

    public void onEntry(TraversableContext traversableContext) {
        this.updatePLSQL(traversableContext);
    }

    private void updatePLSQL(TraversableContext traversableContext) {
        boolean bl = false;
        String string = this.getPLSQL(traversableContext);
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        if (string != null) {
            textBuffer.insert(0, string.toCharArray());
        }
        BasicDocument basicDocument = new BasicDocument(textBuffer);
        basicDocument.setLanguageSupport(bl ? "foo.txt" : "foo.sql");
        this.m_txtSQL.setDocument((Document)basicDocument);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
    }

    protected String getPLSQL(TraversableContext traversableContext) {
        String string;
        String string2;
        String string3;
        boolean bl = false;
        List list = (List)traversableContext.get("BUILD_OBJECTS");
        int n = 0;
        String string4 = null;
        Connection connection = null;
        connection = ((BuildObject)list.get(0)).getConnection();
        string4 = ((BuildObject)list.get(0)).getOwner();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        bl = OracleDatabaseInfo.isDatabaseCompatible11_2_OrGreater(connection);
        boolean bl2 = (Boolean)traversableContext.get("RUNNOW");
        boolean bl3 = (Boolean)traversableContext.get("RUN_IN_JOBQ");
        boolean bl4 = (Boolean)traversableContext.get("RUN_IN_JOBQ_NOW");
        String string5 = (String)traversableContext.get("SQL_FILENAME");
        String string6 = (String)traversableContext.get("BUILD_LOG_LEVEL");
        int n2 = (Integer)traversableContext.get("BUILD_LOG_MAX_ERRORS");
        String string7 = "";
        String string8 = "";
        for (BuildObject buildObject : list) {
            String string9 = buildObject.getType();
            String string10 = buildObject.getInlineBuildSpecification();
            String string11 = buildObject.getCubeScriptName();
            string3 = "";
            string3 = buildObject.getDefaultBuildSpecificationName();
            if (!string7.isEmpty()) {
                string7 = string7 + ",";
            }
            if (string9.equalsIgnoreCase("CUBE")) {
                if (!string10.isEmpty()) {
                    string7 = string7 + buildObject.getFullyQualifiedName() + " USING (" + string10 + ")";
                } else if (string11.isEmpty() || string11.equalsIgnoreCase(string3)) {
                    string7 = string7 + buildObject.getFullyQualifiedName();
                } else if (!string11.isEmpty()) {
                    string7 = string7 + buildObject.getFullyQualifiedName() + " USING " + string11;
                }
                string8 = string8 + buildObject.getRefreshMethod();
            }
            if (!string9.equalsIgnoreCase("CUBE DIMENSION")) continue;
            boolean bl5 = buildObject.isSortOn();
            boolean bl6 = buildObject.isSynchOn();
            string2 = buildObject.getLoadOption();
            string = this.generateDimensionUsingClause(string2, bl5, string11, string10);
            string8 = string8 + buildObject.getRefreshMethod();
            string7 = string7 + buildObject.getFullyQualifiedName();
            if (bl6 && bl5 && string11.isEmpty() && string10.isEmpty()) continue;
            string7 = string7 + string;
        }
        string7 = string7.replaceAll("'", "''");
        boolean bl7 = (Boolean)traversableContext.get("ISATOMIC");
        boolean bl8 = (Boolean)traversableContext.get("REFRESH_AFTER_ERROR");
        boolean bl9 = (Boolean)traversableContext.get("AUTOORDER");
        boolean bl10 = (Boolean)traversableContext.get("ADDDIM");
        int n3 = (Integer)traversableContext.get("PARALLEL_PROC_NUM");
        string3 = String.format("BEGIN%n  DBMS_CUBE.BUILD(%n    '%1$s',%n    '%2$s', -- refresh method%n    %3$b, -- refresh after errors%n    %4$s, -- parallelism%n    %5$b, -- atomic refresh%n    %6$b, -- automatic order%n    %7$b); -- add dimensions%nEND;", string7, string8, bl8, n3, bl7, bl9, bl10);
        String string12 = "";
        if (bl) {
            BuildLog112 buildLog112 = null;
            buildLog112 = new BuildLog112(connection);
            try {
                buildLog112.createAllBuildLogTables(string6, n2);
                string12 = buildLog112.getEnableAllLogsScript();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string3 = String.format("begin%n %s %n %s %nend;", string12, string3);
        if (bl3 || bl4) {
            String string13 = "select " + string4 + ".CUBE_BUILD_ID.nextval from dual";
            string2 = dBUtil.executeReturnOneCol(string13);
            if (string2 != null) {
                n = Integer.valueOf(string2);
            }
            string = "OLAP$_" + n;
            string3 = bl ? String.format("BEGIN%n  DBMS_CUBE.BUILD(%n    '%1$s',%n    '%2$s', %n    %3$b, %n    %4$s, %n    %5$b, %n    %6$b, %n    %7$b, %n    '%8$s',%n    %9$d); %nEND;", string7, string8, bl8, n3, bl7, bl9, bl10, string, n) : String.format("BEGIN%n  DBMS_CUBE.BUILD(%n    '%1$s',%n    '%2$s', %n    %3$b, %n    %4$s, %n    %5$b, %n    %6$b, %n    %7$b,%n    '%8$s'); %nEND;", string7, string8, bl8, n3, bl7, bl9, bl10, string);
            string3 = String.format("begin%n %s %n %s %nend;", string12, string3);
            string3 = this.getDBMSSchedPLSQL(connection, traversableContext, string3, bl4, string);
        }
        return string3;
    }

    private String generateDimensionUsingClause(String string, boolean bl, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(" USING ");
        StringBuffer stringBuffer2 = new StringBuffer("LOAD ");
        StringBuffer stringBuffer3 = new StringBuffer("COMPILE ");
        if (!string3.isEmpty()) {
            stringBuffer.append("(");
            stringBuffer.append(string3 + ")");
        } else if (!string2.isEmpty()) {
            stringBuffer.append(string2);
        } else {
            if (string.equalsIgnoreCase("SYNCH")) {
                stringBuffer2.append("SYNCH");
            } else if (string.equalsIgnoreCase("NOSYNCH")) {
                stringBuffer2.append("NO SYNCH");
            } else if (string.equalsIgnoreCase("RETAIN")) {
                stringBuffer2.append("RETAIN");
            }
            stringBuffer.append("(");
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(",");
            if (bl) {
                stringBuffer3.append("SORT");
            } else {
                stringBuffer3.append("NO SORT");
            }
            stringBuffer.append(stringBuffer3);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private String getDBMSSchedPLSQL(Connection connection, TraversableContext traversableContext, String string, boolean bl, String string2) {
        String string3 = null;
        String string4 = (String)traversableContext.get("BUILD_JOB_CLASS");
        GregorianCalendar gregorianCalendar = (GregorianCalendar)traversableContext.get("JOBQ_SCHED_TIME");
        String string5 = string;
        string5 = string5.replaceAll("'", "''");
        String string6 = new String();
        string6 = gregorianCalendar.get(2) + 1 + "-" + gregorianCalendar.get(5) + "-" + gregorianCalendar.get(1) + " " + gregorianCalendar.get(11) + ":" + gregorianCalendar.get(12);
        int n = gregorianCalendar.getTimeZone().getOffset(gregorianCalendar.getTime().getTime());
        long l = n / 1000;
        String string7 = String.format("%1$02d:%2$02d", l / 3600L, l / 60L % 60L);
        Timestamp timestamp = null;
        if (!bl) {
            timestamp = new Timestamp(gregorianCalendar.getTimeInMillis());
        }
        String string8 = null;
        if (timestamp != null) {
            string8 = String.format("to_timestamp_tz('%s %s', 'MM-DD-YYYY HH24:MI TZH:TZM')", string6, string7);
        }
        string3 = String.format("begin %n  dbms_scheduler.create_job(%n    '%s', -- job name%n    'plsql_block',%n    '%s', -- dbms_cube.build call%n    0,%n    %s, -- start time%n    null,%n    null,%n    %s,%n    true,%n    true,%n    'OLAP Build');%n  end;", string2, string5, string8, string4);
        return string3;
    }

    private void layoutComponents() {
        if (this.getComponentCount() == 0) {
            DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("DDLPanel");
            boolean bl = this.m_config != null && this.m_config.isInFlatEditor();
            DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper((JPanel)((Object)this), bl);
            JLabel jLabel = new JLabel();
            dBUIResourceHelper.resLabel(jLabel, (Component)this.m_txtSQL, OLAPArb.get("OLAPDDL_PANEL_LABEL"), "SQL");
            this.m_btnSave = new JButton();
            this.m_btnSave.addActionListener(this);
            dBUIResourceHelper.resButton((AbstractButton)this.m_btnSave, UIBundle.get((String)"DDL_BUTTON_SAVE"), "Save");
            this.m_txtSQL.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane((Component)this.m_txtSQL);
            dBUILayoutHelper.add((Component)jLabel);
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.add((Component)jScrollPane, 3, 1);
            dBUILayoutHelper.add(Box.createVerticalStrut(200), 1, 1, false, false);
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.nextColumn();
            dBUILayoutHelper.nextColumn();
            dBUILayoutHelper.add((Component)this.m_btnSave);
            dBUILayoutHelper.getConstraints((Component)this.m_btnSave).anchor = 13;
            dBUILayoutHelper.layout();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_btnSave) {
            Object object2;
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setURLFilter(SQL_FILTER);
            URL uRL = null;
            while (uRLChooser.showSaveDialog((Component)((Object)this)) == 0) {
                uRL = uRLChooser.getSelectedURL();
                if (!ModelUtil.hasLength((String)URLFileSystem.getSuffix((URL)uRL))) {
                    object2 = URLFileSystem.getPath((URL)uRL);
                    uRL = URLFactory.replacePathPart((URL)uRL, (String)((String)object2 + EXT));
                }
                try {
                    uRL = NewFilePanel.validateURL((Component)((Object)this), (URL)uRL, (String)UIBundle.get((String)"SQLFILE_TYPE"), (boolean)true);
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog((Component)((Object)this));
                    break;
                }
                if (uRL == null) continue;
            }
            if (uRL != null) {
                try {
                    object2 = URLFileSystem.openOutputStream((URL)uRL);
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object2, IdeUtil.getIdeEncoding()));
                    bufferedWriter.write(this.m_txtSQL.getText());
                    ((Writer)bufferedWriter).flush();
                    ((Writer)bufferedWriter).close();
                }
                catch (IOException iOException) {
                    DBMessageDialog.showErrorDialog((Exception)iOException, (Object)this, (Level)Level.SEVERE, null, (String)UIBundle.get((String)"DDL_ERROR_SAVE_TITLE"), null);
                }
            }
        }
    }
}

