/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.config.Preferences;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.olap.OLAPArb;
import oracle.olap.preferences.OLAPBuildLogPreferenceSettings;

public class BuildOptionsPanel
extends DefaultTraversablePanel {
    private JCheckBox m_atomicRefreshCheckBox = new JCheckBox();
    private JCheckBox m_refreshAfterErrorsCheckBox = new JCheckBox();
    private JComboBox logLevelComboBox;
    private JLabel logLevelLabel;
    private JLabel maxErrorsLoggedLabel;
    private myNumberTextField maxErrorsLoggedTextField;
    private static Preferences _p = Preferences.getPreferences();
    private OLAPBuildLogPreferenceSettings buildLogSettings = OLAPBuildLogPreferenceSettings.getInstance((PropertyStorage)_p);

    public BuildOptionsPanel() {
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(OLAPArb.get("BUILD_WIZARD_PROC_OPTS_LABEL"));
        this.m_atomicRefreshCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.m_atomicRefreshCheckBox, (String)OLAPArb.get("BUILD_WIZARD_PROC_OPTS_ATOMIC_REFRESH_LABEL"));
        this.m_refreshAfterErrorsCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.m_refreshAfterErrorsCheckBox, (String)OLAPArb.get("BUILD_WIZARD_PROC_OPTS_REF_AFTER_ERR_LABEL"));
        MultiLineLabel multiLineLabel = new MultiLineLabel();
        multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
        multiLineLabel.setText(OLAPArb.get("BUILD_WIZARD_PROC_OPTS_INSTRUCTION_MSG"));
        this.logLevelComboBox = new JComboBox();
        this.logLevelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL_ACTION"), OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL_NOTICE"), OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL_INFO"), OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL_STATS"), OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL_DEBUG")}));
        this.logLevelComboBox.setName("logLevelComboBox");
        this.logLevelLabel = new JLabel();
        this.logLevelLabel.setLabelFor(this.logLevelComboBox);
        this.logLevelLabel.setText(StringUtils.stripMnemonic((String)OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL")));
        this.logLevelLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL")));
        this.maxErrorsLoggedLabel = new JLabel();
        this.maxErrorsLoggedLabel.setText(StringUtils.stripMnemonic((String)OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_MAX_ERRORS")));
        this.maxErrorsLoggedLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_MAX_ERRORS")));
        this.maxErrorsLoggedLabel.setName("maxErrorsLoggedLabel");
        this.maxErrorsLoggedLabel.setLabelFor(this.maxErrorsLoggedTextField);
        this.maxErrorsLoggedTextField = new myNumberTextField(6);
        this.maxErrorsLoggedTextField.setName("maxErrorsLoggedTextField");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)multiLineLabel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel.add((Component)this.m_atomicRefreshCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel.add((Component)this.m_refreshAfterErrorsCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 5);
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.logLevelLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.logLevelComboBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.maxErrorsLoggedLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.maxErrorsLoggedTextField, gridBagConstraints);
    }

    public void onEntry(TraversableContext traversableContext) {
        Boolean bl = (Boolean)traversableContext.get("ISATOMIC");
        Boolean bl2 = (Boolean)traversableContext.get("REFRESH_AFTER_ERROR");
        Boolean bl3 = (Boolean)traversableContext.get("ENABLE_ATOMIC");
        String string = (String)traversableContext.get("BUILD_LOG_LEVEL");
        int n = (Integer)traversableContext.get("BUILD_LOG_MAX_ERRORS");
        this.m_atomicRefreshCheckBox.setSelected(bl);
        this.m_atomicRefreshCheckBox.setEnabled(bl3);
        this.m_refreshAfterErrorsCheckBox.setSelected(bl2);
        String string2 = this.buildLogSettings.getLogLevelName(string);
        this.logLevelComboBox.setSelectedItem(string2);
        this.maxErrorsLoggedTextField.setText(Integer.toString(n));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Boolean bl = this.m_atomicRefreshCheckBox.isSelected();
        Boolean bl2 = this.m_refreshAfterErrorsCheckBox.isSelected();
        traversableContext.put("ISATOMIC", (Object)bl);
        traversableContext.put("REFRESH_AFTER_ERROR", (Object)bl2);
        String string = (String)this.logLevelComboBox.getSelectedItem();
        String string2 = this.buildLogSettings.getLogLevel(string);
        traversableContext.put("BUILD_LOG_LEVEL", (Object)string2);
        String string3 = this.maxErrorsLoggedTextField.getText();
        if (string3.length() == 0) {
            string3 = "0";
        }
        int n = Integer.valueOf(string3);
        traversableContext.put("BUILD_LOG_MAX_ERRORS", (Object)n);
    }

    public Object getExitTransition() {
        return "SCHED";
    }

    class myNumberTextField
    extends JTextField {
        private int m_maxlen;

        public myNumberTextField(int n) {
            super(n);
            this.m_maxlen = Integer.toString(Integer.MAX_VALUE).length();
        }

        public void setMaximumLength(int n) {
            this.m_maxlen = n;
        }

        @Override
        protected Document createDefaultModel() {
            return new RestrictedDocument();
        }

        class RestrictedDocument
        extends PlainDocument {
            RestrictedDocument() {
            }

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string != null) {
                    char[] cArray = new char[string.length()];
                    int n2 = 0;
                    for (int i = 0; i < string.length(); ++i) {
                        if (!Character.isDigit(string.charAt(i))) continue;
                        cArray[n2++] = string.charAt(i);
                    }
                    string = new String(cArray, 0, n2);
                    if (this.getLength() + string.length() <= myNumberTextField.this.m_maxlen) {
                        super.insertString(n, string, attributeSet);
                    }
                }
            }
        }
    }
}

