/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import oracle.javatools.icons.OracleIcons;
import oracle.olap.OLAPArb;
import oracle.olap.app.Resources;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.app.templates.templatelist.BaseTemplate;
import oracle.olap.app.templates.templatelist.Param;
import oracle.olap.app.templates.templatelist.TemplateExpression;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.templates.templatelist.TemplateList;
import oracle.olap.app.templates.templateview.ItemElement;
import oracle.olap.app.templates.templateview.ParamFinder;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.app.templates.templateview.TemplateHyperParamFactory;
import oracle.olap.app.templates.templateview.TemplateHyperParamFinder;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.stringexpr.ParamEval;
import oracle.olap.stringexpr.ParamProperty;
import oracle.olap.stringexpr.ParamStringExpr;
import oracle.olap.stringexpr.ParamValue;
import oracle.olap.stringexpr.ParseException;
import oracle.olap.stringexpr.StringExprParser;
import oracle.olap.util.ButtonMenu;

public abstract class BaseTemplateHyperView
implements TemplateHyperParamFinder,
ParamFinder,
ParamValue,
ParamEval,
PropertyChangeListener,
ParamProperty {
    private static final Logger LOG = Logger.getLogger(BaseTemplateHyperView.class.getName());
    public static final String TEMPLATE_ADDED = "TEMPLATE_ADDED";
    public static final String TEMPLATE_REMOVED = "TEMPLATE_REMOVED";
    public static final String TEMPLATE_REORDERED = "TEMPLATE_REORDERED";
    private static final int VERTICAL_SPACING = 5;
    private static final int PARAM_SPACING = 13;
    private static final int EXPR_MARK_LENGTH = "$sexpr".length();
    private final BaseTemplate baseTemplate;
    private final TemplateGroup templateGroup;
    private final Map<String, String> paramDefaults;
    private final List<TemplateHyperParam> hyperParams;
    private final TemplateContext templateContext;
    private final EventListenerList propertyChangeListeners;
    private final TemplateHyperContext hyperContext;
    private final Map<String, Object> allParams;
    private final BaseTemplateHyperView parentTemplateHyperView;
    protected int ROW_HEIGHT = 12;
    private boolean panelInitialized;
    protected JPanel panel;
    private LinkedList<GuiComponent> components = new LinkedList();
    protected HashMap<String, String> currentParameterValues = new HashMap();
    private static final Pattern tokenizer = Pattern.compile("((?:\\s*[^{}\\s]+\\s*)|(?:\\s+))|(\\{([^{}]+)\\})");

    public BaseTemplateHyperView(BaseTemplateHyperView baseTemplateHyperView, TemplateContext templateContext, TemplateHyperContext templateHyperContext, BaseTemplate baseTemplate, TemplateGroup templateGroup, Map<String, String> map) {
        this.baseTemplate = baseTemplate;
        this.templateGroup = templateGroup;
        this.templateContext = templateContext;
        this.hyperContext = templateHyperContext;
        this.parentTemplateHyperView = baseTemplateHyperView;
        templateHyperContext.setTemplateHyperParamFinder(this);
        this.propertyChangeListeners = new EventListenerList();
        this.hyperParams = new ArrayList<TemplateHyperParam>();
        this.allParams = new HashMap<String, Object>();
        this.panel = new JPanel(new FlowLayout(0, 4, 2));
        this.paramDefaults = map;
    }

    public BaseTemplateHyperView(BaseTemplateHyperView baseTemplateHyperView, TemplateContext templateContext, TemplateHyperContext templateHyperContext, BaseTemplate baseTemplate, TemplateGroup templateGroup) {
        this(baseTemplateHyperView, templateContext, templateHyperContext, baseTemplate, templateGroup, null);
    }

    public BaseTemplateHyperView getParentTemplateHyperView() {
        return this.parentTemplateHyperView;
    }

    protected void clearAllParamValues() {
        this.currentParameterValues.clear();
        this.allParams.clear();
    }

    protected Object getAllParamValue(String string) {
        Object object = this.allParams.get(string);
        if (object == null) {
            object = this.currentParameterValues.get(string);
        }
        return object;
    }

    protected void putAllParamValueOld(String string, Object object) {
        this.allParams.put(string, object);
    }

    protected void putAllParamValue(String string, String string2) {
        Object object = this.allParams.get(string);
        if (object == null) {
            this.allParams.put(string, string2);
        } else {
            ArrayList<String> arrayList = null;
            if (object instanceof String) {
                arrayList = new ArrayList<String>();
                arrayList.add(object.toString());
                this.allParams.put(string, arrayList);
            } else {
                arrayList = (ArrayList<String>)object;
            }
            if (string2 != null) {
                arrayList.add(string2);
            }
        }
    }

    public abstract TemplateList getTemplateList();

    public abstract String getName();

    public TemplateGroup getTemplateGroup() {
        return this.templateGroup;
    }

    public BaseTemplate getTemplate() {
        return this.baseTemplate;
    }

    public TemplateContext getTemplateContext() {
        return this.templateContext;
    }

    public TemplateHyperContext getTemplateHyperContext() {
        return this.hyperContext;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.add(PropertyChangeListener.class, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.remove(PropertyChangeListener.class, propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.propertyChangeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            ((PropertyChangeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
        }
    }

    public Object getProperty(String string) throws SQLException, IOException {
        TemplateHyperParam templateHyperParam = this.getHyperParamForName(string);
        if (templateHyperParam == null) {
            templateHyperParam = this.getHyperParamForType(string);
        }
        if (templateHyperParam != null) {
            Object object = templateHyperParam.getValue(string);
            if (object instanceof ItemElement) {
                object = ((ItemElement)object).getExpression();
            }
            return object;
        }
        return null;
    }

    protected abstract String getUi();

    protected Object getTemplateValue(String string) throws SQLException, IOException {
        return null;
    }

    protected int indexOf(BaseTemplateHyperView baseTemplateHyperView) {
        return 0;
    }

    @Override
    public Object getValue(String string) {
        Object object = null;
        try {
            object = this.getTemplateValue(string);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, String.format("Fetching Template Value property %s", string), exception);
        }
        return object;
    }

    @Override
    public Object getValue(String string, Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            ParamEval paramEval;
            Object object;
            block9: {
                object = objectArray[0];
                if (object instanceof BaseTemplateHyperView) {
                    paramEval = (BaseTemplateHyperView)object;
                    if (string.equalsIgnoreCase("expression$")) {
                        try {
                            return ((BaseTemplateHyperView)paramEval).getExpression();
                        }
                        catch (Exception exception) {
                            LOG.log(Level.SEVERE, "Error fetching Template Value Expressions", exception);
                            break block9;
                        }
                    }
                    Object object2 = ((BaseTemplateHyperView)paramEval).getAllParamValue(string);
                    if (object2 == null) {
                        try {
                            object2 = ((BaseTemplateHyperView)paramEval).getProperty(string);
                        }
                        catch (Exception exception) {
                            LOG.log(Level.SEVERE, String.format("Error fetching Template Property %s", string), exception);
                        }
                    }
                    return object2;
                }
            }
            if (object instanceof NamedObject) {
                paramEval = (NamedObject)object;
                return ((NamedObject)paramEval).getValue(string);
            }
        }
        return null;
    }

    public abstract String getExpression() throws SQLException, IOException;

    private String evaluateStringExpr(String string) throws SQLException, IOException {
        String string2 = null;
        int n = EXPR_MARK_LENGTH;
        if (string.charAt(n) == ':') {
            n = string.indexOf(91, n);
            string2 = string.substring(EXPR_MARK_LENGTH + 1, n);
        }
        String string3 = string = string.substring(n + 1, string.length() - 2);
        try {
            ParamValue paramValue = StringExprParser.getParamValue();
            string3 = StringExprParser.getParseTree(string, new ParamValue(){

                @Override
                public Object getValue(String string) throws SQLException, IOException {
                    Object object = BaseTemplateHyperView.this.getProperty(string);
                    if (object == null) {
                        object = BaseTemplateHyperView.this.getAllParamValue(string);
                    }
                    if (object == null) {
                        object = BaseTemplateHyperView.this.getMetadataProperty(string);
                    }
                    if (object == null) {
                        object = BaseTemplateHyperView.this.getTemplateValue(string);
                    }
                    return object;
                }
            });
            StringExprParser.setParamValue(paramValue);
            if (string2 != null) {
                this.currentParameterValues.put(string2, string3);
            }
        }
        catch (ParseException parseException) {
            LOG.log(Level.SEVERE, String.format("Expression %s failed with %s", string, parseException.getMessage()), parseException);
            string3 = String.format(" \"%s\"->%s\n", string, parseException.getMessage());
        }
        return string3;
    }

    private String evaluateStringExprs(String string) throws SQLException, IOException {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = -1;
        while ((n2 = string.indexOf("$sexpr")) != -1 && (n = string.indexOf("]$")) >= 0) {
            String string2 = string.substring(n2, n + 2);
            String string3 = "";
            string3 = this.evaluateStringExpr(string2);
            String string4 = string;
            string = string4.substring(0, n2);
            if (string3 == null) {
                if (string.isEmpty()) {
                    return null;
                }
                string3 = "";
            }
            string = string + string3;
            string = string + string4.substring(n + 2, string4.length());
        }
        return string;
    }

    private Object getMetadataProperty(String string, String string2) {
        if (string != null && string.equalsIgnoreCase("cube")) {
            Cube cube = this.getTemplateContext().getCube();
            if (cube != null) {
                return this.getMetadataProperty(cube, string2);
            }
        } else {
            NamedObject namedObject;
            Object object;
            TemplateHyperParam templateHyperParam = this.getScopedHyperParamForType(string);
            if (templateHyperParam != null && (object = templateHyperParam.getValue(string2)) instanceof NamedObject && (namedObject = (NamedObject)object) != null) {
                return this.getMetadataProperty(namedObject, string2);
            }
        }
        return this.getMetadataProperty(string2);
    }

    private Object getMetadataProperty(String string) {
        Object object = string;
        NamedObjectWithDesc namedObjectWithDesc = null;
        namedObjectWithDesc = !this.getTemplateContext().isCube() ? this.getTemplateContext().getBaseDimension() : this.getTemplateContext().getCube();
        if (namedObjectWithDesc != null) {
            object = this.getMetadataProperty(namedObjectWithDesc, string);
        }
        return object;
    }

    private Object getMetadataProperty(NamedObject namedObject, String string) {
        Object object = null;
        if (string != null && string.length() > 0) {
            object = namedObject.getValue(string);
        }
        return object;
    }

    public String getExpression(String string, Measure measure) throws SQLException, IOException {
        return this.getExpression(string, measure, null);
    }

    public String getExpression(String string, Measure measure, ItemElement itemElement) throws SQLException, IOException {
        ParamStringExpr paramStringExpr = ParamStringExpr.getInstance();
        ParamValue paramValue = new ParamValue(){

            @Override
            public Object getValue(String string) throws SQLException, IOException {
                Object object = BaseTemplateHyperView.this.getProperty(string);
                if (object == null) {
                    object = BaseTemplateHyperView.this.getAllParamValue(string);
                }
                if (object == null) {
                    object = BaseTemplateHyperView.this.getMetadataProperty(string);
                }
                if (object == null) {
                    object = BaseTemplateHyperView.this.getTemplateValue(string);
                }
                return object;
            }
        };
        string = paramStringExpr.getExpression(string, paramValue, this, measure, itemElement, this.currentParameterValues);
        return string;
    }

    @Override
    public String getParamPropertyValue(String string, String string2, Measure measure, ItemElement itemElement, HashMap<String, String> hashMap) throws SQLException, IOException {
        TemplateHyperParam templateHyperParam = itemElement != null && itemElement.getOptional() != null && itemElement.getOptional().getName().equals(string) ? itemElement.getOptional() : this.getHyperParamForName(string);
        if (templateHyperParam == null) {
            templateHyperParam = this.getHyperParamForType(string);
        }
        String string3 = "{" + string + "}";
        string3 = string;
        if (templateHyperParam != null) {
            Object object = templateHyperParam.getValue();
            if (string2 != null && object != null && object instanceof NamedObject) {
                NamedObject namedObject = (NamedObject)object;
                Object object2 = this.getMetadataProperty(namedObject, string2);
                if (object2 != null) {
                    string3 = object2.toString();
                }
            } else {
                string3 = templateHyperParam.getExpression(string2);
                string3 = object instanceof ItemElement ? this.getExpression(string3, measure, (ItemElement)object) : this.getExpression(string3, measure);
            }
        } else if (string.equalsIgnoreCase("measure")) {
            if (measure != null) {
                string3 = measure.getID();
            }
        } else {
            Object object;
            Object object3;
            String string4 = string2;
            String string5 = null;
            if (string4 == null) {
                string4 = string;
            }
            if (string != null) {
                string5 = string;
            }
            string3 = (object3 = this.getAllParamValue(string4)) != null ? object3.toString() : ((object = this.getMetadataProperty(string5, string4)) != null ? object.toString() : null);
        }
        if (templateHyperParam != null) {
            hashMap.put(string, string3);
        }
        return string3;
    }

    public BaseTemplateHyperView addNewTemplateView(BaseTemplate baseTemplate, TemplateContext templateContext, TemplateHyperContext templateHyperContext, TemplateGroup templateGroup, Map<String, String> map) throws SQLException, IOException {
        return null;
    }

    public BaseTemplateHyperView createTemplateView(BaseTemplate baseTemplate, TemplateContext templateContext, TemplateHyperContext templateHyperContext, TemplateGroup templateGroup, Map<String, String> map) throws SQLException, IOException {
        return null;
    }

    public boolean removeTemplateView(BaseTemplateHyperView baseTemplateHyperView) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public JPanel getPanel(int n) throws SQLException, IOException {
        if (!this.panelInitialized) {
            Object object;
            Object object2;
            Serializable serializable;
            Object object4;
            this.panelInitialized = true;
            String string = this.getUi();
            int n2 = 0;
            if (this.getTemplate() != null && string == null) {
                return null;
            }
            Resources resources = this.hyperContext.getResources();
            this.panel.removeAll();
            if (resources != null && string != null && this.getTemplateList() != null) {
                string = resources.getXLIFFResource(this.getTemplateList().getFileName(), string);
            }
            if (this.parentTemplateHyperView != null && this.parentTemplateHyperView.getTemplate() != null && this.parentTemplateHyperView.getTemplate().isList()) {
                if (this.getTemplate() != null) {
                    object4 = new JButton(OracleIcons.getIcon((String)"delete.png"));
                    ((JComponent)object4).setToolTipText(OLAPArb.get("CALC_TEMPLATE_REMOVE_STEP_TOOL_TIP"));
                    ((JComponent)object4).setPreferredSize(new Dimension(25, 17));
                    this.panel.add((Component)object4);
                    ((AbstractButton)object4).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            BaseTemplateHyperView.this.parentTemplateHyperView.removeTemplateView(BaseTemplateHyperView.this);
                        }
                    });
                } else {
                    object4 = new JPopupMenu();
                    serializable = new ArrayList();
                    for (final BaseTemplate object5 : this.templateGroup.getTemplates()) {
                        void var9_15;
                        String string2 = "";
                        if (this.templateGroup.getTemplateList() != null) {
                            String string3 = resources.getXLIFFResource(this.templateGroup.getTemplateList().getFileName(), object5.getMenu());
                        } else {
                            String string4 = object5.getMenu();
                        }
                        object2 = new JMenuItem((String)var9_15);
                        ((JPopupMenu)object4).add((JMenuItem)object2);
                        serializable.add(object2);
                        ((AbstractButton)object2).addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                try {
                                    BaseTemplateHyperView.this.parentTemplateHyperView.addNewTemplateView(object5, BaseTemplateHyperView.this.getTemplateContext(), BaseTemplateHyperView.this.getTemplateHyperContext(), BaseTemplateHyperView.this.templateGroup, null);
                                }
                                catch (Exception exception) {
                                    LOG.log(Level.SEVERE, "Exception adding a child template", exception);
                                }
                            }
                        });
                    }
                    object = ButtonMenu.createButtonMenu(null, OracleIcons.getIcon((String)"add.png"), (List<JMenuItem>)((Object)serializable));
                    ((JComponent)object).setToolTipText(OLAPArb.get("CALC_TEMPLATE_ADD_STEP_TOOL_TIP"));
                    ((JComponent)object).setPreferredSize(new Dimension(50, 17));
                    this.panel.add((Component)object);
                }
            }
            object4 = new Resizer(this.hyperContext.getResizeMode());
            if (string != null) {
                serializable = new JLabel();
                this.ROW_HEIGHT = ((JComponent)serializable).getFontMetrics(((Component)serializable).getFont()).getMaxAscent() + 5;
                object = tokenizer.matcher(string);
                while (((Matcher)object).find()) {
                    String string5 = ((Matcher)object).group(1);
                    if (string5 != null) {
                        JLabel jLabel = new JLabel(string5);
                        n2 += string5.length();
                        this.panel.add(jLabel);
                        this.components.add(new GuiComponent(jLabel));
                        continue;
                    }
                    String string6 = ((Matcher)object).group(3);
                    n2 += 40;
                    Object var9_21 = null;
                    TemplateHyperParam templateHyperParam = TemplateHyperParamFactory.getInstance().getHyperParam(this, this.hyperContext, this.templateContext, this, string6);
                    if (templateHyperParam != null) {
                        templateHyperParam.getComponent().setName(this.baseTemplate.getName() + "." + string6);
                        this.addParameterComponents(templateHyperParam);
                        continue;
                    }
                    this.panel.add(new JLabel("PARAM:" + string6));
                }
                this.setupAllHyperParamDependencies();
                for (TemplateHyperParam templateHyperParam : this.hyperParams) {
                    templateHyperParam.init();
                }
                for (TemplateHyperParam templateHyperParam : this.hyperParams) {
                    if (this.paramDefaults != null && (object2 = this.paramDefaults.get(templateHyperParam.getType())) != null) {
                        templateHyperParam.setDefault((String)object2);
                    }
                    if (this.hyperContext.getResizeMode() == TemplateHyperContext.ResizeMode.LEGACY) continue;
                    templateHyperParam.addPropertyChangeListener((PropertyChangeListener)object4);
                }
            }
            if (this.hyperContext.getResizeMode() != TemplateHyperContext.ResizeMode.LEGACY) {
                this.panel.addHierarchyListener((HierarchyListener)object4);
                this.panel.addAncestorListener((AncestorListener)object4);
                this.panel.addComponentListener((ComponentListener)object4);
            } else if (n2 > 300) {
                this.panel.setPreferredSize(new Dimension(400, 84));
            } else if (n2 > 260) {
                this.panel.setPreferredSize(new Dimension(400, 72));
            } else if (n2 > 170) {
                this.panel.setPreferredSize(new Dimension(400, 60));
            } else {
                this.panel.setPreferredSize(new Dimension(400, 24));
            }
        }
        return this.panel;
    }

    private void addParameterComponents(TemplateHyperParam templateHyperParam) {
        templateHyperParam.addPropertyChangeListener(this);
        this.hyperParams.add(templateHyperParam);
        if (templateHyperParam.isAddToGUI()) {
            this.panel.add(templateHyperParam.getComponent());
            this.components.add(new GuiComponent(templateHyperParam));
        }
        for (TemplateHyperParam templateHyperParam2 : templateHyperParam.getOptionalHyperParams()) {
            templateHyperParam2.setIsOptional(true);
            this.addParameterComponents(templateHyperParam2);
        }
    }

    public void setupAllHyperParamDependencies() {
        this.setupHyperParamDependencies(this.hyperParams);
    }

    public abstract boolean setupTemplateHyperParamDependencies(List<TemplateHyperParam> var1);

    /*
     * WARNING - void declaration
     */
    public boolean setupHyperParamDependencies(List<TemplateHyperParam> list) {
        void var3_7;
        for (TemplateHyperParam propertyChangeListener2 : list) {
            propertyChangeListener2.setUpDependencies(list);
        }
        boolean bl = false;
        BaseTemplateHyperView baseTemplateHyperView = this.getParentTemplateHyperView();
        if (baseTemplateHyperView != null) {
            BaseTemplateHyperView baseTemplateHyperView2 = baseTemplateHyperView.getParentTemplateHyperView();
        }
        while (!bl && var3_7 != null) {
            bl = var3_7.setupTemplateHyperParamDependencies(list);
            if (bl) continue;
            BaseTemplateHyperView baseTemplateHyperView3 = var3_7.getParentTemplateHyperView();
        }
        return bl;
    }

    public List<String> getVisibleParamNames() throws SQLException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TemplateHyperParam templateHyperParam : this.getHyperParams()) {
            if (!templateHyperParam.getComponent().isVisible()) continue;
            if (templateHyperParam.getName() != null) {
                arrayList.add(templateHyperParam.getName());
                continue;
            }
            arrayList.add(templateHyperParam.getType().toString());
        }
        return arrayList;
    }

    @Override
    public TemplateHyperParam getHyperParamForName(String string) {
        for (TemplateHyperParam templateHyperParam : this.getHyperParams()) {
            String string2 = templateHyperParam.getName();
            if (string2 == null) continue;
            if (string2.equalsIgnoreCase(string)) {
                return templateHyperParam;
            }
            if ((string2 + "_name").equalsIgnoreCase(string)) {
                return templateHyperParam;
            }
            if (!(string2 + "_description").equalsIgnoreCase(string)) continue;
            return templateHyperParam;
        }
        return null;
    }

    public TemplateHyperParam getScopedHyperParamForType(String string) {
        TemplateHyperParam templateHyperParam = this.getHyperParamForType(string);
        BaseTemplateHyperView baseTemplateHyperView = this.parentTemplateHyperView;
        while (templateHyperParam == null && baseTemplateHyperView != null) {
            templateHyperParam = baseTemplateHyperView.getHyperParamForType(string);
            baseTemplateHyperView = baseTemplateHyperView.parentTemplateHyperView;
        }
        return templateHyperParam;
    }

    @Override
    public TemplateHyperParam getHyperParamForType(String string) {
        for (TemplateHyperParam templateHyperParam : this.getHyperParams()) {
            if (!templateHyperParam.getType().toString().equalsIgnoreCase(string)) continue;
            return templateHyperParam;
        }
        return null;
    }

    @Override
    public Param getParam(String string) {
        for (Param param : this.templateGroup.getParams()) {
            if (param.getName() == null || !param.getName().equals(string)) continue;
            return param;
        }
        if (this.getTemplateList() != null) {
            for (Param param : this.getTemplateList().getParams()) {
                if (param.getName() == null || !param.getName().equals(string)) continue;
                return param;
            }
        }
        return null;
    }

    public List<TemplateHyperParam> getHyperParams() {
        return this.hyperParams;
    }

    public List<String> getParamNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TemplateHyperParam templateHyperParam : this.hyperParams) {
            if (templateHyperParam.getName() != null) {
                arrayList.add(templateHyperParam.getName());
                continue;
            }
            arrayList.add(templateHyperParam.getType().toString());
        }
        return arrayList;
    }

    protected Map<String, String> getParamDefaults() {
        return this.paramDefaults;
    }

    public HashMap<String, String> getCurrentParameterValues() {
        return this.currentParameterValues;
    }

    public Map<String, String> getTemplateExpressions() throws SQLException, IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (TemplateExpression templateExpression : this.baseTemplate.getTemplateExpressions()) {
            String string = templateExpression.getName();
            String string2 = templateExpression.getExpression();
            if (string2 == null && (templateExpression = this.getTemplateList().findTemplateExpression(string)) != null) {
                string2 = templateExpression.getExpression();
            }
            String string3 = this.getExpression(string2, null);
            hashMap.put(string, string3);
        }
        return hashMap;
    }

    private class Resizer
    extends ComponentAdapter
    implements PropertyChangeListener,
    HierarchyListener,
    AncestorListener {
        private TemplateHyperContext.ResizeMode mode;
        private Component container;

        public Resizer(TemplateHyperContext.ResizeMode resizeMode) {
            this.mode = resizeMode;
        }

        private void findContainer() {
            String string;
            int n;
            this.container = BaseTemplateHyperView.this.panel;
            for (n = 10; this.container != null && n > 0 && !"TEMPLATEGUI_CONTAINER".equals(string = this.container.getName()); --n) {
                this.container = this.container.getParent();
            }
            if (n == 0 || this.container == null) {
                this.container = BaseTemplateHyperView.this.panel;
            } else {
                BaseTemplateHyperView.this.panel.removeComponentListener(this);
                this.container.addComponentListener(this);
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.calculateSize();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.calculateSize();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            this.calculateSize();
        }

        private void calculateSize() {
            try {
                if (this.container == null || BaseTemplateHyperView.this.panel == this.container) {
                    this.findContainer();
                }
                int n = this.container.getWidth() - 6;
                int n2 = BaseTemplateHyperView.this.panel.getWidth();
                int n3 = BaseTemplateHyperView.this.panel.getHeight();
                boolean bl = false;
                if (n > 0) {
                    int n4 = 0;
                    for (Container container = this.container.getParent(); container != null; container = container.getParent()) {
                        n4 = container.getWidth();
                        if (n4 >= n) continue;
                        n = n4 - 50;
                    }
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = BaseTemplateHyperView.this.ROW_HEIGHT;
                    boolean bl2 = true;
                    for (GuiComponent guiComponent : BaseTemplateHyperView.this.components) {
                        int n8 = guiComponent.getWidth(n);
                        n6 += n8;
                        bl2 &= n8 == 0;
                        if ((n5 += n8) < n) continue;
                        n7 += BaseTemplateHyperView.this.ROW_HEIGHT;
                        n5 = n8;
                    }
                    if (bl2) {
                        n7 = 0;
                    } else {
                        while (n5 > n) {
                            n7 += BaseTemplateHyperView.this.ROW_HEIGHT;
                            n5 -= n;
                        }
                    }
                    Object object = null;
                    if (this.mode == TemplateHyperContext.ResizeMode.PARAMETER && n7 == BaseTemplateHyperView.this.ROW_HEIGHT) {
                        object = new Dimension(n5, n7);
                        bl = n5 != n2 || n7 != n3;
                    } else {
                        object = new Dimension(n, n7);
                        bl = n != n2 || n7 != n3;
                    }
                    BaseTemplateHyperView.this.panel.setPreferredSize((Dimension)object);
                    BaseTemplateHyperView.this.panel.setMinimumSize((Dimension)object);
                    BaseTemplateHyperView.this.panel.setSize((Dimension)object);
                    if (bl) {
                        BaseTemplateHyperView.this.panel.revalidate();
                        BaseTemplateHyperView.this.panel.repaint();
                    }
                    if (BaseTemplateHyperView.this.panel.getParent() != null) {
                        BaseTemplateHyperView.this.panel.getParent().invalidate();
                    }
                }
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, "Error calculating template size", throwable);
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            this.calculateSize();
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }
    }

    private static class GuiComponent {
        private TemplateHyperParam param;
        private int width;

        GuiComponent(TemplateHyperParam templateHyperParam) {
            this.param = templateHyperParam;
        }

        GuiComponent(JLabel jLabel) {
            this.width = jLabel.getFontMetrics(jLabel.getFont()).stringWidth(jLabel.getText());
        }

        int getWidth(int n) {
            if (this.param == null) {
                return this.width + 13;
            }
            if (this.param.isVisible()) {
                this.width = this.param.getPixelSize(n);
                return this.width == 0 ? this.width : this.width + 13;
            }
            return 0;
        }
    }
}

