/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templatedialogimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import oracle.olap.app.Resources;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.ParsePatternMatcher;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.syntaxparser.SyntaxParserStateListener;
import oracle.olap.app.syntaxparser.testing.PermutationPersistence;
import oracle.olap.app.templates.templatedialog.TemplateData;
import oracle.olap.app.templates.templatedialog.TemplateGUI;
import oracle.olap.app.templates.templatedialog.TemplateHelper;
import oracle.olap.app.templates.templatedialog.TemplateHelperListener;
import oracle.olap.app.templates.templatedialogimpl.TemplateGUIImpl;
import oracle.olap.app.templates.templatedialogimpl.TemplateHyperContextDecorator;
import oracle.olap.app.templates.templatelist.Param;
import oracle.olap.app.templates.templatelist.Template;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.templates.templatelist.TemplateList;
import oracle.olap.app.templates.templateview.BaseTemplateHyperView;
import oracle.olap.app.templates.templateview.TemplateGroupHyperView;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.app.templates.templateview.TemplateHyperParamFinder;
import oracle.olap.app.templates.templateview.TemplateHyperView;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class TemplateHelperImpl
implements TemplateHelper {
    private static final Logger LOG = Logger.getLogger(TemplateHelperImpl.class.getName());
    private final EventListenerList listeners = new EventListenerList();
    private final TemplateContext context;
    private final TemplateHyperContext hyperContext;
    private final Template template;
    private final TemplateGroup group;
    private final SyntaxParser parser;
    private TemplateGUIImpl gui;
    private BaseTemplateHyperView templateView;
    private ParsePatternMatcher patternMatcher;
    private SyntaxParserStateListener parserStateListener = new SyntaxParserStateListener(){

        @Override
        public void stateChanged(final boolean bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        TemplateHelperImpl.this.reinitalize();
                    } else {
                        TemplateHelperImpl.this.patternMatcher = null;
                        TemplateHelperImpl.this.fireReinitialize();
                    }
                }
            });
        }
    };

    public TemplateHelperImpl(TemplateGroup templateGroup, TemplateContext templateContext, TemplateHyperContext templateHyperContext, SyntaxParser syntaxParser) {
        this.template = null;
        this.context = templateContext;
        this.hyperContext = templateHyperContext;
        this.parser = syntaxParser;
        this.parser.addSyntaxParserStateListener(this.parserStateListener);
        this.group = templateGroup;
        this.reinitalize();
    }

    public TemplateHelperImpl(Template template, TemplateGroup templateGroup, TemplateContext templateContext, TemplateHyperContext templateHyperContext, SyntaxParser syntaxParser) {
        this.context = templateContext;
        this.hyperContext = templateHyperContext;
        this.template = template;
        this.parser = syntaxParser;
        this.parser.addSyntaxParserStateListener(this.parserStateListener);
        this.group = this.fixGroup(template, templateGroup);
        this.reinitalize();
    }

    @Override
    public void reinitalize() {
        this.templateView = this.createView(this.template, this.group, this.context, this.hyperContext);
        this.gui = new TemplateGUIImpl(this, this.templateView);
        this.gui.createAllTemplateParams();
        this.patternMatcher = null;
        this.patternMatcher = this.getParsePatternMatcher();
        this.fireReinitialize();
    }

    public ParsePatternMatcher getParsePatternMatcher() {
        if (this.patternMatcher == null && this.templateView != null) {
            boolean bl = true;
            BaseTemplateHyperView baseTemplateHyperView = this.createView(this.template, this.group, this.context, this.hyperContext);
            TemplateGUIImpl templateGUIImpl = new TemplateGUIImpl(this, baseTemplateHyperView);
            templateGUIImpl.createAllTemplateParams();
            LinkedList<TemplateHyperParam> linkedList = new LinkedList<TemplateHyperParam>();
            TemplateGUIImpl.getAllHyperParams(baseTemplateHyperView, linkedList);
            Permuter permuter = new Permuter(linkedList, baseTemplateHyperView);
            LOG.finest(String.format("%n%n/* %s */%n", this.getTitle()));
            this.patternMatcher = new ParsePatternMatcher(this.parser);
            PermutationPersistence permutationPersistence = null;
            while (bl) {
                try {
                    String string = baseTemplateHyperView.getExpression();
                    HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                    LinkedHashMap<String, ParseNode> linkedHashMap = new LinkedHashMap<String, ParseNode>();
                    this.getParamValues(baseTemplateHyperView, hashMap, linkedHashMap);
                    LOG.finest(String.format("Generating: %s", string));
                    if (permutationPersistence != null) {
                        permutationPersistence.persistXML(this.getTitle(), string, linkedHashMap, hashMap);
                    }
                    for (TemplateHyperParam templateHyperParam : linkedList) {
                        Param param = templateHyperParam.getParam();
                        if (param == null) continue;
                        for (String string2 : linkedHashMap.keySet()) {
                            if (!string2.equals(param.getName()) || param.getCheckName() == null) continue;
                            linkedHashMap.get(string2).setCheckName(param.isCheckName());
                        }
                    }
                    ParseNode parseNode = this.patternMatcher.setupParsePattern(string, linkedHashMap, hashMap);
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, String.format("Error generating the ParsePattern for %s", this.getTitle()), exception);
                }
                bl = permuter.permute();
            }
            if (permutationPersistence != null) {
                permutationPersistence.outputDoc(this.getTitle());
            }
        }
        return this.patternMatcher;
    }

    private void getParamValues(BaseTemplateHyperView baseTemplateHyperView, Map<String, List<String>> map, Map<String, ParseNode> map2) {
        block3: {
            block2: {
                this.addEntry(map, baseTemplateHyperView.getCurrentParameterValues());
                if (!(baseTemplateHyperView instanceof TemplateGroupHyperView)) break block2;
                TemplateGroupHyperView templateGroupHyperView = (TemplateGroupHyperView)baseTemplateHyperView;
                for (BaseTemplateHyperView baseTemplateHyperView2 : templateGroupHyperView.getAllTemplateViews()) {
                    this.getParamValues(baseTemplateHyperView2, map, map2);
                }
                break block3;
            }
            if (!(baseTemplateHyperView instanceof TemplateHyperView)) break block3;
            for (TemplateHyperParam templateHyperParam : baseTemplateHyperView.getHyperParams()) {
                map2.put(templateHyperParam.getName(), templateHyperParam.getPattern());
            }
        }
    }

    private void addEntry(Map<String, List<String>> map, Map<String, String> map2) {
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            List<String> list = map.get(entry.getKey());
            if (list == null) {
                list = new LinkedList<String>();
                map.put(entry.getKey(), list);
            }
            if (list.contains(entry.getValue())) continue;
            list.add(entry.getValue());
        }
    }

    @Override
    public int matchesPattern(ParseNode parseNode) {
        this.patternMatcher = this.getParsePatternMatcher();
        if (this.patternMatcher != null) {
            int n = this.patternMatcher.matchesPattern(parseNode);
            return n;
        }
        return 0;
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public String getTitle() {
        TemplateList templateList;
        TemplateList templateList2;
        Resources resources = this.hyperContext.getResources();
        String string = "";
        string = this.template == null ? ((templateList2 = this.group.getTemplateList()) != null ? resources.getXLIFFResource(templateList2.getFileName(), this.group.getMenu()) : this.group.getMenu()) : ((templateList = this.template.getTemplateList()) != null ? resources.getXLIFFResource(templateList.getFileName(), this.template.getMenu()) : this.template.getMenu());
        if (string.indexOf("{") >= 0) {
            try {
                string = this.templateView.getExpression(string, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public TemplateGroup getTemplateGroup() {
        return this.group;
    }

    @Override
    public TemplateGUI getGUI(boolean bl) {
        if (bl) {
            return this.gui;
        }
        return new TemplateGUIImpl(this, this.createView(this.template, this.group, this.context, this.hyperContext));
    }

    private BaseTemplateHyperView createView(Template template, TemplateGroup templateGroup, TemplateContext templateContext, TemplateHyperContext templateHyperContext) {
        try {
            TemplateHyperContextDecorator templateHyperContextDecorator = new TemplateHyperContextDecorator(templateHyperContext){
                TemplateHyperParamFinder hyperFinder;

                @Override
                public TemplateHyperParamFinder getTemplateHyperParamFinder() {
                    return this.hyperFinder;
                }

                @Override
                public void setTemplateHyperParamFinder(TemplateHyperParamFinder templateHyperParamFinder) {
                    this.hyperFinder = templateHyperParamFinder;
                }

                @Override
                public boolean isTimeTemplate() {
                    return TemplateHelperImpl.this.group.isTimeTemplate();
                }
            };
            if (template != null) {
                return new TemplateHyperView(null, templateContext, (TemplateHyperContext)templateHyperContextDecorator, template, templateGroup);
            }
            return new TemplateGroupHyperView(null, templateContext, templateHyperContextDecorator, templateGroup);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, template.getName(), exception);
            return null;
        }
    }

    private TemplateGroup fixGroup(Template template, TemplateGroup templateGroup) {
        TemplateGroup templateGroup2 = new TemplateGroup();
        if (template.getName() != null) {
            templateGroup2.setName(template.getName());
        }
        if (templateGroup != null) {
            templateGroup2.setType(templateGroup.getType());
            templateGroup2.setTemplateList(templateGroup.getTemplateList());
            templateGroup2.setTimeTemplates(templateGroup.isTimeTemplate());
            for (Param param : templateGroup.getParams()) {
                templateGroup2.addParam(param);
            }
            if (template.getName() == null) {
                templateGroup2.setName(templateGroup.getName());
            }
        }
        if (template.getParams() != null) {
            for (Param param : template.getParams()) {
                templateGroup2.addParam(param);
            }
        }
        templateGroup2.addTemplate(template);
        for (Param param : templateGroup2.getParams()) {
            template.addParam(param);
        }
        return templateGroup2;
    }

    @Override
    public void addTemplateHelperListener(TemplateHelperListener templateHelperListener) {
        this.listeners.add(TemplateHelperListener.class, templateHelperListener);
    }

    @Override
    public void removeTemplateHelperListener(TemplateHelperListener templateHelperListener) {
        this.listeners.remove(TemplateHelperListener.class, templateHelperListener);
    }

    private void fireReinitialize() {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            ((TemplateHelperListener)objectArray[i + 1]).helperReinitialized();
        }
    }

    @Override
    public TemplateData.Mode[] availableModes(TemplateData.Mode[] modeArray) {
        if (this.gui != null) {
            ArrayList<TemplateData.Mode> arrayList = new ArrayList<TemplateData.Mode>(modeArray.length);
            for (TemplateData.Mode mode : modeArray) {
                if (mode == TemplateData.Mode.WRAP) {
                    LinkedList<TemplateHyperParam> linkedList = new LinkedList<TemplateHyperParam>();
                    TemplateGUIImpl.getAllHyperParams(this.templateView, linkedList);
                    for (TemplateHyperParam templateHyperParam : linkedList) {
                        if (!templateHyperParam.isCanWrap()) continue;
                        arrayList.add(mode);
                    }
                    continue;
                }
                arrayList.add(mode);
            }
            return arrayList.toArray(new TemplateData.Mode[arrayList.size()]);
        }
        return modeArray;
    }

    static class Permuter {
        LinkedList<ParamTracker> choices;
        ParamTracker root;

        Permuter(List<TemplateHyperParam> list, BaseTemplateHyperView baseTemplateHyperView) {
            int n = 1;
            this.choices = new LinkedList();
            for (TemplateHyperParam templateHyperParam : list) {
                ParseNode parseNode = templateHyperParam.getPattern();
                if (parseNode == null) continue;
                if (ParseNode.PatternType.CHOICE == parseNode.getPatternType()) {
                    if (templateHyperParam.isOptional()) continue;
                    this.choices.add(new ParamTracker(templateHyperParam, parseNode, true));
                    continue;
                }
                if (Type.valueFrom(parseNode.getType()) != Type.NUMBER) continue;
                templateHyperParam.setValue(n++);
            }
        }

        public boolean newPermute() {
            boolean bl = false;
            for (ParamTracker paramTracker : this.choices) {
                boolean bl2 = this.permuteTracker(paramTracker);
                bl |= bl2;
            }
            return bl;
        }

        private boolean permuteTracker(ParamTracker paramTracker) {
            if (paramTracker.checked || !paramTracker.hyperParam.isVisible()) {
                return false;
            }
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            int n = paramTracker.index;
            while (paramTracker.generated[paramTracker.index]) {
                ++paramTracker.index;
                bl3 = true;
                if (paramTracker.index >= paramTracker.itemCount) {
                    paramTracker.index = 0;
                }
                if (n != paramTracker.index) continue;
                paramTracker.checked = true;
                return false;
            }
            if (bl3) {
                ParseNode parseNode = new ParseNode(null, null, ParseNode.PatternType.OPTION);
                parseNode.setOffset(paramTracker.index);
                paramTracker.hyperParam.setValue(parseNode);
                ParseNode object = paramTracker.hyperParam.getPattern();
                bl3 = object.getOffset() == paramTracker.index;
            } else if (paramTracker.firstGeneration) {
                bl3 = true;
            }
            paramTracker.firstGeneration = false;
            if (paramTracker.children.isEmpty()) {
                bl = true;
                bl2 = true;
                paramTracker.generated[paramTracker.index] = true;
            } else {
                for (ParamTracker paramTracker2 : paramTracker.children) {
                    boolean bl5 = this.permuteTracker(paramTracker2);
                    bl4 |= bl5;
                    bl &= paramTracker2.checked;
                    if (!paramTracker2.hyperParam.isVisible()) continue;
                    bl2 &= paramTracker2.checked;
                }
                paramTracker.generated[paramTracker.index] = bl2;
                if (!bl3 && !bl4) {
                    paramTracker.generated[paramTracker.index] = true;
                    bl3 = this.permuteTracker(paramTracker);
                }
            }
            return bl4 || bl3;
        }

        public boolean permute() {
            if (this.choices.isEmpty()) {
                return false;
            }
            return this.newPermute();
        }
    }

    static class ParamTracker {
        TemplateHyperParam hyperParam;
        int index = -1;
        boolean[] generated;
        List<ParamTracker> children = null;
        boolean checked;
        boolean firstGeneration;
        final int itemCount;

        ParamTracker(TemplateHyperParam templateHyperParam, ParseNode parseNode, boolean bl) {
            this.hyperParam = templateHyperParam;
            this.itemCount = parseNode.getEnd();
            this.generated = new boolean[this.itemCount];
            this.index = parseNode.getOffset();
            this.generated[this.index] = templateHyperParam.isVisible() && bl;
            this.firstGeneration = !this.generated[this.index];
            this.addOptionals(this, bl);
        }

        private void addOptionals(ParamTracker paramTracker, boolean bl) {
            if (paramTracker.hyperParam.getOptionalHyperParams().isEmpty()) {
                paramTracker.children = Collections.emptyList();
                this.generated[this.index] = this.hyperParam.isVisible() && bl;
                return;
            }
            paramTracker.children = new LinkedList<ParamTracker>();
            for (TemplateHyperParam templateHyperParam : paramTracker.hyperParam.getOptionalHyperParams()) {
                ParseNode parseNode = templateHyperParam.getPattern();
                if (parseNode.getPatternType() != ParseNode.PatternType.CHOICE) continue;
                paramTracker.children.add(new ParamTracker(templateHyperParam, parseNode, this.hyperParam.isVisible() && bl));
                this.generated[this.index] = false;
            }
        }

        public String toString() {
            return String.format("%s - %s - %d", this.hyperParam.getName(), this.checked, this.index);
        }
    }
}

