/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.actions.AbstractRenameAction;
import oracle.olap.actions.OLAPActionDDLPanel;
import oracle.olap.util.OLAPNameValidator;
import oracle.olap.util.UIStringUtils;

public class RenameDialog
extends JDialog
implements ActionListener {
    private RenameDialog currentInstance = null;
    private String owner;
    private String currentName;
    private boolean m_clickedOK = false;
    private final String OK_COMMAND = "OK_ID";
    private final String CANCEL_COMMAND = "CANCEL_ID";
    private final String HELP_COMMAND = "HELP_ID";
    private static final int NAME_LENGTH = 30;
    private JPanel promptPanel;
    private JButton m_btnOK;
    private JButton m_btnCancel;
    private JButton m_btnHelp;
    private JTextField oldName;
    private JTextField newName;
    private JTextField ownerName;
    private JTextField newDesctf;
    private JTextField newShortDesctf;
    private JTextField newLongDesctf;
    private OLAPActionDDLPanel sqlPanel;
    private AbstractRenameAction renameAction;
    private Database database;
    private String helpID;
    private JTabbedPane tabs;
    private static final int PROMPT_TAB = 0;
    private static final int SQL_TAB = 1;

    public RenameDialog(Frame frame, String string, String string2, String string3, String string4, Map<String, String> map, Database database, AbstractRenameAction abstractRenameAction) {
        super(frame, string, true);
        this.setName("RenameDialog");
        this.currentInstance = this;
        this.owner = string3;
        this.helpID = string2;
        this.currentName = string4;
        this.database = database;
        this.renameAction = abstractRenameAction;
        this.initDialog();
        this.initializeFields(map);
    }

    private void initDialog() {
        this.initComponents();
        this.layoutComponents();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.promptPanel, this.helpID);
        this.registerKeyboardActions();
    }

    private void initComponents() {
        this.m_btnOK = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_APPLY_BUTTON_TEXT")));
        this.m_btnOK.setName("m_btnOK");
        this.m_btnOK.setActionCommand("OK_ID");
        this.m_btnOK.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_APPLY_BUTTON_TEXT")));
        this.m_btnOK.addActionListener(this);
        this.m_btnCancel = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        this.m_btnCancel.setName("m_btnCancel");
        this.m_btnCancel.setActionCommand("CANCEL_ID");
        this.m_btnCancel.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        this.m_btnCancel.addActionListener(this);
        this.m_btnHelp = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.m_btnHelp.setName("m_btnHelp");
        this.m_btnHelp.setActionCommand("HELP_ID");
        this.m_btnHelp.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.m_btnHelp.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_btnOK);
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.tabs = new JTabbedPane();
        this.promptPanel = new JPanel(new GridBagLayout());
        this.promptPanel.setName("mainPanel");
        this.promptPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        JLabel jLabel = new JLabel(OLAPArb.getString("RENAME_DIALOG_OWNER_LABEL"));
        jLabel.setName("lblOwner");
        this.promptPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        this.ownerName = new JTextField(1024);
        this.ownerName.setName("ownerName");
        this.ownerName.setMinimumSize(new Dimension(250, 20));
        this.promptPanel.add((Component)this.ownerName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        JLabel jLabel2 = new JLabel(OLAPArb.getString("DESCRIPTION_PANEL_NAME_LABEL"));
        jLabel2.setName("lblOldName");
        this.promptPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.oldName = new JTextField(1024);
        this.oldName.setName("oldName");
        this.oldName.setMinimumSize(new Dimension(250, 20));
        this.promptPanel.add((Component)this.oldName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        JLabel jLabel3 = new JLabel(OLAPArb.format("RENAME_DIALOG_NEW_NAME_LABEL", this.renameAction.getObjectType()));
        jLabel3.setName("lblNewName");
        this.promptPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.newName = new JTextField(1024);
        this.newName.setName("newName");
        this.newName.setMinimumSize(new Dimension(250, 20));
        UIStringUtils.setKeyAdapterToNameField(this.newName);
        this.promptPanel.add((Component)this.newName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        JLabel jLabel4 = new JLabel(OLAPArb.getString("DESCRIPTION_PANEL_SHORT_LABEL"));
        jLabel4.setName("lblNewShortDesc");
        this.promptPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.newShortDesctf = new JTextField(1024);
        this.newShortDesctf.setName("newShortDescription");
        this.newShortDesctf.setMinimumSize(new Dimension(250, 20));
        this.promptPanel.add((Component)this.newShortDesctf, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        JLabel jLabel5 = new JLabel(OLAPArb.getString("DESCRIPTION_PANEL_LONG_LABEL"));
        jLabel5.setName("lblNewLongtDesc");
        this.promptPanel.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.newLongDesctf = new JTextField(1024);
        this.newLongDesctf.setName("newLongDescription");
        this.newLongDesctf.setMinimumSize(new Dimension(250, 20));
        this.promptPanel.add((Component)this.newLongDesctf, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        JLabel jLabel6 = new JLabel(OLAPArb.getString("DESCRIPTION_PANEL_DESCRIPTION"));
        jLabel6.setName("lblNewDesc");
        this.promptPanel.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.newDesctf = new JTextField(1024);
        this.newDesctf.setName("newDescription");
        this.newDesctf.setMinimumSize(new Dimension(250, 20));
        this.promptPanel.add((Component)this.newDesctf, gridBagConstraints);
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.m_btnHelp, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)this.m_btnOK, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.m_btnCancel, DialogButtonBar.CONSTRAINT_CANCEL);
        this.tabs.add(OLAPArb.getString("RENAME_DIALOG_PROMPTS_TAB"), this.promptPanel);
        this.sqlPanel = new OLAPActionDDLPanel();
        this.tabs.add(OLAPArb.getString("MAP_PANEL_QUERY_TAB"), this.sqlPanel);
        this.add((Component)this.tabs, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 5, 5));
        this.add((Component)dialogButtonBar, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.5, 10, 2, new Insets(5, 5, 5, 5), 5, 5));
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (RenameDialog.this.tabs.getSelectedIndex() == 1) {
                    try {
                        RenameDialog.this.sqlPanel.setDDLText(RenameDialog.this.renameAction.getOLAPDDLStatements());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this, "CANCEL_ID", KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(156, 0), 1);
    }

    private void initializeFields(Map<String, String> map) {
        this.ownerName.setText(this.owner);
        this.ownerName.setEnabled(false);
        this.oldName.setText(this.currentName);
        this.oldName.setEnabled(false);
        this.newName.setText(this.currentName);
        this.newDesctf.setText(map.get("Description"));
        this.newShortDesctf.setText(map.get("ShortDescription"));
        this.newLongDesctf.setText(map.get("LongDescription"));
    }

    public String getNewName() {
        return this.newName.getText().trim();
    }

    public String getNewDescription() {
        return this.newDesctf.getText().trim();
    }

    public String getNewShortDescription() {
        return this.newShortDesctf.getText().trim();
    }

    public String getNewLongDescription() {
        return this.newLongDesctf.getText().trim();
    }

    public boolean isOKSelected() {
        return this.m_clickedOK;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("OK_ID")) {
            this.renameAction.setNewObjectName(this.newName.getText());
            if (this.validateFields()) {
                this.m_clickedOK = true;
                this.currentInstance.setVisible(false);
            }
        } else if (string.equalsIgnoreCase("CANCEL_ID")) {
            this.m_clickedOK = false;
            this.currentInstance.setVisible(false);
        } else if (string.equalsIgnoreCase("HELP_ID")) {
            HelpSystem.getHelpSystem().showHelp((JComponent)this.promptPanel);
        }
    }

    private boolean validateFields() {
        String string = this.getNewName();
        string = string.toUpperCase();
        String string2 = null;
        String string3 = OLAPArb.get("RENAME_DIALOG_ERROR_TITLE");
        String string4 = null;
        if (!OLAPNameValidator.isNameValid(string, 30)) {
            this.displayError(OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_NAME_ERROR"), string3, string4);
            return false;
        }
        if (!this.isNameUnique(string) && !string.equalsIgnoreCase(this.currentName)) {
            string2 = OLAPArb.format("RENAME_DIALOG_DUPLICATE_NAME_ERROR", this.getNewName(), this.renameAction.getObjectType().toLowerCase());
            this.displayError(string2, string3, string4);
            return false;
        }
        return true;
    }

    private void displayError(String string, String string2, String string3) {
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)string2, (String)string3);
    }

    private boolean isNameUnique(String string) {
        return this.renameAction.isObjectNameUnique(string);
    }
}

