/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.Step;

public class FSMBuilder {
    private final Map _fsm = new HashMap(23);
    private transient Map _state;
    private transient Map _trans;
    private transient Step _curStep;

    public FSMBuilder() {
    }

    public FSMBuilder(Step[] fsmSteps) {
        this();
        if (fsmSteps != null) {
            int n = fsmSteps.length;
            int m = n - 1;
            for (int i = 0; i < n; ++i) {
                boolean isFinal = i >= m;
                String stateID = i == 0 ? "__START_STATE__" : String.valueOf(i);
                this.newState(stateID, fsmSteps[i], null, isFinal);
                if (isFinal) continue;
                this.setDefaultTrans(String.valueOf(i));
            }
        }
    }

    public static FSM newFSM(Step[] steps) {
        if (steps == null || steps.length == 0) {
            throw new IllegalArgumentException();
        }
        try {
            FSMBuilder fsmb = new FSMBuilder(steps);
            return fsmb.getFSM();
        }
        catch (FSMInvalidException e) {
            IllegalStateException ex = new IllegalStateException("#### Internal error in FSMBuilder");
            ex.initCause(e);
            throw ex;
        }
    }

    public void newStartState(Step step, Object defaultTargetStateID) {
        this.newState("__START_STATE__", step, defaultTargetStateID, false);
    }

    public void newState(Object stateID, Step step, Object defaultTargetStateID) {
        this.newState(stateID, step, defaultTargetStateID, false);
    }

    public void newFinalState(Object stateID, Step step) {
        this.newState(stateID, step, null, true);
    }

    public void newState(Object stateID, Step step, Object defaultTargetStateID, boolean isFinalState) {
        if (this._fsm.containsKey(stateID)) {
            this._state = (Map)this._fsm.get(stateID);
            this._trans = (Map)this._state.get("__TRANSITIONS__");
        } else {
            this._state = new HashMap(11);
            this._trans = new HashMap(11);
            this._fsm.put(stateID, this._state);
            this._state.put("__TRANSITIONS__", this._trans);
        }
        this._curStep = step;
        this._state.put("__FSMState_OBJ__", step);
        if (defaultTargetStateID != null) {
            this.setDefaultTrans(defaultTargetStateID);
        } else {
            this.removeStateTrans("__*__");
        }
        if (isFinalState) {
            this._state.put("__IS_FINAL_STATE__", Boolean.TRUE);
        } else {
            this._state.remove("__IS_FINAL_STATE__");
        }
    }

    public void setDefaultTrans(Object targetStateID) {
        this.addStateTrans("__*__", targetStateID);
    }

    public void addStateTrans(Object trans, Object targetStateID) {
        if (this._curStep == null) {
            throw new IllegalStateException();
        }
        if (!this._curStep.isExpectedTransitionSet()) {
            this._curStep.setExpectedTransition(trans);
        }
        this._trans.put(trans, targetStateID);
    }

    public FSM getFSM() throws FSMInvalidException {
        return new FSM(this._fsm);
    }

    private void removeStateTrans(Object transition) {
        this._trans.remove(transition);
    }
}

