/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import javax.swing.JComponent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.ApplyNotifier;
import oracle.ide.panels.ExceptionPanel;
import oracle.ide.panels.MetaCtor;
import oracle.ide.panels.Traversable;
import oracle.javatools.util.Copyable;

public class MetaTraversable
implements Copyable {
    private MetaCtor _metaCtor;
    private Object[] _ctorArgs;
    private Constructor _travCtor;
    private String _helpID;
    private HashMap _nameLinks;

    public MetaTraversable(Class traversableClass) {
        this(traversableClass, null, null);
    }

    public MetaTraversable(Class traversableClass, Class[] constructorArgTypes, Object[] constructorArgs) {
        this(null, traversableClass, constructorArgTypes, constructorArgs);
    }

    protected MetaTraversable() {
    }

    protected MetaTraversable(String traversableClassStr) {
        this(traversableClassStr, null, null, null);
    }

    private MetaTraversable(String travClassStr, Class travClass, Class[] ctorArgTypes, Object[] ctorArgs) {
        if (travClassStr != null) {
            this._metaCtor = new MetaCtor(travClassStr, ctorArgTypes);
        } else if (travClass != null) {
            this._metaCtor = new MetaCtor(travClass, ctorArgTypes);
        } else {
            return;
        }
        this._ctorArgs = ctorArgs;
    }

    public Object copyTo(Object target) {
        MetaTraversable copy = target != null ? (MetaTraversable)target : new MetaTraversable();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(MetaTraversable copy) {
        copy._metaCtor = this._metaCtor != null ? (MetaCtor)this._metaCtor.copyTo(null) : null;
        copy._ctorArgs = this._ctorArgs;
        copy._travCtor = this._travCtor;
        copy._helpID = this._helpID;
        copy._nameLinks = this._nameLinks != null ? new HashMap(this._nameLinks) : null;
    }

    public boolean isUsingTraversableDefaultConstructor() {
        if (this._metaCtor == null && this._travCtor == null) {
            return false;
        }
        return this._ctorArgs == null || this._ctorArgs.length == 0;
    }

    public Class getTraversableClass() {
        if (this._metaCtor != null) {
            return this._metaCtor.getDeclaringClass();
        }
        if (this._travCtor != null) {
            return this._travCtor.getDeclaringClass();
        }
        return null;
    }

    public Traversable newTraversable(ApplyNotifier applyNotifier) {
        Traversable newTraversable = null;
        try {
            newTraversable = this.newTraversable();
            if (applyNotifier != null && newTraversable instanceof ApplyListener) {
                applyNotifier.addApplyListener((ApplyListener)((Object)newTraversable));
            }
        }
        catch (Exception e) {
            return new ExceptionPanel(e);
        }
        return newTraversable;
    }

    public void setHelpID(String helpID) {
        this._helpID = helpID;
    }

    public void setNameLink(String name, String alias) {
        if (this._nameLinks == null) {
            this._nameLinks = new HashMap();
        }
        this._nameLinks.put(name, alias);
    }

    protected Traversable newTraversable() {
        try {
            this.maybeInitTravCtor();
            return (Traversable)this._travCtor.newInstance(this._ctorArgs);
        }
        catch (Exception e) {
            return new ExceptionPanel(e);
        }
    }

    String getNameLink(String name) {
        if (this._nameLinks == null || !this._nameLinks.containsKey(name)) {
            return name;
        }
        Object link = this._nameLinks.get(name);
        return link != null ? link.toString() : null;
    }

    public static final String findHelpID(MetaTraversable metaTrav, Traversable trav) {
        String helpID;
        String string = helpID = metaTrav != null ? metaTrav.getHelpID() : null;
        if (helpID == null) {
            helpID = MetaTraversable.findHelpID(trav);
        }
        return helpID;
    }

    static final String findHelpID(Traversable trav) {
        String helpID = null;
        if (trav != null) {
            try {
                helpID = trav.getHelpID();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            if (helpID == null) {
                for (Component comp = trav.getComponent(); comp != null; comp = comp.getParent()) {
                    Object helpIDObj;
                    if (!(comp instanceof JComponent) || !((helpIDObj = ((JComponent)comp).getClientProperty("HelpID")) instanceof String)) continue;
                    helpID = (String)helpIDObj;
                    break;
                }
            }
        }
        return helpID;
    }

    private String getHelpID() {
        return this._helpID;
    }

    private void maybeInitTravCtor() {
        if (this._travCtor == null && this._metaCtor != null) {
            try {
                this._travCtor = this._metaCtor.getConstructor();
            }
            catch (Exception e) {
                this.handleInitException(e);
            }
            this._metaCtor = null;
        }
    }

    private void handleInitException(Exception e) {
        try {
            this._travCtor = ExceptionPanel.class.getConstructor(Exception.class);
            this._ctorArgs = new Object[]{e};
        }
        catch (Exception e2) {
            e.printStackTrace();
            this._travCtor = null;
            this._ctorArgs = null;
        }
    }
}

