/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.util.ArrayList;
import java.util.List;
import oracle.bali.inspector.PropertyModel;

final class PropertyIds {
    private final List<Object> propertyIds = new ArrayList<Object>();
    private final List<Boolean> hiddenStatus = new ArrayList<Boolean>();
    private final List<Boolean> writableStatus = new ArrayList<Boolean>();
    private boolean updated;

    PropertyIds() {
    }

    void update(PropertyModel propertyModel) {
        if (propertyModel == null) {
            throw new IllegalArgumentException("Property model should not be null");
        }
        this.updated = true;
        this.propertyIds.clear();
        this.hiddenStatus.clear();
        this.writableStatus.clear();
        this.populatePropertyIds(propertyModel);
    }

    boolean isMatching(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return false;
        }
        if (!this.updated) {
            return false;
        }
        int propertyCount = this.propertyIds.size();
        if (propertyCount != propertyModel.getRowCount()) {
            return false;
        }
        for (int row = 0; row < propertyCount; ++row) {
            Object propertyId = this.propertyIds.get(row);
            if (!propertyModel.isMatchingPropertyID(propertyId, row)) {
                return false;
            }
            if (!this.hiddenMatch(row, this.hidden(propertyModel, row))) {
                return false;
            }
            if (this.writableMatch(row, this.writable(propertyModel, row))) continue;
            return false;
        }
        return true;
    }

    private boolean hiddenMatch(int row, boolean newHiddenValue) {
        Boolean currentHiddenValue = this.hiddenStatus.get(row);
        if (currentHiddenValue == null) {
            return false;
        }
        return newHiddenValue == currentHiddenValue;
    }

    private boolean writableMatch(int row, boolean newWritableValue) {
        Boolean currentWritableValue = this.writableStatus.get(row);
        if (currentWritableValue == null) {
            return false;
        }
        return newWritableValue == currentWritableValue;
    }

    private boolean hidden(PropertyModel propertyModel, int row) {
        return propertyModel.getBooleanData(PropertyModel.COLUMN_IS_HIDDEN, row);
    }

    private boolean writable(PropertyModel propertyModel, int row) {
        return propertyModel.isPropertyWritable(row);
    }

    private void populatePropertyIds(PropertyModel propertyModel) {
        int count = propertyModel.getRowCount();
        for (int row = 0; row < count; ++row) {
            this.propertyIds.add(propertyModel.getPropertyID(row));
            this.hiddenStatus.add(this.hidden(propertyModel, row));
            this.writableStatus.add(this.writable(propertyModel, row));
        }
    }
}

