/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import oracle.bali.inspector.PropertyModel;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.Helpable;
import oracle.ide.inspector.IdePropertyModel;

public final class PropertyHelp {
    public HelpInfo getHelpFrom(PropertyModel model) {
        HelpInfo info;
        if (model == null) {
            return null;
        }
        if (model instanceof Helpable && (info = ((Helpable)model).getHelpInfo()) != null) {
            return info;
        }
        String topic = model.getHelpTopic();
        if (topic != null) {
            return new HelpInfo(topic);
        }
        int rowCount = model.getRowCount();
        if (rowCount == 0) {
            return null;
        }
        for (int i = 0; i < rowCount; ++i) {
            HelpInfo help = this.help(i, model);
            if (help == null) continue;
            return help;
        }
        return null;
    }

    private HelpInfo help(int row, PropertyModel model) {
        int column = model.getColumnIndex(IdePropertyModel.COLUMN_HELP);
        if (column == -1) {
            return null;
        }
        Object value = model.getValueAt(row, column);
        if (value instanceof HelpInfo) {
            return (HelpInfo)value;
        }
        if (value instanceof Helpable) {
            return ((Helpable)value).getHelpInfo();
        }
        if (value instanceof String) {
            return new HelpInfo((String)value);
        }
        return null;
    }
}

