/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.util.MetaClass;
import oracle.ide.view.View;

public final class InspectableViewRegistry {
    private final List<MetaClass> supporters = new CopyOnWriteArrayList<MetaClass>();
    private final List<MetaClass> detractors = new CopyOnWriteArrayList<MetaClass>();
    private static String NULL_ERROR_MESSAGE = "The supporter view to register should not be null";

    private static void nullCheck(Object param) {
        if (param == null) {
            throw new IllegalArgumentException(NULL_ERROR_MESSAGE);
        }
    }

    public void registerSupporter(MetaClass metaClazz) {
        InspectableViewRegistry.nullCheck(metaClazz);
        this.supporters.add(metaClazz);
    }

    public void registerSupporter(Class<? extends View> viewType) {
        InspectableViewRegistry.nullCheck(viewType);
        this.registerSupporter(new MetaClass(Thread.currentThread().getContextClassLoader(), viewType.getName()));
    }

    public void registerSupporter(String classFQN) {
        InspectableViewRegistry.nullCheck(classFQN);
        MetaClass metaClass = new MetaClass(Thread.currentThread().getContextClassLoader(), classFQN);
        if (!this.supporters.contains(metaClass)) {
            this.supporters.add(metaClass);
        }
    }

    public Iterable<MetaClass> supporters() {
        return new Iterable<MetaClass>(){

            @Override
            public Iterator<MetaClass> iterator() {
                return InspectableViewRegistry.this.supporters.iterator();
            }
        };
    }

    public void registerDetractor(MetaClass metaClazz) {
        InspectableViewRegistry.nullCheck(metaClazz);
        this.detractors.add(metaClazz);
    }

    public void registerDetractor(View view) {
        InspectableViewRegistry.nullCheck(view);
        this.registerDetractor(view.getClass());
    }

    public void registerDetractor(Class<? extends View> viewType) {
        InspectableViewRegistry.nullCheck(viewType);
        this.registerDetractor(new MetaClass(viewType.getClassLoader(), viewType.getName()));
    }

    public void registerDetractor(String classFQN) {
        InspectableViewRegistry.nullCheck(classFQN);
        MetaClass metaClass = new MetaClass(Thread.currentThread().getContextClassLoader(), classFQN);
        if (!this.detractors.contains(metaClass)) {
            this.detractors.add(metaClass);
        }
    }

    public Iterable<MetaClass> detractors() {
        return new Iterable<MetaClass>(){

            @Override
            public Iterator<MetaClass> iterator() {
                return InspectableViewRegistry.this.detractors.iterator();
            }
        };
    }

    public static InspectableViewRegistry instance() {
        return SingletonHolder.instance;
    }

    private InspectableViewRegistry() {
    }

    private static class SingletonHolder {
        static InspectableViewRegistry instance = new InspectableViewRegistry();

        private SingletonHolder() {
        }
    }
}

