/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.OracleConnection;

public class Shutdown
extends CommandListener {
    private static final String IMMEDIATE = Messages.getString("Shutdown.0");
    private static final String ABORT = "abort";
    private static final String TRANSACTIONAL = "transactional";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        boolean nonPlugSuccess = false;
        boolean pluggableAltered = false;
        try {
            String errorString;
            boolean tryNonPluggable;
            block52: {
                boolean wasAlterDatabase = false;
                tryNonPluggable = true;
                errorString = null;
                if (conn instanceof OracleConnection) {
                    OracleConnection ocon = (OracleConnection)conn;
                    boolean sysdba = false;
                    if (ocon != null) {
                        boolean amILocked = DBUtil.getConnectionResolver().lock((Connection)ocon);
                        try {
                            if (!amILocked) break block52;
                            Object querySql = null;
                            DBUtil dbUtil = DBUtil.getInstance((Connection)ocon);
                            String s = ocon.getProperties().getProperty("internal_logon");
                            if (s != null && s.toLowerCase().equals("sysdba")) {
                                sysdba = true;
                            } else {
                                errorString = Messages.getString("Shutdown.NOTSYSDBA");
                                tryNonPluggable = false;
                            }
                            if (!sysdba || DBUtil.getDbVersion((Connection)ocon).compareTo(new Version("12.1")) < 0) break block52;
                            boolean immediate = false;
                            if (dbUtil.executeOracleReturnOneCol("select NVL(SYS_CONTEXT('USERENV','CDB_NAME'),'1') from dual", null).equals("1")) {
                                errorString = Messages.getString("Shutdown.NOTCONSOLIDATED");
                                break block52;
                            }
                            if (dbUtil.executeOracleReturnOneCol("select to_char(SYS_CONTEXT('USERENV','CON_ID')) from dual", null).equals("1")) {
                                errorString = Messages.getString("Shutdown.CONID1");
                                break block52;
                            }
                            String con_name = dbUtil.executeOracleReturnOneCol("select to_char(SYS_CONTEXT ('USERENV', 'CON_NAME')) CON_NAME from dual", null);
                            Statement st = null;
                            try {
                                tryNonPluggable = false;
                                String invalid = null;
                                String[] commandParts = cmd.getSQLOrig().split("\\s+");
                                if (commandParts.length == 2) {
                                    if (commandParts[1].toLowerCase().equals(IMMEDIATE)) {
                                        immediate = true;
                                    } else if (commandParts[1].toLowerCase().equals(ABORT)) {
                                        invalid = ABORT + Messages.getString("Shutdown.NOTAVAILABLE");
                                    } else if (commandParts[1].toLowerCase().equals(TRANSACTIONAL)) {
                                        invalid = TRANSACTIONAL + Messages.getString("Shutdown.NOTAVAILABLE");
                                    }
                                } else if (commandParts.length > 2) {
                                    invalid = Messages.getString("Shutdown.WRONGNUMBEROFARGS");
                                }
                                if (invalid == null) {
                                    st = ocon.createStatement();
                                    if (immediate) {
                                        st.execute("alter pluggable database \"" + con_name + "\" close immediate");
                                    } else {
                                        st.execute("alter pluggable database \"" + con_name + "\" close");
                                    }
                                    pluggableAltered = true;
                                    ctx.write(Messages.getString("Shutdown.PLUGGABLE"));
                                } else {
                                    ctx.write(invalid + "\n");
                                }
                                wasAlterDatabase = true;
                            }
                            finally {
                                try {
                                    if (st != null) {
                                        st.close();
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        finally {
                            if (amILocked) {
                                DBUtil.getConnectionResolver().unlock((Connection)ocon);
                            }
                        }
                    }
                }
            }
            if (tryNonPluggable) {
                if (conn instanceof OracleConnection) {
                    Boolean isPrelim = (Boolean)ctx.getProperty("script.runner.PRELIM_AUTH");
                    OracleConnection ocon = (OracleConnection)conn;
                    String s = ocon.getProperties().getProperty("internal_logon");
                    if (isPrelim == null || isPrelim.equals(Boolean.FALSE)) {
                        if (s != null && s.toLowerCase().equals("sysdba")) {
                            String[] commandParts = cmd.getSQLOrig().split("\\s+");
                            if (commandParts.length == 1) {
                                ocon.shutdown(OracleConnection.DatabaseShutdownMode.TRANSACTIONAL);
                                nonPlugSuccess = this.cleanShutdown(ctx, ocon);
                            } else if (commandParts.length == 2) {
                                if (commandParts[1].toLowerCase().equals(IMMEDIATE)) {
                                    ocon.shutdown(OracleConnection.DatabaseShutdownMode.IMMEDIATE);
                                    nonPlugSuccess = this.cleanShutdown(ctx, ocon);
                                } else if (commandParts[1].toLowerCase().equals(ABORT)) {
                                    ocon.shutdown(OracleConnection.DatabaseShutdownMode.ABORT);
                                    ctx.write(Messages.getString("Shutdown.DATABASEABORTED"));
                                    nonPlugSuccess = this.switchConnection(ctx, ocon);
                                } else if (commandParts[1].toLowerCase().equals(TRANSACTIONAL)) {
                                    ocon.shutdown(OracleConnection.DatabaseShutdownMode.TRANSACTIONAL);
                                    nonPlugSuccess = this.cleanShutdown(ctx, ocon);
                                }
                            } else {
                                ctx.write(Messages.getString("Shutdown.INVALIDOPTS"));
                            }
                        } else {
                            ctx.write(Messages.getString("Shutdown.INSUFFPRIV"));
                        }
                    } else {
                        ctx.write(Messages.getString("Shutdown.IDLE_CONNECTION"));
                    }
                } else {
                    ctx.write(Messages.getString("Shutdown.NOTSUPPORTEDONCON"));
                }
            } else if (errorString != null) {
                ctx.write(errorString + "\n");
            }
        }
        catch (SQLException e) {
            ctx.write(e.getLocalizedMessage() + "\n");
        }
        if (nonPlugSuccess || pluggableAltered) {
            ctx.write(Messages.getString("Shutdown.SUCCESS"));
        } else {
            ctx.write(Messages.getString("Shutdown.FAILED"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean switchConnection(ScriptRunnerContext ctx, OracleConnection ocon) throws SQLException {
        block15: {
            boolean isLocked = DBUtil.getConnectionResolver().lock((Connection)ocon);
            try {
                String password;
                if (!isLocked) break block15;
                boolean switchBase = false;
                if (ocon.equals(ctx.getBaseConnection())) {
                    switchBase = true;
                }
                try {
                    if (!ocon.isClosed()) {
                        ocon.close();
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).info(e.getLocalizedMessage());
                }
                Properties props = (Properties)ctx.getProperty("cli.conn.props");
                Properties duplicateProperties = new Properties();
                String userName = props.getProperty("user");
                if (userName != null) {
                    duplicateProperties.setProperty("user", userName);
                }
                if ((password = props.getProperty("password")) != null) {
                    duplicateProperties.setProperty("password", password);
                }
                duplicateProperties.setProperty("prelim_auth", "true");
                duplicateProperties.setProperty("internal_logon", "SYSDBA");
                OracleConnection conn = (OracleConnection)DriverManager.getConnection((String)ctx.getProperty("cli.conn.url"), duplicateProperties);
                ctx.putProperty("script.runner.PRELIM_AUTH", Boolean.TRUE);
                Boolean getCommit = (Boolean)ctx.getProperty("script.runner.autocommit.checkbox");
                try {
                    if (getCommit == null || getCommit.equals(Boolean.FALSE)) {
                        conn.setAutoCommit(false);
                    } else {
                        conn.setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
                if (switchBase) {
                    ctx.setBaseConnection((Connection)conn);
                }
                ctx.setCurrentConnection((Connection)conn);
                boolean bl = true;
                return bl;
            }
            finally {
                if (isLocked) {
                    DBUtil.getConnectionResolver().unlock((Connection)ocon);
                }
            }
        }
        return false;
    }

    private boolean cleanShutdown(ScriptRunnerContext ctx, OracleConnection ocon) throws SQLException {
        ctx.write(Messages.getString("Shutdown.11"));
        Statement stmt = ocon.createStatement();
        stmt.execute("alter database close normal");
        ctx.write(Messages.getString("Shutdown.13"));
        stmt.execute("alter database dismount");
        ctx.write(Messages.getString("Shutdown.15"));
        ocon.shutdown(OracleConnection.DatabaseShutdownMode.FINAL);
        ctx.write(Messages.getString("Shutdown.16"));
        return this.switchConnection(ctx, ocon);
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

