/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jline.console.CursorBuffer;
import oracle.dbtools.plusplus.FileSystem;
import oracle.dbtools.plusplus.IBuffer;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.IndexBuilder;

public class Buffer
implements IBuffer {
    private static final String SLASH = "/";
    private ArrayList<String> buffer = new ArrayList();
    private int currentLine = -1;
    private boolean editing = false;
    private IBuffer bufferSafe;
    private CursorBuffer _readLineBuffer;
    private int termLine;

    public static void main(String[] args) {
        Buffer.testBufferList();
        Buffer.testBufferEdit();
        Buffer.testBufferFile();
    }

    private static void testBufferFile() {
        Buffer abuffer = new Buffer();
        abuffer.add("This is first String");
        abuffer.add("This is second String");
        abuffer.add("This is third String");
        abuffer.addAtIndex(2, "This is four string");
        abuffer.setCurrentLine(2);
        System.out.println(abuffer.list());
        System.out.println("Saving buffer");
        abuffer.save("/tmp/test.sql", FileSystem.State.REPLACE, "sql");
        System.out.println("buffer saved");
        System.out.println("Try empty buffer");
        abuffer.clear();
        System.out.println("printing buffer");
        System.out.println(abuffer.list());
        System.out.println("finish printing buffer");
        System.out.println("GEt test.sql");
        abuffer.get("/tmp/test.sql", true);
        System.out.println("buffer loaded");
        System.out.println("printing buffer");
        System.out.println(abuffer.list());
        System.out.println("finish printing buffer");
        System.out.println("getBufferString");
        System.out.println(abuffer.getBuffer());
    }

    private static void testBufferEdit() {
        Buffer abuffer = new Buffer();
        abuffer.add("This is first String");
        abuffer.add("This is second String");
        abuffer.add("This is third String");
        abuffer.addAtIndex(2, "This is four string");
        abuffer.setCurrentLine(2);
        System.out.println(abuffer.list());
        abuffer.append("Appending this");
        System.out.println("");
        System.out.println(abuffer.list());
        System.out.println("Try deleting 'Appending this' again");
        abuffer.change("Appending this");
        System.out.println(abuffer.list());
        System.out.println("Try changing second to 2 ");
        abuffer.change("second", "2");
        System.out.println(abuffer.list());
        System.out.println("Try insert newline");
        abuffer.input("select * from dual");
        System.out.println(abuffer.list());
        abuffer.change("from", "select abc");
        System.out.println(abuffer.list());
        System.out.println("Try empty buffer");
        abuffer.clear();
        System.out.println("printing buffer");
        System.out.println(abuffer.list());
        System.out.println("finish printing buffer");
    }

    private static void testBufferList() {
        Buffer buffer = new Buffer();
        buffer.add("This is first String");
        buffer.add("This is second String");
        buffer.add("This is third String");
        System.out.println(buffer.list());
        System.out.println("buffer.getBuffer():");
        System.out.println(">>>" + buffer.getBuffer() + "<<<");
        System.out.println("");
        buffer.addAtIndex(2, "This is four string");
        buffer.setCurrentLine(2);
        System.out.println(buffer.list());
        System.out.println("list last");
        System.out.println(buffer.listLast());
        System.out.println("list 1 3");
        System.out.println(buffer.list(1, 3));
        System.out.println("list * 4");
        System.out.println(buffer.deleteStarN(4));
        System.out.println("list 2 *");
        System.out.println(buffer.deleteNStar(2));
        System.out.println("list *");
        System.out.println(buffer.listStar());
        System.out.println("list 4");
        System.out.println(buffer.list(4));
    }

    @Override
    public void add(String string) {
        this.buffer.add(string);
        this.currentLine = this.buffer.size();
    }

    @Override
    public void addAtIndex(int index, String string) {
        if (this.buffer.size() == 0) {
            this.buffer.add(string);
            return;
        }
        int newIndex = index;
        if (index < 0) {
            newIndex = 0;
        }
        if (index > this.buffer.size()) {
            this.buffer.add(string);
        } else {
            this.buffer.add(newIndex, string);
        }
    }

    @Override
    public int getCurrentLine() {
        return this.currentLine;
    }

    @Override
    public String list() {
        this.setCurrentLine(this.buffer.size());
        Iterator<String> bufferIterator = this.buffer.iterator();
        int lineNumber = 1;
        if (bufferIterator.hasNext()) {
            StringBuilder sb = new StringBuilder();
            while (bufferIterator.hasNext()) {
                sb.append(IndexBuilder.getIndex(lineNumber, this.getCurrentLine()) + bufferIterator.next() + "\n");
                ++lineNumber;
            }
            return sb.toString();
        }
        return "SP2-0223: No lines in SQL Buffer\n";
    }

    @Override
    public String list(int n) {
        this.currentLine = n;
        if (n > 0 && n <= this.buffer.size()) {
            return IndexBuilder.getIndex(n, this.getCurrentLine()) + this.buffer.get(n - 1) + "\n";
        }
        return "SP2-0226: invalid line number\n";
    }

    @Override
    public String listStar() {
        if (this.buffer.size() > 0) {
            return IndexBuilder.getIndex(this.getCurrentLine(), this.getCurrentLine()) + this.buffer.get(this.currentLine - 1) + "\n";
        }
        return "";
    }

    @Override
    public String listLast() {
        if (this.buffer.size() > 0) {
            this.setCurrentLine(this.buffer.size());
            return IndexBuilder.getIndex(this.buffer.size(), this.getCurrentLine()) + this.buffer.get(this.buffer.size() - 1) + "\n";
        }
        return "";
    }

    @Override
    public String list(int m, int n) {
        if (m <= n && n <= this.buffer.size() && m > 0) {
            this.setCurrentLine(n);
            Iterator<String> bufferIterator = this.buffer.iterator();
            int lineNumber = 1;
            StringBuilder sb = new StringBuilder();
            while (bufferIterator.hasNext()) {
                if (lineNumber >= m && lineNumber <= n) {
                    sb.append(IndexBuilder.getIndex(lineNumber, this.getCurrentLine()) + bufferIterator.next() + "\n");
                } else {
                    bufferIterator.next();
                }
                ++lineNumber;
            }
            return sb.toString();
        }
        return "SP2-0226: Invalid line number\n";
    }

    @Override
    public String delete() {
        if (this.buffer.size() >= 1) {
            this.buffer.remove(this.currentLine - 1);
        }
        return "";
    }

    @Override
    public String delete(int lineNumber) {
        if (lineNumber > 0 && lineNumber <= this.buffer.size()) {
            this.buffer.remove(lineNumber - 1);
            return "";
        }
        return "SP2-0226: Invalid line number\n";
    }

    @Override
    public String deleteStar() {
        return this.delete();
    }

    @Override
    public String deleteNStar(int n) {
        if (this.getCurrentLine() >= n) {
            return this.delete(n, this.getCurrentLine());
        }
        return "SP2-0226: Invalid line number range\n";
    }

    @Override
    public String deleteLast() {
        if (this.buffer.size() > 0) {
            this.buffer.remove(this.buffer.size() - 1);
        }
        return "SP2-0026: No lines to delete";
    }

    @Override
    public String delete(int m, int n) {
        if (this.buffer.size() > 0) {
            if (m < n && n <= this.buffer.size() && m > 0) {
                int num2Delete = n - m;
                for (int i = 0; i < num2Delete; ++i) {
                    this.buffer.remove(m);
                }
                return "";
            }
            if (m > n) {
                return "SP2-0622: Starting line number must be less than ending line number\n";
            }
            return "SP2-0226: Invalid line number range\n";
        }
        return "SP2-0026: No lines to delete\n";
    }

    @Override
    public String deleteStarN(int n) {
        if (this.getCurrentLine() <= n) {
            return this.delete(this.getCurrentLine(), n);
        }
        return null;
    }

    @Override
    public void clear() {
        this.buffer.clear();
        this.currentLine = -1;
    }

    @Override
    public void append(String string) {
        if (this.getCurrentLine() < 0) {
            this.buffer.add(string);
            this.setCurrentLine(1);
        } else {
            String newline = this.buffer.get(this.currentLine - 1);
            newline = newline + string;
            this.buffer.set(this.currentLine - 1, newline);
        }
    }

    @Override
    public String change(String oldString, String newString) {
        if (this.currentLine < 1) {
            this.currentLine = 1;
        }
        if (this.buffer.size() > 0) {
            String newline = this.buffer.get(this.currentLine - 1);
            if (!newline.contains(oldString)) {
                return "SP2-0023: String not found\n";
            }
            String regex = oldString.replaceAll("\\+", "\\\\+").replaceAll("\\?", "\\\\?").replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\\\*");
            newline = newline.replaceFirst(regex, newString);
            this.buffer.set(this.currentLine - 1, newline);
            return "";
        }
        return "SP2-0024: Nothing to change.\n";
    }

    @Override
    public String change(String string) {
        if (this.currentLine < 1) {
            this.currentLine = 1;
        }
        if (this.buffer.size() > 0) {
            String newline = this.buffer.get(this.currentLine - 1);
            if (!newline.contains(string)) {
                return "SP2-0023: String not found\n";
            }
            String regex = string.replaceAll("\\+", "\\\\+").replaceAll("\\?", "\\\\?").replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\\\*");
            newline = newline.replaceFirst(regex, "");
            this.buffer.set(this.currentLine - 1, newline);
            return "";
        }
        return "SP2-0024: Nothing to change.\n";
    }

    @Override
    public String input(String string) {
        if (this.currentLine < 0) {
            this.currentLine = 0;
        }
        this.buffer.add(this.currentLine, string);
        this.setCurrentLine(this.currentLine + 1);
        return "";
    }

    @Override
    public FileSystem.Results get(String filename, boolean list, String suffix) {
        if (filename.lastIndexOf(".") == -1) {
            FileSystem.Results results = this.get(filename, list);
            if (!results.equals((Object)FileSystem.Results.OK)) {
                String newFileNameWithSuffix = filename + "." + suffix;
                return this.get(newFileNameWithSuffix, list);
            }
            return results;
        }
        return this.get(filename, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem.Results get(String filename, boolean list) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(filename));
            FileSystem.Results results = this.get(reader, list);
            return results;
        }
        catch (FileNotFoundException e) {
            FileSystem.Results results = FileSystem.Results.FILE_NOT_FOUND;
            return results;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem.Results get(File file, boolean list) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            FileSystem.Results results = this.get(reader, list);
            return results;
        }
        catch (FileNotFoundException e) {
            FileSystem.Results results = FileSystem.Results.FILE_NOT_FOUND;
            return results;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private FileSystem.Results get(BufferedReader reader, boolean list) {
        try {
            String text = null;
            this.buffer.clear();
            while ((text = reader.readLine()) != null) {
                this.buffer.add(text);
            }
            if (this.buffer.size() > 0) {
                this.setCurrentLine(this.buffer.size());
                if (this.buffer.get(this.getCurrentLine() - 1).trim().equals(SLASH)) {
                    this.delete(this.getCurrentLine());
                }
            }
            this.setBufferSafe(this.buffer);
            return FileSystem.Results.OK;
        }
        catch (IOException e) {
            return FileSystem.Results.FILE_NOT_ACCESSIBLE;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String save(String filename, FileSystem.State state, String suffix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getBuffer() {
        Iterator<String> bufferIterator = this.buffer.iterator();
        StringBuilder sb = new StringBuilder();
        while (bufferIterator.hasNext()) {
            sb.append(bufferIterator.next() + "\n");
        }
        return sb.toString();
    }

    @Override
    public String setCurrentLine(int lineNumber) {
        if (lineNumber > 0 && lineNumber <= this.buffer.size()) {
            this.currentLine = lineNumber;
        }
        return this.list(lineNumber);
    }

    @Override
    public String replace(int lineNumber, String string) {
        if (this.buffer.size() == 0) {
            this.buffer.add(string);
        }
        if (lineNumber < 1) {
            this.buffer.set(0, string);
        } else {
            this.buffer.set(lineNumber - 1, string);
        }
        return this.list(lineNumber);
    }

    @Override
    public int linesInBuffer() {
        return this.buffer.size();
    }

    @Override
    public String getPrompt() {
        String prompt = IndexBuilder.getIndex(this.linesInBuffer() + 1, -1);
        return prompt;
    }

    @Override
    public String getPrompt(int line) {
        String prompt = IndexBuilder.getIndex(line, -1);
        return prompt;
    }

    @Override
    public boolean isEditing() {
        return this.editing;
    }

    @Override
    public void startEditing(boolean clear) {
        if (!this.editing && clear) {
            this.clear();
        }
        this.editing = true;
    }

    @Override
    public void startEditingAfterHistory() {
        this.editing = true;
    }

    @Override
    public void stopEditing() {
        this.editing = false;
    }

    @Override
    public String listNStar(int n) {
        if (this.getCurrentLine() >= n) {
            return this.list(n, this.getCurrentLine());
        }
        return "SP2-0226: Invalid line number range\n";
    }

    @Override
    public String listStarN(int n) {
        if (this.getCurrentLine() <= n) {
            return this.list(this.getCurrentLine(), n);
        }
        return "";
    }

    @Override
    public void resetBuffer(String bufferString) {
        String[] lines = bufferString.split("\n");
        this.resetBuffer(Arrays.asList(lines));
    }

    @Override
    public void resetBuffer(List<String> historyItem) {
        this.buffer.clear();
        this.buffer.addAll(historyItem);
        this.setCurrentLine(this.buffer.size());
    }

    @Override
    public String getLine(int n) {
        if (n - 1 >= 0 && this.buffer.get(n - 1) != null) {
            return this.buffer.get(n - 1);
        }
        return "";
    }

    @Override
    public boolean previous() {
        if (this.getCurrentLine() <= 1) {
            return false;
        }
        this.setCurrentLine(this.getCurrentLine() - 1);
        return true;
    }

    @Override
    public boolean next() {
        if (this.getCurrentLine() >= this.buffer.size()) {
            return false;
        }
        this.setCurrentLine(this.getCurrentLine() + 1);
        return true;
    }

    @Override
    public int size() {
        return this.buffer.size();
    }

    @Override
    public ArrayList<String> getBufferList() {
        return this.buffer;
    }

    @Override
    public boolean isEmpty() {
        return this.buffer.size() <= 0;
    }

    @Override
    public void setBufferSafe(ArrayList<String> bufferList) {
        if (bufferList.size() > 0 && bufferList.get(bufferList.size() - 1).trim().equals(SLASH)) {
            bufferList.remove(bufferList.size() - 1);
        }
        this.getBufferSafe().resetBuffer(bufferList);
    }

    @Override
    public IBuffer getBufferSafe() {
        if (this.bufferSafe == null) {
            this.bufferSafe = new Buffer();
        }
        return this.bufferSafe;
    }

    @Override
    @Deprecated
    public String getCurrentBufferState(String line) {
        this.replace(this.getCurrentLine(), line);
        return this.getBuffer().replace("\n", " ").replace("\r", " ");
    }

    @Override
    @Deprecated
    public int getCursorLocation(int cursor) {
        int count = 0;
        for (int i = 0; i < this.getCurrentLine() - 1; ++i) {
            count += this.buffer.get(i).length();
        }
        count += cursor;
        return 0;
    }

    @Override
    public int getCursor() {
        return this._readLineBuffer.cursor;
    }

    @Override
    public String getCursorContents() {
        return this._readLineBuffer.buffer.toString();
    }

    @Override
    public void setReadLineBuffer(Object _readLineBuffer) {
        this._readLineBuffer = (CursorBuffer)_readLineBuffer;
    }

    @Override
    public String getBufferString() {
        Iterator<String> bufferIterator = this.buffer.iterator();
        StringBuilder sb = new StringBuilder();
        while (bufferIterator.hasNext()) {
            sb.append(bufferIterator.next());
            if (!bufferIterator.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public int getBufferCursor(int currentLine, int cursor) {
        int bufPos = 0;
        int line = 0;
        Iterator<String> bufferIterator = this.buffer.iterator();
        while (bufferIterator.hasNext()) {
            if (++line != this.getCurrentLine()) {
                bufPos += bufferIterator.next().length();
                continue;
            }
            return (bufPos += cursor) + currentLine - 1;
        }
        return 0;
    }

    @Override
    public void setTermLine(int line, int termHeight) {
        this.termLine = line <= 1 ? 1 : line;
        if (this.termLine > termHeight) {
            this.termLine = termHeight;
        }
        if (termHeight - this.termLine > this.buffer.size() - this.currentLine) {
            this.termLine = termHeight;
        }
    }

    @Override
    public int getTermLine() {
        return this.termLine;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$oracle$dbtools$plusplus$FileSystem$State;

        static {
            $SwitchMap$oracle$dbtools$plusplus$FileSystem$State = new int[FileSystem.State.values().length];
            try {
                1.$SwitchMap$oracle$dbtools$plusplus$FileSystem$State[FileSystem.State.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$oracle$dbtools$plusplus$FileSystem$State[FileSystem.State.CREATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$oracle$dbtools$plusplus$FileSystem$State[FileSystem.State.APPEND.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$oracle$dbtools$plusplus$FileSystem$State[FileSystem.State.REPLACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

