/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proformatter;

import SQLinForm_200.SQLForm;
import java.net.URL;
import oracle.dbtools.raptor.proformatter.CodingStyleSQLOptionsBean;
import oracle.dbtools.raptor.proformatter.FormatHelper;
import oracle.dbtools.raptor.proformatter.ICodingStyleSQLOptions;
import oracle.dbtools.raptor.proformatter.ICoreFormatter;
import oracle.dbtools.raptor.proformatter.Messages;

public class SQLPlusFormatter
implements ICoreFormatter {
    @Override
    public String format(ICodingStyleSQLOptions co, String start) {
        int equalSpace;
        int commaSpace;
        if (co == null) {
            URL u = this.getClass().getClassLoader().getResource("oracle/dbtools/raptor/proformatter/default_sql_profiles.xml");
            co = FormatHelper.loadFromXML(new CodingStyleSQLOptionsBean(), u);
        }
        if (co == null) {
            return null;
        }
        SQLForm niceSQL = new SQLForm();
        niceSQL.setCase(co.getUppercase() == 0, co.getUppercase() == 2);
        niceSQL.setLowerCase(co.getUppercase() == 3);
        niceSQL.setGraphLevel(false);
        niceSQL.setSuppressSpace(true);
        String myQuoteChar = "'";
        if (co.getQuoteChar() == 1) {
            myQuoteChar = "\"";
        }
        niceSQL.setQuoteCharacter(myQuoteChar);
        niceSQL.setdoubleIndentionMasterKeyword(co.getDblIndent());
        niceSQL.setAndOrIndention(co.getIndentAnd());
        int numSpaces = co.getNumSpaces();
        int numCommas = co.getNumCommas();
        niceSQL.setIndention(numSpaces, co.getUseTab());
        niceSQL.setNumCommas(numCommas);
        niceSQL.setLinebreakBeforeLineComment(co.getBreakBeforeComment());
        niceSQL.setLinebreakBeforeConcat(co.getBreakBeforeConcat());
        niceSQL.setLinebreakAfterConcat(co.getBreakAfterConcat());
        niceSQL.setLineBreak(co.getBreakBeforeComma(), co.getBreakAfterComma(), co.getBreakBeforeAnd(), co.getBreakAfterAnd(), co.getBreakSelectBracket(), co.getBracketSpacingAndOrWhen());
        niceSQL.setVariableName(Messages.getString("CodingStyleSQLProfile_SQL"));
        String targetLanguage = "SQL";
        if (co.getTargetSql() == 0) {
            targetLanguage = "SQL";
        }
        if (co.getTargetSql() == 1) {
            targetLanguage = "ASP StringBuilder";
        }
        if (co.getTargetSql() == 2) {
            targetLanguage = "C# StringBuilder";
        }
        if (co.getTargetSql() == 3) {
            targetLanguage = "Concatenated SQL";
        }
        if (co.getTargetSql() == 4) {
            targetLanguage = "Java StringBuffer";
        }
        if (co.getTargetSql() == 5) {
            targetLanguage = "Java String";
        }
        if (co.getTargetSql() == 6) {
            targetLanguage = "Java String 2";
        }
        if (co.getTargetSql() == 7) {
            targetLanguage = "MSSQL String";
        }
        if (co.getTargetSql() == 8) {
            targetLanguage = "Pascal String";
        }
        if (co.getTargetSql() == 9) {
            targetLanguage = "PHP String";
        }
        if (co.getTargetSql() == 10) {
            targetLanguage = "VB String (1)";
        }
        if (co.getTargetSql() == 11) {
            targetLanguage = "VB String (2)";
        }
        if (co.getTargetSql() == 12) {
            targetLanguage = "VB String (3)";
        }
        if (co.getTargetSql() == 13) {
            targetLanguage = "VB String (4)";
        }
        if (co.getTargetSql() == 14) {
            targetLanguage = "VB StringBuilder";
        }
        if (co.getTargetSql() == 15) {
            targetLanguage = "HTML code";
        }
        niceSQL.setVariableName("SQL");
        niceSQL.setFormatLanguage(targetLanguage);
        niceSQL.setOneLineSQL(co.getBreakSchema() == 3);
        String mySQLSourceEnclosed = "'";
        if (co.getSqlSourceEnclosed() == 0) {
            mySQLSourceEnclosed = "\"";
        }
        String mySQLSourceEscape = "\\";
        if (co.getSqlSourceEscape() == 1) {
            mySQLSourceEscape = "\"";
        }
        if (co.getSqlSourceEscape() == 2) {
            mySQLSourceEscape = "'";
        }
        niceSQL.setSourceSQL(co.getSqlsourceCopied(), mySQLSourceEnclosed, mySQLSourceEscape);
        niceSQL.setti("Only for Administrator");
        niceSQL.setSourceSQLLanguage(FormatHelper.dbToFormatter(co.getSourceSql()));
        int temp = co.getLineWidth();
        if (temp < 30) {
            temp = 30;
        }
        niceSQL.setPageWidth(temp);
        niceSQL.setColor(false);
        niceSQL.setLineNumber(false);
        niceSQL.setLinebreakKeyword(co.getBreakKeyword());
        niceSQL.setLinebreakCase(co.getBreakCase());
        niceSQL.setLinebreakCaseThen(co.getBreakCaseThen());
        niceSQL.setLinebreakCaseWhen(co.getBreakCaseWhen());
        niceSQL.setLinebreakCaseAndOr(co.getBreakCaseAndOr());
        niceSQL.setLinebreakCaseElse(co.getBreakCaseElse());
        niceSQL.setLinebreakJoin(co.getBreakJoin());
        niceSQL.setLinebreakJoinJoin(false);
        niceSQL.setLinebreakJoinOn(false);
        niceSQL.setAlignmentEqual(co.getAlignEqual());
        niceSQL.setAlignmentOperator(co.getAlignOperator());
        niceSQL.setAlignmentAs(co.getAlignAs());
        niceSQL.setAlignmentComma(co.getAlignComma());
        niceSQL.setAlignmentComment(co.getAlignComment());
        niceSQL.setAlignmentConcat(co.getAlignConcat());
        niceSQL.setAlignmentDeclaration(co.getAlignDecl());
        niceSQL.setAlignmentKeyword(co.getAlignKeyword());
        niceSQL.setSuppressComment(co.getSuppressComment());
        niceSQL.setSuppressLinebreak(false);
        niceSQL.setReplaceComment(co.getReplaceComment());
        niceSQL.setSuppressEmptyLine(co.getMoreNewlines(), co.getPreserveNewlines());
        int bracketSpaces = co.getBracketSpacing();
        if (bracketSpaces == 0) {
            niceSQL.setBracketSpaces("unchangedSpaceInsideBracket");
        }
        if (bracketSpaces == 1) {
            niceSQL.setBracketSpaces("noSpacesAroundBracket");
        }
        if (bracketSpaces == 2) {
            niceSQL.setBracketSpaces("oneSpaceInsideBracket");
        }
        if (bracketSpaces == 3) {
            niceSQL.setBracketSpaces("oneSpaceOutsideBracket");
        }
        if (bracketSpaces == 4) {
            niceSQL.setBracketSpaces("oneSpaceAroundBracket");
        }
        if ((commaSpace = co.getCommaSpacing()) == 0) {
            niceSQL.setCommaSpaces("unchangedSpaceComma");
        }
        if (commaSpace == 1) {
            niceSQL.setCommaSpaces("noSpacesAroundComma");
        }
        if (commaSpace == 3) {
            niceSQL.setCommaSpaces("oneSpaceAfterComma");
        }
        if (commaSpace == 2) {
            niceSQL.setCommaSpaces("oneSpaceBeforeComma");
        }
        if (commaSpace == 4) {
            niceSQL.setCommaSpaces("oneSpaceAroundComma");
        }
        if ((equalSpace = co.getOperatorSpacing()) == 0) {
            niceSQL.setEqualSpaces("unchangedSpaceEqual");
        }
        if (equalSpace == 1) {
            niceSQL.setEqualSpaces("noSpacesAroundEqual");
        }
        if (equalSpace == 2) {
            niceSQL.setEqualSpaces("oneSpaceAroundEqual");
        }
        if ((temp = co.getSmallSql()) < 0) {
            temp = 80;
        }
        niceSQL.setSmallSQLWidth(temp);
        String SQLString = niceSQL.formatSQLAsString(start);
        return SQLString;
    }
}

