/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console;

import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class HistoryItem {
    private String original = "";
    private String timestamp = "";
    private int timesUsed = 0;
    private long timing = 0L;
    private boolean inCurrentSession = false;

    public HistoryItem(String data) {
        this.original = data;
        Date tmpDate = new Date(System.currentTimeMillis());
        this.timestamp = DateFormat.getDateInstance().format(tmpDate);
        this.timesUsed = 1;
        this.inCurrentSession = true;
    }

    public HistoryItem(String data, String timeStamp, String times, long timing) {
        this.original = data;
        this.timestamp = timeStamp;
        this.timesUsed = Integer.parseInt(times);
        this.timing = timing;
    }

    public String getData() {
        return this.original;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setData(String data) {
        this.original = data.trim();
    }

    public int getTimesUsed() {
        return this.timesUsed;
    }

    public void dingTimesUsed() {
        ++this.timesUsed;
        this.inCurrentSession = true;
    }

    public List<String> getBuffer() {
        String[] array = this.original.split("\\r?\\n");
        return Arrays.asList(array);
    }

    public long getTiming() {
        return this.timing;
    }

    public void setTiming(long timing) {
        this.timing = timing;
    }

    public boolean inCurrentSession() {
        return this.inCurrentSession;
    }

    public void setIsCurrentSession(boolean isCurrentSession) {
        this.inCurrentSession = isCurrentSession;
    }
}

