/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jline.console.completer.Completer;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.raptor.console.HistoryItem;
import oracle.dbtools.raptor.console.MultiLineHistory;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetEntries;
import oracle.dbtools.util.Service;

public class SqlCompleter
implements Completer {
    static SqlEarley earley = SqlEarley.partialRecognizer(new String[]{"sql_statements"});
    static int approximateIndex = -1;
    static Parsed prg = null;
    static IProgram programInstance = null;
    private ScriptRunnerContext _ctx;

    public static void main(String[] args) throws Exception {
        SqlCompleter c = new SqlCompleter(null);
        ArrayList<CharSequence> candidates = new ArrayList<CharSequence>();
        NetEntries.getInstance().add("DB", "DBCompleted");
        String input = Service.readFile(SqlCompleter.class, "test.sql");
        System.out.println(input.length());
        c.complete(input, input.length(), candidates);
        System.out.println(candidates);
    }

    public SqlCompleter(ScriptRunnerContext ctx) {
        this._ctx = ctx;
    }

    public static Set<Long> predict(int pos, Matrix matrix) {
        HashSet<Long> predictions = new HashSet<Long>();
        for (int x = 0; x <= pos; ++x) {
            Cell cell = matrix.get(x, pos);
            if (cell == null) continue;
            for (int i = 0; i < cell.size(); ++i) {
                int rule = cell.getRule(i);
                int p = cell.getPosition(i);
                if (p >= SqlCompleter.earley.rules[rule].rhs.length) continue;
                String e = SqlCompleter.earley.allSymbols[SqlCompleter.earley.rules[rule].rhs[p]];
                predictions.add(Service.lPair(SqlCompleter.earley.rules[rule].rhs[p], SqlCompleter.earley.rules[rule].head));
            }
        }
        return predictions;
    }

    public static Set<String> topKWsuggestions(Set<Long> suggestions, LexerToken prefix) {
        TreeMap<Long, Integer> topN = new TreeMap<Long, Integer>();
        int N = 7;
        for (long entry : suggestions) {
            String parent;
            String string;
            String prefixKW = "'";
            if (prefix != null) {
                prefixKW = "'" + prefix.content;
            }
            if (!(string = SqlCompleter.earley.allSymbols[Service.lX(entry)]).startsWith(prefixKW.toUpperCase()) || (parent = SqlCompleter.earley.allSymbols[Service.lY(entry)]).endsWith("]\"") && 2 + string.length() < parent.length()) continue;
            long minVar = -1L;
            int minVal = Integer.MAX_VALUE;
            Iterator iterator = topN.keySet().iterator();
            while (iterator.hasNext()) {
                long s = (Long)iterator.next();
                int tmp = (Integer)topN.get(s);
                if (tmp >= minVal) continue;
                minVar = s;
                minVal = tmp;
            }
            long suggestedVar = entry;
            Integer suggestedVal = HarvestDoc.getFrequencies().get(entry);
            if (suggestedVal == null) {
                suggestedVal = 0;
            }
            if (topN.size() == 7) {
                if (suggestedVal == null || minVal >= suggestedVal) continue;
                topN.remove(minVar);
                topN.put(suggestedVar, suggestedVal);
                continue;
            }
            topN.put(suggestedVar, suggestedVal);
        }
        ArrayList myList = new ArrayList();
        for (Map.Entry e : topN.entrySet()) {
            myList.add(e);
        }
        Collections.sort(myList, new Comparator<Map.Entry<Long, Integer>>(){

            @Override
            public int compare(Map.Entry a, Map.Entry b) {
                return ((Integer)b.getValue()).compareTo((Integer)a.getValue());
            }
        });
        TreeSet<String> ret = new TreeSet<String>();
        int i = 0;
        for (Map.Entry entry : myList) {
            if (7 < i) break;
            String sugg = SqlCompleter.earley.allSymbols[Service.lX((Long)entry.getKey())];
            sugg = sugg.substring(1, sugg.length() - 1);
            if ("true".equals(HiddenParameters.parameters.get("coloredComplete"))) {
                ret.add("\u001b[32m" + sugg + "\u001b[0m");
            } else {
                ret.add(sugg);
            }
            ++i;
        }
        return ret;
    }

    private static void lookupHistory(List<CharSequence> candidates, String prefix) {
        prefix = prefix.trim();
        ArrayList<HistoryItem> history = MultiLineHistory.getInstance().getHistory();
        int cnt = 0;
        for (HistoryItem item : history) {
            String newSuggestion;
            if (7 < cnt) break;
            List<String> buffer = item.getBuffer();
            StringBuilder suggestion = new StringBuilder();
            for (String line : buffer) {
                suggestion.append(line);
                if (150 >= suggestion.length()) continue;
                suggestion = null;
                break;
            }
            if (suggestion == null || !(newSuggestion = suggestion.toString()).toLowerCase().startsWith(prefix.toLowerCase()) || SqlCompleter.contains(candidates, newSuggestion)) continue;
            candidates.add(newSuggestion);
            ++cnt;
        }
    }

    private static boolean contains(List<CharSequence> candidates, String entry) {
        for (CharSequence tmp : candidates) {
            if (!((String)tmp).toUpperCase().trim().equals(entry.toUpperCase().trim())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int complete(String lastLine, int cursor, List<CharSequence> candidates) {
        try {
            Parsed target;
            List<LexerToken> src;
            if ("true".equals(HiddenParameters.parameters.get("debugComplete"))) {
                System.out.println("\u001b[32m)");
                System.out.println("lastLine=" + lastLine + "");
                System.out.println("cursor=" + cursor);
            }
            String line = "";
            int pos = cursor;
            if (this._ctx != null) {
                line = this._ctx.getSQLPlusBuffer().getBufferString();
                pos = this._ctx.getSQLPlusBuffer().getBufferCursor(this._ctx.getSQLPlusBuffer().getCurrentLine(), cursor);
            } else {
                line = lastLine;
            }
            if ("true".equals(HiddenParameters.parameters.get("debugComplete"))) {
                System.out.println("line=" + line);
                System.out.println("pos=" + pos);
            }
            if (0 == (src = (target = new Parsed(line, earley, null)).getSrc()).size()) {
                return 0;
            }
            approximateIndex = LexerToken.char2lex(src, pos);
            LexerToken prefix = null;
            if (approximateIndex < src.size() && src.get((int)SqlCompleter.approximateIndex).end == pos) {
                prefix = src.get(approximateIndex);
            }
            if (!(prefix == null || prefix.type != Token.OPERATION || prefix.content.equals(":") || prefix.content.equals("!") || prefix.content.equals("^"))) {
                prefix = null;
                ++approximateIndex;
            }
            if (src.get((int)0).content.equalsIgnoreCase("connect")) {
                String pref = "";
                if (prefix != null) {
                    pref = prefix.content;
                }
                for (String sugg : NetEntries.getMatching(pref)) {
                    candidates.add(sugg);
                }
                return cursor - pref.length();
            }
            if (4 <= src.get((int)0).content.length() && src.get((int)0).content.substring(0, 4).equalsIgnoreCase("desc")) {
                String pref = "";
                if (prefix != null) {
                    pref = prefix.content;
                }
                String owner = null;
                String obj = pref;
                if (2 < src.size() && ".".equals(src.get((int)2).content)) {
                    owner = src.get((int)1).content.toUpperCase();
                }
                for (String sugg : this.queryObjects(owner, obj.toUpperCase(), "")) {
                    candidates.add(sugg);
                }
                return cursor - pref.length();
            }
            Set<Long> predicted = SqlCompleter.predict(approximateIndex, target.getMatrix());
            TreeSet<String> predictions = new TreeSet<String>();
            for (long key : predicted) {
                predictions.add(SqlEarley.getInstance().allSymbols[Service.lX(key)]);
            }
            if (prg == null) {
                prg = new Parsed(Service.readFile(SqlCompleter.class, "completion.prg"), Program.getArboriParser(), "program");
            }
            if (programInstance == null) {
                programInstance = new IProgram();
                programInstance.program(prg.getRoot(), prg.getSrc(), prg.getInput());
            }
            SqlCompleter.programInstance.offset = approximateIndex;
            Map<String, MaterializedPredicate> output = programInstance.eval(target);
            MaterializedPredicate col = output.get("\"table_alias in narrowest qb\"");
            block6: for (int i = 0; i < col.cardinality(); ++i) {
                String tableExpr;
                ParseNode table = col.getAttribute(i, "table");
                ParseNode alias = col.getAttribute(i, "alias");
                int begin = src.get((int)table.from).begin;
                int end = src.get((int)(table.to - 1)).end;
                String owner = null;
                String tab = null;
                if (prefix != null) {
                    tab = prefix.content;
                }
                if (0 < (tableExpr = target.getInput().substring(begin, end)).indexOf(46)) {
                    owner = tableExpr.substring(0, tableExpr.indexOf(46));
                    tab = tableExpr.substring(tableExpr.indexOf(46) + 1);
                } else {
                    owner = null;
                    tab = tableExpr;
                }
                if (table == alias && table.to < src.size() && ".".equals(src.get((int)table.to).content)) {
                    owner = tableExpr;
                    tab = "";
                    prefix = null;
                }
                if (predictions.contains("column")) {
                    for (String sugg : this.queryColumns(owner, tab, prefix != null ? prefix.content : null)) {
                        candidates.add(sugg);
                    }
                }
                for (String symbol : predictions) {
                    if (!symbol.startsWith("query_table_expression")) continue;
                    if (!tableExpr.equals(tab) && owner == null) continue block6;
                    if (table != alias) continue;
                    for (String sugg : this.queryObjects(owner, tab.toUpperCase(), "object_type in ('TABLE','VIEW','SYNONYM') and")) {
                        candidates.add(sugg);
                    }
                }
            }
            if (col.cardinality() == 0 && predictions.contains("table_reference")) {
                for (String sugg : this.queryObjects(null, "", "object_type in ('TABLE','VIEW','SYNONYM') and")) {
                    if ("true".equals(HiddenParameters.parameters.get("coloredComplete"))) {
                        candidates.add("\u001b[1m" + sugg + "\u001b[0m");
                        continue;
                    }
                    candidates.add(sugg);
                }
            }
            if (candidates.size() == 0 && prefix != null) {
                for (String sugg : SqlCompleter.topKWsuggestions(predicted, prefix)) {
                    if (candidates.contains(sugg)) continue;
                    candidates.add(sugg);
                }
            }
            if (candidates.size() == 1 && 0 < candidates.get(0).toString().indexOf(32)) {
                return 0;
            }
            if (candidates.size() == 1) {
                String cleaned = null;
                for (CharSequence c : candidates) {
                    cleaned = c.toString();
                    if (!cleaned.endsWith("\u001b[0m")) continue;
                    int end = cleaned.indexOf("\u001b[0m");
                    if (cleaned.startsWith("\u001b[1m")) {
                        cleaned = cleaned.substring("\u001b[1m".length(), end);
                        continue;
                    }
                    cleaned = cleaned.substring("\u001b[32m".length(), end);
                }
                candidates.clear();
                candidates.add(cleaned);
            }
            int ret = cursor;
            if (prefix != null) {
                ret = cursor - prefix.content.length();
            }
            if ("true".equals(HiddenParameters.parameters.get("debugComplete"))) {
                System.out.println("return=" + ret + "\u001b[0m");
            }
            return ret;
        }
        catch (SQLRecoverableException e) {
            return 0;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> queryObjects(String owner, String prefix, String typesClause) throws SQLException {
        Connection conn;
        int maxUsers = 20;
        String query = "select /*distinct*/ object_name from all_objects \nwhere " + typesClause + " owner=user \n" + "and object_name like :1 and rownum < 50\n" + "union all \n" + "select username||'.' from all_users where username like :2 and rownum <= " + 20 + " \n" + "order by object_name";
        if (owner != null) {
            query = "select object_name from all_objects \nwhere " + typesClause + " owner = :1 and object_name like :2 \n" + "and rownum < 50 order by object_name";
        }
        if ((conn = this.getConnection()) == null) {
            return new LinkedList<String>();
        }
        if (3 < prefix.length()) {
            query = query.replace("owner=user", "owner in ('PUBLIC',user)");
        }
        PreparedStatement stmt = conn.prepareStatement(query);
        int pos = 1;
        if (owner != null) {
            stmt.setObject(pos++, owner.toUpperCase());
        } else {
            stmt.setObject(pos++, prefix.toUpperCase() + '%');
        }
        stmt.setObject(pos++, prefix.toUpperCase() + '%');
        ResultSet rs = stmt.executeQuery();
        try {
            LinkedList<String> users = new LinkedList<String>();
            LinkedList<String> ret = new LinkedList<String>();
            while (rs.next()) {
                String candidate = rs.getString(1);
                if (candidate.endsWith(".")) {
                    users.add(candidate);
                    continue;
                }
                ret.add(rs.getString(1));
            }
            if (users.size() < 20) {
                ret.addAll(users);
            }
            LinkedList<String> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> queryColumns(String owner, String table, String prefix) throws SQLException {
        Connection conn;
        String query = "select column_name from user_tab_columns where table_name = :1 \nand column_name like :2 and rownum < 50 order by column_name\n";
        if (owner != null) {
            query = "select column_name from all_tab_columns where owner = :1 and table_name = :2 \nand column_name like :2 and rownum < 50 order by column_name\n";
        }
        if ((conn = this.getConnection()) == null) {
            return new LinkedList<String>();
        }
        PreparedStatement stmt = conn.prepareStatement(query);
        int pos = 1;
        if (owner != null) {
            stmt.setObject(pos++, owner.toUpperCase());
        }
        stmt.setObject(pos++, table.toUpperCase());
        if (prefix != null) {
            stmt.setObject(pos++, prefix.toUpperCase() + '%');
        } else {
            stmt.setObject(pos++, "%");
        }
        ResultSet rs = stmt.executeQuery();
        try {
            LinkedList<String> ret = new LinkedList<String>();
            while (rs.next()) {
                ret.add(rs.getString(1));
            }
            LinkedList<String> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private Connection getConnection() throws SQLException {
        Connection conn = null;
        conn = this._ctx != null ? this._ctx.getBaseConnection() : DriverManager.getConnection("jdbc:oracle:thin:@gbr30060.uk.oracle.com:1521/DB12PERF", "hr", "hr");
        return conn;
    }

    static class IProgram
    extends SqlProgram {
        int offset = -1;

        IProgram() {
        }
    }
}

