/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.translation.util;

import java.util.ArrayList;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;

public class TranslationUtil {
    private static final String EXTRA_OBJ_HEADER = "/* Translation Extracted DDL For Required Objects*/\n";

    public static String getFullDdlScript(ArrayList<TranslationDBObject> arrayList, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        boolean bl = true;
        int n = 0;
        if (arrayList != null && arrayList.size() > 0) {
            for (TranslationDBObject translationDBObject : arrayList) {
                if (translationDBObject == null || translationDBObject.getDdl() == null) continue;
                if (bl) {
                    stringBuffer.append(EXTRA_OBJ_HEADER);
                    bl = false;
                    string2 = "\n\n";
                }
                String string3 = translationDBObject.getDdl();
                string3 = TranslationUtil.processTempTables(string3);
                String string4 = translationDBObject.getSourceName();
                String string5 = translationDBObject.getObjName();
                if (string4 != null && string5 != null) {
                    string = TranslationUtil.processMain(string, string4, string5);
                }
                stringBuffer.append(string3 + ";\n/\n");
                if (!string3.trim().startsWith("CREATE GLOBAL TEMPORARY TABLE")) continue;
                ++n;
            }
            if (n > 0) {
                stringBuffer.insert(0, "/*Global Temporary Tables:" + n + " */");
            }
        }
        if (string != null && !string.trim().equals("") && string.toUpperCase().startsWith("CREATE TABLE")) {
            stringBuffer.insert(0, string + string2);
        } else {
            stringBuffer.append(string2 + string);
        }
        return stringBuffer.toString();
    }

    private static String processMain(String string, String string2, String string3) {
        string = string.replaceAll(string2, string3);
        return string;
    }

    private static String processTempTables(String string) {
        String string2 = null;
        string2 = TranslationUtil.removeGroupByFuncs(string);
        return string2;
    }

    public static String removeGroupByFuncs(String string) {
        string = string.replaceAll("(?i)MAX\\((.+?)\\)", "$1");
        string = string.replaceAll("(?i)MIN\\((.+?)\\)", "$1");
        string = string.replaceAll("(?i)SUM\\((.+?)\\)", "$1");
        string = string.replaceAll("(?i)COUNT\\((.+?)\\)", "0");
        return string;
    }
}

