/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.translation.api.objects;

import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;

public class TranslationDBObject
extends TranslationDBObjectReference {
    private String m_ddl = null;

    public TranslationDBObject(TranslationDBObjectReference translationDBObjectReference, String string) {
        super(translationDBObjectReference);
        this.m_ddl = string;
    }

    public TranslationDBObject(String string) {
        this.m_ddl = string;
    }

    public String getDdl() {
        return this.m_ddl;
    }

    public void setDdl(String string) {
        this.m_ddl = string != null && string.trim().startsWith("CREATE GLOBAL TEMPORARY TABLE") ? TranslationDBObject.processTempTables(string) : string;
    }

    private static String processTempTables(String string) {
        String string2 = null;
        string2 = TranslationDBObject.removeGroupByFuncs(string);
        string2 = TranslationDBObject.convertNULLLiteral(string2);
        return string2;
    }

    private static String convertNULLLiteral(String string) {
        string = string.replaceAll("NOT NULL", "not null");
        string = string.replaceAll("IS NULL", "is null");
        string = string.replaceAll("( |\r|\n|\t|,)NULL( |\r|\n|\t|,)", "$1/*NULL*/0$2");
        return string;
    }

    public static String removeGroupByFuncs(String string) {
        string = string.replaceAll("(?i)MAX\\((.+?)\\)", "$1");
        string = string.replaceAll("(?i)MIN\\((.+?)\\)", "$1");
        string = string.replaceAll("(?i)SUM\\((.+?)\\)", "$1");
        string = string.replaceAll("(?i)COUNT\\((.+?)\\)", "0");
        return string;
    }
}

