/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.collections.AST;
import java.util.ArrayList;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.ext.ExtStringTemplate;
import oracle.dbtools.migration.parser.internalapi.LastChildCharPositionVisitor;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.util.ASTUtil;
import org.antlr.stringtemplate.StringTemplate;

public class CodeBlockManager {
    Block m_currentBlock = null;
    Block m_topBlock = null;

    public Block getCurrentBlock() {
        return this.m_currentBlock;
    }

    public void setCurrentBlock(Block block) {
        this.m_currentBlock = block;
    }

    public Block getTopBlock() {
        return this.m_topBlock;
    }

    public void setTopBlock(Block block) {
        this.m_topBlock = block;
    }

    public void pushCodeBlock(String string) {
        Block block = new Block();
        block.setBlockType(string);
        if (this.m_currentBlock != null) {
            this.m_currentBlock.addChild(block);
        }
        this.m_currentBlock = block;
    }

    public Block popCodeBlock() {
        if (this.m_currentBlock != null) {
            this.m_currentBlock = this.m_currentBlock.getParent();
        }
        return this.m_currentBlock;
    }

    public void setCurrentBlock(AST aST) {
        ExtAST extAST = (ExtAST)aST;
        extAST.setBlock(this.m_currentBlock);
        this.m_currentBlock.setAST(aST);
        this.m_currentBlock.setIndexes(extAST.getCharPosition(), ASTUtil.walkAntlrTree(extAST, new LastChildCharPositionVisitor()).getValueInt());
    }

    public void updateCodeBlock(String string, AST aST) {
        this.m_currentBlock.setBlockName(string);
        if (!this.m_currentBlock.getBlockType().equals("CONTEXTBLOCK")) {
            this.setCurrentBlock(aST);
        }
    }

    public Block findBlock(Block block, AST aST) {
        Block block2 = null;
        if (aST == null) {
            return null;
        }
        if (aST instanceof ExtAST && ((ExtAST)aST).getBlock() != null) {
            return ((ExtAST)aST).getBlock();
        }
        if (block == null) {
            return block2;
        }
        AST aST2 = block.getAST();
        if (aST2 != null && aST2.getLine() == aST.getLine() && aST2.getColumn() == aST.getColumn()) {
            block2 = block;
        }
        if (block2 == null) {
            ArrayList<Block> arrayList = block.getChildren();
            for (int i = 0; i < arrayList.size() && (block2 = this.findBlock(arrayList.get(i), aST)) == null; ++i) {
            }
        }
        return block2;
    }

    public boolean hasEnclosingBlock(AST aST, String string, String string2) {
        Block block = this.findEnclosingBlock(aST, string);
        if (block == null) {
            return false;
        }
        return block.getBlockName() != null ? block.getBlockName().equalsIgnoreCase(string2) : false;
    }

    public Block findEnclosingBlock(StringTemplate stringTemplate) {
        return this.findEnclosingBlock(this.m_topBlock, stringTemplate);
    }

    private Block findEnclosingBlock(Block block, StringTemplate stringTemplate) {
        Block block2 = null;
        if (block == null || stringTemplate == null) {
            return null;
        }
        for (Block block3 : block.getChildren()) {
            if (block3 == null) continue;
            if (block3.getAST() != null && (stringTemplate instanceof ExtStringTemplate ? ((ExtStringTemplate)stringTemplate).getStringTemplate().equals(block3.getAST().getSt()) : stringTemplate == block3.getAST().getSt())) {
                block2 = block3;
                break;
            }
            block2 = this.findEnclosingBlock(block3, stringTemplate);
            if (block2 == null) continue;
            break;
        }
        return block2;
    }

    public Block findEnclosingDMLBlock(AST aST) {
        Block block = null;
        String[] stringArray = new String[]{"OPERATIONBLOCK", "STMTBLOCK"};
        String[] stringArray2 = new String[]{"SELECT", "INSERT", "DELETE", "UPDATE"};
        for (String string : stringArray) {
            String string2;
            String[] stringArray3 = stringArray2;
            int n = stringArray3.length;
            for (int i = 0; i < n && (block = this.findEnclosingBlock(aST, string, string2 = stringArray3[i])) == null; ++i) {
            }
            if (block != null) break;
        }
        return block;
    }

    public Block findEnclosingDMLStatmentBlock(AST aST) {
        String string;
        String[] stringArray;
        Block block = null;
        String[] stringArray2 = stringArray = new String[]{"SELECT", "INSERT", "DELETE", "UPDATE"};
        int n = stringArray2.length;
        for (int i = 0; i < n && (block = this.findEnclosingBlock(aST, "STMTBLOCK", string = stringArray2[i])) == null; ++i) {
        }
        return block;
    }

    public Block findEnclosingBlock(AST aST, String string) {
        return this.findEnclosingBlock(aST, string, null);
    }

    public Block findEnclosingBlock(AST aST, String string, String string2) {
        Block block;
        Block block2 = null;
        if (block == null) {
            block2 = this.findEnclosingBlock(this.m_topBlock, aST, string, string2);
        } else {
            for (block = ((ExtAST)aST).getBlock(); block != null; block = block.getParent()) {
                String string3 = block.getBlockType();
                if (string3 == null || !string3.equals(string)) continue;
                block2 = block;
                break;
            }
        }
        return block2;
    }

    private Block findEnclosingBlock(Block block, AST aST, String string, String string2) {
        int n;
        Block block2 = null;
        Block block3 = null;
        int n2 = aST.getSourceStartLine() != -1 ? aST.getSourceStartLine() : (n = aST.getLine() != -1 ? aST.getLine() : aST.getSourceEndLine());
        int n3 = aST.getSourceEndLine() != -1 ? aST.getSourceEndLine() : (aST.getLine() != -1 ? aST.getLine() : aST.getSourceEndLine());
        for (Block block4 : block.getChildren()) {
            if (block4.getBlockType().equals("CONTEXTBLOCK")) {
                block3 = this.findEnclosingBlock(block4, aST, string, string2);
                if (block3 == null) continue;
                block2 = block3;
                continue;
            }
            if (block4.getSourceStartLine() > n || block4.getSourceEndLine() < n3 || block4.getAST() != null && aST.getSourceStartCol() != -1 && (block4.getSourceStartLine() == n && block4.getAST().getSourceStartCol() > aST.getSourceStartCol() || block4.getSourceEndLine() == n3 && block4.getAST().getSourceEndCol() < aST.getSourceEndCol())) continue;
            if ((string == null || string != null && block4.getBlockType().equalsIgnoreCase(string)) && (string2 == null || string2 != null && string2.equalsIgnoreCase(block4.getBlockName()))) {
                block2 = block4;
            }
            if ((block3 = this.findEnclosingBlock(block4, aST, string, string2)) == null) continue;
            block2 = block3;
        }
        return block2;
    }
}

