/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.apt;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"oracle.dbtools.plugin.api.di.annotations.Provides"})
public class AnnotationProcessor
extends AbstractProcessor {
    private final Descriptor providers = new Descriptor("META-INF/oracle.dbtools.plugin.api.di.providers");
    public static final String SERVICE_PATH = "META-INF/oracle.dbtools.plugin.api.di.providers";
    static final String PROVIDES_ANNOTATION = "oracle.dbtools.plugin.api.di.annotations.Provides";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Filer filer = this.processingEnv.getFiler();
        Messager messager = this.processingEnv.getMessager();
        if (roundEnv.processingOver()) {
            this.providers.write(filer);
            for (String type : this.providers) {
                messager.printMessage(Diagnostic.Kind.NOTE, "Discovered type annotated with @Provides: " + type);
            }
        } else {
            this.processProviders(roundEnv, messager, filer);
        }
        return true;
    }

    private boolean isDefaultConstructor(ExecutableElement ctor) {
        return ctor.getParameters().isEmpty() && ctor.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    private boolean isInjectableConstructor(ExecutableElement ctor) {
        return ctor.getAnnotation(Inject.class) != null;
    }

    private void processProviders(RoundEnvironment roundEnv, Messager messager, Filer filer) {
        this.providers.read(filer);
        TypeElement provides = this.processingEnv.getElementUtils().getTypeElement(PROVIDES_ANNOTATION);
        for (Element element : roundEnv.getElementsAnnotatedWith(provides)) {
            TypeElement type = (TypeElement)TypeElement.class.cast(element);
            List<ExecutableElement> ctors = ElementFilter.constructorsIn(type.getEnclosedElements());
            boolean hasValidConstructor = false;
            for (ExecutableElement ctor : ctors) {
                if ((!this.isDefaultConstructor(ctor) || !this.isPublicType(type)) && !this.isInjectableConstructor(ctor)) continue;
                hasValidConstructor = true;
                break;
            }
            if (hasValidConstructor) {
                this.providers.add(type.getQualifiedName().toString());
                continue;
            }
            messager.printMessage(Diagnostic.Kind.ERROR, "The following type lacks a public default constructor or constructor annotated with @Inject: " + type.getQualifiedName().toString());
        }
    }

    private boolean isPublicType(TypeElement type) {
        return type.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class Descriptor
    implements Iterable<String> {
        private final Set<String> elements = new TreeSet<String>();
        private final String path;

        Descriptor(String path) {
            this.path = path;
        }

        @Override
        public Iterator<String> iterator() {
            return this.elements.iterator();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Descriptor [path=");
            builder.append(this.path);
            builder.append(", elements=");
            builder.append(this.elements);
            builder.append("]");
            return builder.toString();
        }

        void add(String element) {
            this.elements.add(element);
        }

        /*
         * Loose catch block
         */
        void read(Filer filer) {
            FileObject file = null;
            BufferedReader r = null;
            try {
                String line;
                file = filer.getResource(StandardLocation.CLASS_OUTPUT, "", this.path);
                r = new BufferedReader(new InputStreamReader(file.openInputStream(), "UTF-8"));
                while ((line = r.readLine()) != null) {
                    this.elements.add(line);
                }
            }
            catch (FileNotFoundException e) {
                AnnotationProcessor.close(r);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
                {
                    catch (Throwable throwable) {
                        AnnotationProcessor.close(r);
                        throw throwable;
                    }
                }
            }
            AnnotationProcessor.close(r);
        }

        void write(Filer filer) {
            if (this.elements.isEmpty()) {
                return;
            }
            Writer w = null;
            FileObject file = null;
            try {
                file = filer.createResource(StandardLocation.CLASS_OUTPUT, "", this.path, new Element[0]);
                w = file.openWriter();
                for (String element : this.elements) {
                    w.write(element);
                    w.write("\n");
                }
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    AnnotationProcessor.close(w);
                    throw throwable;
                }
            }
            AnnotationProcessor.close(w);
        }
    }
}

