/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import oracle.dbtools.plugin.api.di.Annotations;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides
public class AnnotationsProvider
implements Annotations {
    @Inject
    private AnnotationsProvider() {
    }

    @Override
    public <T extends Annotation> Annotations.Builder<T> create(Class<T> type) {
        return this.builder(type, null);
    }

    @Override
    public boolean equals(Annotation[] expected, Annotation[] actual) {
        boolean equal = Arrays.equals(expected, actual);
        return equal;
    }

    @Override
    public <T extends Annotation> T literal(Class<T> type) {
        return this.create(type).build();
    }

    @Override
    public <T extends Annotation> T literal(Class<T> type, Object value) {
        return this.create(type).value(value).build();
    }

    @Override
    public boolean matches(Annotation[] expected, Annotation[] actual) {
        LinkedHashSet<Annotation> all = new LinkedHashSet<Annotation>(actual.length);
        for (Annotation annotation : actual) {
            all.add(annotation);
        }
        if (expected == null && actual != null) {
            return false;
        }
        if (expected != null && actual == null) {
            return false;
        }
        if (actual.length < expected.length) {
            return false;
        }
        for (Annotation mustExist : expected) {
            if (all.contains(mustExist)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T extends Annotation> Annotations.Builder<T> modify(T annotation) {
        Class<? extends Annotation> type = annotation.annotationType();
        return this.builder(type, annotation);
    }

    private <T extends Annotation> Annotations.Builder<T> builder(Class<T> type, T existing) {
        return new AnnotationBuilder<T>(type, existing);
    }

    static Annotations newInstance() {
        return new AnnotationsProvider();
    }

    private static Object get(Annotation instance, Method method) {
        try {
            return method.invoke((Object)instance, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T extends Annotation> boolean hasProperty(Class<T> type, String name) {
        try {
            type.getDeclaredMethod(name, new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static Map<String, Object> properties(Annotation annotation) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (Method method : annotation.annotationType().getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            String name = method.getName();
            Object value = AnnotationsProvider.get(annotation, method);
            properties.put(name, value);
        }
        return properties;
    }

    private static Set<String> propertyNames(Class<? extends Annotation> type) {
        Method[] methods;
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Method method : methods = type.getDeclaredMethods()) {
            names.add(method.getName());
        }
        return names;
    }

    private static <T extends Annotation> T proxy(Class<T> type, Map<String, Object> properties) {
        return (T)((Annotation)type.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{type}, (InvocationHandler)new Base(type, properties))));
    }

    private static class Base
    implements InvocationHandler,
    Annotation {
        private final Map<String, Object> properties;
        private final Class<? extends Annotation> type;

        private Base(Class<? extends Annotation> type, Map<String, Object> properties) {
            this.type = type;
            this.properties = properties;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.type;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj != null && obj instanceof Annotation && this.type.equals(((Annotation)obj).annotationType())) {
                Map that = AnnotationsProvider.properties((Annotation)obj);
                return this.properties.equals(that);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            for (String property : this.properties.keySet()) {
                int memberNameHashCode = 127 * property.hashCode();
                Object value = this.properties.get(property);
                int memberValueHashCode = value instanceof boolean[] ? Arrays.hashCode((boolean[])value) : (value instanceof short[] ? Arrays.hashCode((short[])value) : (value instanceof int[] ? Arrays.hashCode((int[])value) : (value instanceof long[] ? Arrays.hashCode((long[])value) : (value instanceof float[] ? Arrays.hashCode((float[])value) : (value instanceof double[] ? Arrays.hashCode((double[])value) : (value instanceof byte[] ? Arrays.hashCode((byte[])value) : (value instanceof char[] ? Arrays.hashCode((char[])value) : (value instanceof Object[] ? Arrays.hashCode((Object[])value) : value.hashCode()))))))));
                hashCode += memberNameHashCode ^ memberValueHashCode;
            }
            return hashCode;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("equals".equals(method.getName())) {
                return this.equals(args[0]);
            }
            if ("hashCode".equals(method.getName())) {
                return this.hashCode();
            }
            if ("toString".equals(method.getName())) {
                return this.toString();
            }
            if ("annotationType".equals(method.getName())) {
                return this.annotationType();
            }
            return this.property(method);
        }

        @Override
        public String toString() {
            StringBuilder b = new StringBuilder("@").append(this.type.getName()).append("(");
            Method[] methods = this.type.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method property = methods[i];
                b.append(methods[i].getName()).append("=");
                Object value = this.property(property);
                if (value != null && value.getClass().isArray()) {
                    value = Arrays.toString((Object[])value);
                }
                b.append(value);
                if (i >= methods.length - 1) continue;
                b.append(",");
            }
            b.append(")");
            return b.toString();
        }

        private Object property(Method method) {
            String name = method.getName();
            Object value = this.properties.get(name);
            return value;
        }
    }

    private static class AnnotationBuilder<T extends Annotation>
    implements Annotations.Builder<T> {
        private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
        private final Class<T> type;

        AnnotationBuilder(Class<T> type, T existing) {
            this.type = type;
            for (String name : AnnotationsProvider.propertyNames(type)) {
                try {
                    Method method = type.getDeclaredMethod(name, new Class[0]);
                    Object value = method.getDefaultValue();
                    if (existing != null) {
                        value = AnnotationsProvider.get(existing, method);
                    }
                    this.properties.put(name, value);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public T build() {
            return (T)((Annotation)this.type.cast(AnnotationsProvider.proxy(this.type, this.properties)));
        }

        @Override
        public Annotations.Builder<T> property(String name, Object value) {
            if (AnnotationsProvider.hasProperty(this.type, name)) {
                this.properties.put(name, value);
            }
            return this;
        }

        @Override
        public Annotations.Builder<T> value(Object value) {
            return this.property("value", value);
        }
    }
}

