/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.listener.model.ListenerReportData;
import oracle.dbtools.listener.model.ListenerReportMessage;
import oracle.dbtools.plugin.api.json.objects.JSONArray;
import oracle.dbtools.plugin.api.json.objects.JSONObject;
import oracle.dbtools.raptor.cloud.connection.JSONUtils;

public class ListenerReportsUtils {
    public ListenerReportData getReportData(JSONObject jSONObject, boolean bl) {
        if (jSONObject == null) {
            return null;
        }
        ListenerReportData listenerReportData = new ListenerReportData();
        try {
            listenerReportData.addValue("report_time", JSONUtils.getValue((JSONObject)jSONObject, (String)"report_time"));
            listenerReportData.addValue("uptime", JSONUtils.getValue((JSONObject)jSONObject, (String)"uptime"));
            if (bl) {
                listenerReportData.addValue("pages_served", JSONUtils.getValue((JSONObject)jSONObject, (String)"pages_served"));
                listenerReportData.addValue("bytes_sent", JSONUtils.getValue((JSONObject)jSONObject, (String)"bytes_sent"));
                listenerReportData.addValue("total_errors", JSONUtils.getValue((JSONObject)jSONObject, (String)"total_errors"));
                listenerReportData.addValue("total_files", JSONUtils.getValue((JSONObject)jSONObject, (String)"total_files"));
                listenerReportData.addValue("security_cache_size", JSONUtils.getValue((JSONObject)jSONObject, (String)"security_cache_size"));
                listenerReportData.addValue("security_cache_max_entries", JSONUtils.getValue((JSONObject)jSONObject, (String)"security_cache_max_entries"));
                listenerReportData.addValue("cache_size", JSONUtils.getValue((JSONObject)jSONObject, (String)"cache_size"));
                listenerReportData.addValue("cache_max_entries", JSONUtils.getValue((JSONObject)jSONObject, (String)"cache_max_entries"));
                listenerReportData.addValue("active_requests", JSONUtils.getValue((JSONObject)jSONObject, (String)"active_requests"));
                JSONObject jSONObject2 = (JSONObject)JSONUtils.getValue((JSONObject)jSONObject, (String)"total_times");
                HashMap<String, Object> hashMap = this.getTimes("total_times", jSONObject2);
                listenerReportData.addTimings("total_times", hashMap);
                jSONObject2 = (JSONObject)JSONUtils.getValue((JSONObject)jSONObject, (String)"db_times");
                hashMap = this.getTimes("db_times", jSONObject2);
                listenerReportData.addTimings("db_times", hashMap);
            }
            return listenerReportData;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }

    private HashMap<String, Object> getTimes(String string, JSONObject jSONObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("total", JSONUtils.getValue((JSONObject)jSONObject, (String)"total"));
        hashMap.put("minimum", JSONUtils.getValue((JSONObject)jSONObject, (String)"minimum"));
        hashMap.put("average", JSONUtils.getValue((JSONObject)jSONObject, (String)"average"));
        hashMap.put("median", JSONUtils.getValue((JSONObject)jSONObject, (String)"median"));
        hashMap.put("maximum", JSONUtils.getValue((JSONObject)jSONObject, (String)"maximum"));
        return hashMap;
    }

    public List<ListenerReportMessage> getErrorReport(JSONObject jSONObject) {
        ArrayList<ListenerReportMessage> arrayList = new ArrayList<ListenerReportMessage>();
        JSONArray jSONArray = (JSONArray)JSONUtils.getValue((JSONObject)jSONObject, (String)"items");
        for (Object t : jSONArray.values()) {
            JSONObject jSONObject2 = (JSONObject)t;
            ListenerReportMessage listenerReportMessage = new ListenerReportMessage((String)JSONUtils.getValue((JSONObject)jSONObject2, (String)"time_stamp"), (String)JSONUtils.getValue((JSONObject)jSONObject2, (String)"message"));
            arrayList.add(listenerReportMessage);
        }
        return arrayList;
    }

    public List<ListenerReportMessage> getLogReport(JSONObject jSONObject) {
        ArrayList<ListenerReportMessage> arrayList = new ArrayList<ListenerReportMessage>();
        JSONArray jSONArray = (JSONArray)JSONUtils.getValue((JSONObject)jSONObject, (String)"items");
        for (Object t : jSONArray.values()) {
            JSONObject jSONObject2 = (JSONObject)t;
            ListenerReportMessage listenerReportMessage = new ListenerReportMessage((String)JSONUtils.getValue((JSONObject)jSONObject2, (String)"message"));
            arrayList.add(listenerReportMessage);
        }
        return arrayList;
    }
}

