/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerReportSettings;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.util.ResourceUtils;

public class ListenerLogOptionsPanel
extends ListenerSettings {
    private JCheckBox _logging;
    private NumericSpinBox _maxLogEntries;

    public ListenerLogOptionsPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this._logging = new JCheckBox();
        this._maxLogEntries = new NumericSpinBox(1, 100000);
        JLabel jLabel = new JLabel();
        ResourceUtils.resButton((AbstractButton)this._logging, (String)ListenerArb.getString("LOGGING"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._maxLogEntries, (String)ListenerArb.getString("MAX_LOG_ENTRIES"));
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._logging, new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 21, 2, new Insets(6, 8, 0, 8), 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(2, n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 22, 0, new Insets(6, 8, 8, 6), 0, 0));
        jPanel.add((Component)this._maxLogEntries, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 8, 8), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel, (String)StringUtils.stripMnemonic((String)ListenerArb.getString("LOGGING")));
        n = 0;
        this.add((Component)jPanel, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 21, 2, new Insets(6, 8, 0, 8), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLastRow(n);
    }

    private void enableDisableLogEntries() {
        this._maxLogEntries.setEnabled(this._logging.isSelected());
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, "Logging");
        this.assignSettings(this._model);
        this._logging.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    ListenerLogOptionsPanel.this.enableDisableLogEntries();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.enableDisableLogEntries();
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getReportSettings() != null) {
            ListenerReportSettings listenerReportSettings = this._model.getReportSettings();
            this._logging.setSelected(listenerReportSettings.isLogging());
            this._maxLogEntries.setIntValue(listenerReportSettings.getMaxLogEntries());
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getReportSettings() != null) {
            ListenerReportSettings listenerReportSettings = this._model.getReportSettings();
            listenerReportSettings.setLogging(this._logging.isSelected());
            listenerReportSettings.setMaxLogEntries(this._maxLogEntries.getIntValue());
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        ListenerReportSettings listenerReportSettings = listenerModel.getReportSettings();
        this.updateNumericSpinBoxHandler(this._maxLogEntries, listenerReportSettings.getMaxLogEntries());
        this.updateCheckBoxHandler(this._logging, listenerReportSettings.isLogging());
    }
}

