/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerReportSettings;
import oracle.dbtools.listener.ui.ListenerCheckBoxHandler;
import oracle.dbtools.listener.ui.ListenerNumericSpinBoxHandler;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.listener.ui.ListenerUIUtils;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.util.ResourceUtils;

public class ListenerErrorOptionsPanel
extends ListenerSettings {
    private JCheckBox _debugging;
    private JRadioButton _debugLogger;
    private JRadioButton _debugConsole;
    private boolean _globalDebugLogger;
    private boolean _debug;
    private Color _globalBGColor;
    private Color _origRadioBGColor;
    private JCheckBox _displayErrMessages;
    private JCheckBox _keepErrMessages;
    private NumericSpinBox _maxErrEntries;

    public ListenerErrorOptionsPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this._debugging = new JCheckBox();
        this._displayErrMessages = new JCheckBox();
        this._debugLogger = new JRadioButton();
        this._debugConsole = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._debugLogger);
        buttonGroup.add(this._debugConsole);
        this._keepErrMessages = new JCheckBox();
        this._maxErrEntries = new NumericSpinBox(1, 100000);
        JLabel jLabel = new JLabel();
        ResourceUtils.resButton((AbstractButton)this._debugging, (String)ListenerArb.getString("DEBUGGING"));
        ResourceUtils.resButton((AbstractButton)this._debugLogger, (String)ListenerArb.getString("DEBUG_MSG_LOGGER"));
        ResourceUtils.resButton((AbstractButton)this._debugConsole, (String)ListenerArb.getString("DEBUG_MSG_CONSOLE"));
        ResourceUtils.resButton((AbstractButton)this._displayErrMessages, (String)ListenerArb.getString("ERROR_MSG_BROWSER"));
        ResourceUtils.resButton((AbstractButton)this._keepErrMessages, (String)ListenerArb.getString("KEEP_RECENT_ERR_MSGS"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._maxErrEntries, (String)ListenerArb.getString("MAX_ERR_ENTRIES"));
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._debugLogger, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 0, 8), 0, 0));
        jPanel.add((Component)this._debugConsole, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 8, 8), 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(1, n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        TitledPane titledPane = new TitledPane((Component)this._debugging, (Component)jPanel);
        n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this._displayErrMessages, new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 8, 8), 0, 0));
        jPanel2.add((Component)this._keepErrMessages, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 21, 2, new Insets(6, 8, 0, 8), 0, 0));
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 22, 0, new Insets(6, 8, 0, 6), 0, 0));
        jPanel2.add((Component)this._maxErrEntries, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 0, 8), 0, 0));
        jPanel2.add(Box.createGlue(), new GridBagConstraints(1, ++n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel2, (String)ListenerArb.getString("ERROR_REPORTING"));
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)titledPane, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 21, 2, new Insets(8, 8, 8, 8), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 21, 2, new Insets(8, 8, 0, 8), 0, 0));
        n = 0;
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)jPanel3, new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 8, 8), 0, 0));
        jPanel4.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addSettingsPanel(jPanel4);
    }

    private void enableDisableErrEntries() {
        this._maxErrEntries.setEnabled(this._keepErrMessages.isSelected());
    }

    private void enableDisableDebugOptions() {
        this._debugLogger.setEnabled(this._debugging.isSelected());
        this._debugConsole.setEnabled(this._debugging.isSelected());
    }

    private void updateRadioButtonBGColor() {
        if (this._globalDebugLogger) {
            this._debugLogger.setBackground(this._globalBGColor);
            this._debugConsole.setBackground(this._origRadioBGColor);
        } else {
            this._debugLogger.setBackground(this._origRadioBGColor);
            this._debugConsole.setBackground(this._globalBGColor);
        }
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, "Environment");
        this.assignSettings(this._model);
        this._globalBGColor = ListenerUIUtils.getHighlightBackgroundColor();
        this._origRadioBGColor = new Color(this._debugLogger.getBackground().getRGB());
        if (listenerModel2 != null) {
            this._debugLogger.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    try {
                        ListenerErrorOptionsPanel.this.updateRadioButtonBGColor();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.updateRadioButtonBGColor();
        }
        this._keepErrMessages.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    ListenerErrorOptionsPanel.this.enableDisableErrEntries();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.enableDisableErrEntries();
        this._debugging.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    ListenerErrorOptionsPanel.this.enableDisableDebugOptions();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.enableDisableDebugOptions();
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getReportSettings() != null) {
            ListenerReportSettings listenerReportSettings = listenerModel.getReportSettings();
            this._debug = listenerReportSettings.getDebugOutput() != null && listenerReportSettings.getDebugOutput() != ListenerReportSettings.DEBUG_OUTPUT.OFF;
            this._debugging.setSelected(this._debug);
            if (this._debugging.isSelected()) {
                if (listenerReportSettings.getDebugOutput() != null && listenerReportSettings.getDebugOutput() == ListenerReportSettings.DEBUG_OUTPUT.CONSOLE) {
                    this._debugConsole.setSelected(true);
                    this._debugLogger.setSelected(false);
                } else {
                    this._debugConsole.setSelected(false);
                    this._debugLogger.setSelected(true);
                }
            } else {
                this._debugConsole.setSelected(false);
                this._debugLogger.setSelected(true);
            }
            this._displayErrMessages.setSelected(listenerReportSettings.isDisplayErrorMessages());
            this._keepErrMessages.setSelected(listenerReportSettings.isKeepErrorMessages());
            this._maxErrEntries.setIntValue(listenerReportSettings.getMaxErrorEntries());
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getReportSettings() != null) {
            ListenerReportSettings listenerReportSettings = this._model.getReportSettings();
            if (this._debugging.isSelected()) {
                if (this._debugConsole.isSelected()) {
                    listenerReportSettings.setDebugOutput(ListenerReportSettings.DEBUG_OUTPUT.CONSOLE);
                } else {
                    listenerReportSettings.setDebugOutput(ListenerReportSettings.DEBUG_OUTPUT.LOGGER);
                }
            } else {
                listenerReportSettings.setDebugOutput(ListenerReportSettings.DEBUG_OUTPUT.OFF);
            }
            listenerReportSettings.setDisplayErrorMessages(this._displayErrMessages.isSelected());
            listenerReportSettings.setKeepErrorMessages(this._keepErrMessages.isSelected());
            listenerReportSettings.setMaxErrorEntries(this._maxErrEntries.getIntValue());
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        ListenerReportSettings listenerReportSettings = listenerModel.getReportSettings();
        boolean bl = false;
        if (listenerReportSettings.getDebugOutput() != null && listenerReportSettings.getDebugOutput() != ListenerReportSettings.DEBUG_OUTPUT.OFF) {
            bl = true;
        }
        this.updateCheckBoxHandler(this._debugging, bl);
        this.updateCheckBoxHandler(this._displayErrMessages, listenerReportSettings.isDisplayErrorMessages());
        this._globalDebugLogger = listenerReportSettings.getDebugOutput() == null || listenerReportSettings.getDebugOutput() == ListenerReportSettings.DEBUG_OUTPUT.OFF || listenerReportSettings.getDebugOutput() == ListenerReportSettings.DEBUG_OUTPUT.LOGGER;
        this._maxErrEntries.addChangeListener((ChangeListener)new ListenerNumericSpinBoxHandler(this._maxErrEntries, listenerReportSettings.getMaxErrorEntries()));
        this._keepErrMessages.addItemListener(new ListenerCheckBoxHandler(this._keepErrMessages, listenerReportSettings.isKeepErrorMessages()));
    }

    @Override
    public boolean isGlobalSettingsChange() {
        if (this._parentModel == null) {
            ListenerReportSettings listenerReportSettings = this._model.getReportSettings();
            ListenerReportSettings.DEBUG_OUTPUT dEBUG_OUTPUT = ListenerReportSettings.DEBUG_OUTPUT.OFF;
            if (this._debugging.isSelected()) {
                ListenerReportSettings.DEBUG_OUTPUT dEBUG_OUTPUT2 = dEBUG_OUTPUT = this._debugLogger.isSelected() ? ListenerReportSettings.DEBUG_OUTPUT.LOGGER : ListenerReportSettings.DEBUG_OUTPUT.CONSOLE;
            }
            if (dEBUG_OUTPUT != listenerReportSettings.getDebugOutput() || this._displayErrMessages.isSelected() != listenerReportSettings.isDisplayErrorMessages()) {
                return true;
            }
        }
        return false;
    }
}

