/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.CharacterMap;

public class XMLObjectWriter
extends Writer {
    private PrintWriter m_writer;
    private String m_encoding = "UTF8";
    private int m_mode = 0;
    private String m_xml;
    private static final int s_margin = 30;
    protected Object m_lock = new Object();

    public XMLObjectWriter() {
    }

    public XMLObjectWriter(Writer writer) {
        super((Object)writer);
        this.m_writer = new PrintWriter(writer);
    }

    public XMLObjectWriter(OutputStream outputStream) {
        try {
            this.m_writer = new PrintWriter(new OutputStreamWriter(outputStream, "UTF8"));
        }
        catch (Exception e) {
            this.m_writer = new PrintWriter(new OutputStreamWriter(outputStream));
        }
    }

    public void setIndentEnabled(boolean pretty) {
        this.m_mode = pretty ? 2 : 0;
    }

    public void setIndentMode(int mode) {
        this.m_mode = mode;
    }

    public int getIndentMode() {
        return this.m_mode;
    }

    public void setEncoding(String encoding) {
        this.m_encoding = encoding;
    }

    public void writeObjectNode(BaseObjectNode node) throws BIIOException {
        this.writeObjectNode(node, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObjectNode(BaseObjectNode node, CharacterMap map) throws BIIOException {
        Object object = this.lock;
        synchronized (object) {
            if (node != null && node.getDOMElement() == null) {
                int _capacity = node.getRequiredCapacity(0, this.m_mode) + 30;
                StringBuffer _buffer = new StringBuffer(_capacity);
                this.writeHeader(_buffer, "1.0", null, map);
                if (this.m_mode > 0) {
                    _buffer.append(BaseNode.NEW_LINE);
                }
                node.finishAll(_buffer, "", this.m_mode);
                String _finalStr = this.convertCharacters(_buffer.toString(), map);
                if (this.m_writer != null) {
                    this.m_writer.print(_finalStr);
                } else {
                    this.m_xml = _finalStr;
                }
            }
            try {
                this.flush();
            }
            catch (IOException ioe) {
                throw new BIIOException(ioe.getLocalizedMessage(), null);
            }
        }
    }

    public String toString() {
        if (this.m_writer == null) {
            if (this.m_xml == null) {
                return "";
            }
            return this.m_xml;
        }
        return super.toString();
    }

    @Override
    public void close() {
        if (this.m_writer != null) {
            this.m_writer.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.m_writer != null) {
            this.m_writer.flush();
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.m_writer != null) {
            this.m_writer.write(cbuf, off, len);
        }
    }

    private String convertCharacters(String xml, CharacterMap map) {
        if (map != null) {
            Vector _maps = map.getMappings();
            if (_maps != null) {
                for (int j = 0; j < _maps.size(); ++j) {
                    Object _holder;
                    Object _elem = _maps.elementAt(j);
                    if (_elem instanceof CharacterMap.CharHolder) {
                        _holder = (CharacterMap.CharHolder)_maps.elementAt(j);
                        xml = xml.replace(((CharacterMap.CharHolder)_holder).getKey(), ((CharacterMap.CharHolder)_holder).getValue());
                        continue;
                    }
                    if (!(_elem instanceof CharacterMap.StringHolder)) continue;
                    _holder = (CharacterMap.StringHolder)_maps.elementAt(j);
                    xml = this.replace(xml, 0, ((CharacterMap.StringHolder)_holder).getKey(), ((CharacterMap.StringHolder)_holder).getValue());
                }
            }
            return xml;
        }
        return xml;
    }

    private String replace(String xml, int index, String key, String value) {
        int _index = xml.indexOf(key, index);
        if (_index > -1) {
            String _newStr = xml.substring(0, _index) + value + xml.substring(_index + key.length(), xml.length());
            return this.replace(_newStr, _index, key, value);
        }
        return xml;
    }

    private void writeHeader(StringBuffer buffer, String version, String encoding, CharacterMap map) {
        if (version == null) {
            version = "1.0";
        }
        Object _header = null;
        if (encoding == null) {
            buffer.append("<?xml version=\"");
            buffer.append(version);
            buffer.append("\" ?>");
        } else {
            buffer.append("<?xml version=\"");
            buffer.append(version);
            buffer.append("\" encoding=\"");
            buffer.append(encoding);
            buffer.append("\" ?>");
        }
    }
}

