/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.HierarchicalQDR;
import oracle.dss.util.HierarchicalQDRMember;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.QDRMember;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.transform.BaseProjection;
import oracle.dss.util.transform.DataAccessLong;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.QDRLite;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;
import oracle.dss.util.transform.TreeNode;

@Deprecated
public class TransformUtils {
    public static final NullMarker m_nullMarker = new NullMarker();

    public static String convertLayerMetadata(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("layerName")) {
            return "layerName";
        }
        if (type.equals("layerLabel")) {
            return "layerLabel";
        }
        if (type.equals("dimLongPluralName")) {
            return "dimLongPluralName";
        }
        if (type.equals("dimIsMeasure")) {
            return "dimIsMeasure";
        }
        if (type.equals("dimCanPivot")) {
            return "dimCanPivot";
        }
        return type;
    }

    protected static boolean alwaysAdd(boolean[] alwaysAdd, int edge) {
        if (alwaysAdd == null || alwaysAdd.length <= edge) {
            return false;
        }
        return alwaysAdd[edge];
    }

    public static String convertLayerMetadataMap(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("layerName")) {
            return "layerName";
        }
        if (type.equals("layerLabel") || type.equals("dimMediumName") || type.equals("dimShortName") || type.equals("dimDisplayName")) {
            return "layerLabel";
        }
        if (type.equals("dimLongPluralName") || type.equals("dimShortPluralName")) {
            return "dimLongPluralName";
        }
        if (type.equals("dimIsMeasure")) {
            return "dimIsMeasure";
        }
        if (type.equals("dimCanPivot")) {
            return "dimCanPivot";
        }
        return type;
    }

    public static String convertDataMap(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("dataValue")) {
            return "dataValue";
        }
        if (type.equals("dataFormattedValue")) {
            return "dataFormattedValue";
        }
        if (type.equals("dataType")) {
            return "dataType";
        }
        if (type.equals("dataIsEditable")) {
            return "dataIsEditable";
        }
        if (type.equals("dataCubeMax")) {
            return "dataCubeMax";
        }
        if (type.equals("dataCubeMin")) {
            return "dataCubeMin";
        }
        if (type.equals("dataAggregates")) {
            return "dataAggregates";
        }
        if (type.equals("aggregateCollection")) {
            return "aggregateCollection";
        }
        if (type.equals("dataKeyPath")) {
            return "dataKeyPath";
        }
        if (type.equals("dataRowKey")) {
            return "dataRowKey";
        }
        if (type.equals("aggType")) {
            return "aggType";
        }
        return type;
    }

    public static String convertDataType(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("dataValue")) {
            return "dataValue";
        }
        if (type.equals("dataFormattedValue")) {
            return "dataFormattedValue";
        }
        if (type.equals("dataType")) {
            return "dataType";
        }
        if (type.equals("dataIsEditable")) {
            return "dataIsEditable";
        }
        if (type.equals("dataCubeMax")) {
            return "dataCubeMax";
        }
        if (type.equals("dataCubeMin")) {
            return "dataCubeMin";
        }
        if (type.equals("dataAggregates")) {
            return "dataAggregates";
        }
        if (type.equals("aggregateCollection")) {
            return "aggregateCollection";
        }
        if (type.equals("dataKeyPath")) {
            return "dataKeyPath";
        }
        if (type.equals("dataRowKey")) {
            return "dataRowKey";
        }
        if (type.equals("aggType")) {
            return "aggType";
        }
        return type;
    }

    public static String convertMetadataMap(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("value")) {
            return "value";
        }
        if (type.equals("dataValue")) {
            return "rawvalue";
        }
        if (type.equals("rawvalue")) {
            return "rawvalue";
        }
        if (type.equals("shortName") || type.equals("mediumName") || type.equals("label")) {
            return "label";
        }
        if (type.equals("extent")) {
            return "extent";
        }
        if (type.equals("indent")) {
            return "indent";
        }
        if (type.equals("drillState")) {
            return "drillState";
        }
        if (type.equals("isTotal")) {
            return "isTotal";
        }
        if (type.equals("aggType")) {
            return "aggType";
        }
        if (type.equals("startSlice")) {
            return "startSlice";
        }
        if (type.equals("sortAttribute")) {
            return "sortAttribute";
        }
        if (type.equals("drillParentLongName") || type.equals("drillParentMediumName") || type.equals("drillParentShortName")) {
            return "memberMetadataDrillParentLabel";
        }
        return type;
    }

    public static String convertMemberMetadata(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("value")) {
            return "value";
        }
        if (type.equals("rawvalue")) {
            return "dataValue";
        }
        if (type.equals("label")) {
            return "label";
        }
        if (type.equals("extent")) {
            return "extent";
        }
        if (type.equals("indent")) {
            return "indent";
        }
        if (type.equals("drillState")) {
            return "drillState";
        }
        if (type.equals("isTotal")) {
            return "isTotal";
        }
        if (type.equals("aggType")) {
            return "aggType";
        }
        if (type.equals("startSlice")) {
            return "startSlice";
        }
        if (type.equals("sortAttribute")) {
            return "sortAttribute";
        }
        if (type.equals("memberMetadataDrillParentLabel")) {
            return "drillParentLongName";
        }
        return type;
    }

    public static int getLayerFromLayerQDR(String[][] layout, int edge, QDRInterface qdr) {
        if (qdr == null || layout == null || layout.length <= edge || layout[edge] == null) {
            return -1;
        }
        Vector dims = qdr.getDims();
        for (int layer = layout[edge].length - 1; layer >= 0; --layer) {
            if (dims.indexOf(layout[edge][layer]) <= -1) continue;
            return layer;
        }
        return -1;
    }

    public static boolean isLayerQDR(QDRInterface qdr) {
        Vector members = qdr.getMembers();
        if (members != null) {
            Enumeration membs = members.elements();
            QDRMember member = null;
            while (membs.hasMoreElements()) {
                member = (QDRMember)membs.nextElement();
                if (member == null || member.getData() == null) continue;
                return false;
            }
        }
        return true;
    }

    public static QDRLite getQDRFromTreeNode(TreeNode node) throws TransformException {
        if (node == null) {
            return null;
        }
        QDRLite qdr = new QDRLite();
        while (node != null && node.getParent() != null) {
            qdr.addDimMemberPair(node.getLayer().getValue(), node.getMember().getValue());
            node = node.getParent();
        }
        return qdr;
    }

    public static QDRInterface getQDRFromMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        Set<String> keys = map.keySet();
        Iterator<String> iter = keys.iterator();
        String layer = null;
        Object val = null;
        QDR qdr = new QDR();
        while (iter.hasNext()) {
            val = map.get(layer = iter.next());
            qdr.addDimMemberPair(layer, val != null ? val.toString() : null);
        }
        return qdr;
    }

    public static int[] getIntFromLongArray(long[] hPos) {
        if (hPos == null) {
            return null;
        }
        int[] retVal = new int[hPos.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = (int)hPos[i];
        }
        return retVal;
    }

    public static long[] getLongFromIntArray(int[] hPos) {
        if (hPos == null) {
            return null;
        }
        long[] retVal = new long[hPos.length];
        for (int i = 0; i < hPos.length; ++i) {
            retVal[i] = hPos[i];
        }
        return retVal;
    }

    public static String[] getLayersFromSliceToInsert(Map<String, MemberInterface> sliceToInsert) {
        Set<String> keys = sliceToInsert.keySet();
        return keys.toArray(new String[0]);
    }

    public static boolean comparehPos(long[] hPos1, long[] hPos2) {
        if (hPos1 == null && hPos2 == null) {
            return true;
        }
        if (hPos1 == null || hPos2 == null) {
            return false;
        }
        if (hPos1.length != hPos2.length) {
            return false;
        }
        for (int i = 0; i < hPos1.length; ++i) {
            if (hPos1[i] == hPos2[i]) continue;
            return false;
        }
        return true;
    }

    private static QDRLite generateQDRLite(String dataLayer) {
        return new QDRLite(dataLayer);
    }

    private static QDR generateQDR(String dataLayer, boolean hierarchicalQDR) {
        QDR qdr = null;
        qdr = hierarchicalQDR ? TransformUtils.getHierarchicalQDR(dataLayer) : new QDR(dataLayer);
        return qdr;
    }

    public static QDR getValueQDRImpl(String[][] layout, String dataLayer, DataAccessLong da, long row, long column, int flags, boolean hierarchicalQDR, boolean noTotals, boolean noDepth) throws RowOutOfRangeException, ColumnOutOfRangeException {
        QDR qdr = TransformUtils.generateQDR(dataLayer, hierarchicalQDR);
        try {
            qdr = TransformUtils.getValueQDR(layout, da, qdr, row, column, hierarchicalQDR, noTotals, noDepth);
        }
        catch (EdgeOutOfRangeException e) {
            Logger.getLogger("oracle.dss.util.transform").log(Level.SEVERE, "Bad row or column", e);
        }
        if (flags == 1) {
            int count = da.getEdgeCount();
            try {
                if (count > 2) {
                    qdr = TransformUtils.getSliceQDR(layout, da, qdr, 2, da.getEdgeCurrentSliceLong(2), hierarchicalQDR, noTotals, noDepth);
                }
            }
            catch (EdgeOutOfRangeException e) {
                Logger.getLogger("oracle.dss.util.transform").log(Level.SEVERE, "Bad edge", e);
            }
            catch (SliceOutOfRangeException se) {
                throw new TransformRuntimeException(se.getMessage(), se);
            }
            for (int i = 3; i < count; ++i) {
                try {
                    qdr = TransformUtils.getSliceQDR(layout, da, qdr, i, 0L, hierarchicalQDR, noTotals, noDepth);
                    continue;
                }
                catch (EdgeOutOfRangeException e) {
                    Logger.getLogger("oracle.dss.util.transform").log(Level.SEVERE, "Bad edge", e);
                    continue;
                }
                catch (SliceOutOfRangeException se) {
                    throw new TransformRuntimeException(se.getMessage(), se);
                }
            }
        }
        return qdr;
    }

    public static QDRLite getValueQDRLiteImpl(String[][] layout, String dataLayer, DataAccessLong da, long row, long column, int flags) throws RowOutOfRangeException, ColumnOutOfRangeException {
        QDRLite qdr = TransformUtils.generateQDRLite(dataLayer);
        try {
            qdr = TransformUtils.getValueQDRLite(layout, da, qdr, row, column);
        }
        catch (EdgeOutOfRangeException e) {
            Logger.getLogger("oracle.dss.util.transform").log(Level.SEVERE, "Bad row or column", e);
        }
        if (flags == 1) {
            int count = da.getEdgeCount();
            try {
                if (count > 2) {
                    qdr = TransformUtils.getSliceQDRLite(layout, da, qdr, 2, da.getEdgeCurrentSliceLong(2));
                }
            }
            catch (EdgeOutOfRangeException e) {
                Logger.getLogger("oracle.dss.util.transform").log(Level.SEVERE, "Bad edge", e);
            }
            catch (SliceOutOfRangeException se) {
                throw new TransformRuntimeException(se.getMessage(), se);
            }
            for (int i = 3; i < count; ++i) {
                try {
                    qdr = TransformUtils.getSliceQDRLite(layout, da, qdr, i, 0L);
                    continue;
                }
                catch (EdgeOutOfRangeException e) {
                    Logger.getLogger("oracle.dss.util.transform").log(Level.SEVERE, "Bad edge", e);
                    continue;
                }
                catch (SliceOutOfRangeException se) {
                    throw new TransformRuntimeException(se.getMessage(), se);
                }
            }
        }
        return qdr;
    }

    public static QDR getSliceQDRImpl(String[][] layout, String dataLayer, DataAccessLong da, long pageSlice, int edge, long slice, int flags, boolean hierarchicalQDR, boolean noTotals, boolean noDepth) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        return TransformUtils.getSliceQDR(layout, dataLayer, da, pageSlice, edge, slice, flags, hierarchicalQDR, noTotals, noDepth);
    }

    protected static QDRLite getMemberQDRLiteImpl(String[][] layout, String dataLayer, DataAccessLong da, int edge, int layer, long slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        QDRLite qdr = TransformUtils.generateQDRLite(dataLayer);
        for (int l = 0; l <= layer; ++l) {
            qdr = TransformUtils.getMemberQDRLite(layout, da, qdr, edge, l, slice);
        }
        if (flags == 1 && edge != 2) {
            qdr = TransformUtils.getSliceQDRLite(layout, da, qdr, 2, da.getEdgeCurrentSliceLong(2));
        }
        return qdr;
    }

    public static QDR getMemberQDRImpl(String[][] layout, String dataLayer, DataAccessLong da, int edge, int layer, long slice, int flags, boolean hierarchicalQDR, boolean noTotals, boolean noDepth) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        QDR qdr = TransformUtils.generateQDR(dataLayer, hierarchicalQDR);
        for (int l = 0; l <= layer; ++l) {
            qdr = TransformUtils.getMemberQDR(layout, da, qdr, edge, l, slice, hierarchicalQDR);
        }
        if (flags == 1 && edge != 2) {
            qdr = TransformUtils.getSliceQDR(layout, da, qdr, 2, da.getEdgeCurrentSliceLong(2), hierarchicalQDR, noTotals, noDepth);
        }
        return qdr;
    }

    public static QDR getMemberQDRImpl(String[][] layout, String dataLayer, DataAccessLong da, int edge, long[] hPos, int memberLayer, long hIndex, int flags, boolean hierarchicalQDR, boolean noTotals, boolean noDepth) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        QDR qdr = TransformUtils.generateQDR(dataLayer, hierarchicalQDR);
        for (int l = 0; l <= memberLayer; ++l) {
            qdr = TransformUtils.getMemberQDR(layout, da, qdr, edge, hPos, l, l == memberLayer ? hIndex : hPos[l], hierarchicalQDR);
        }
        if (flags == 1 && edge != 2) {
            qdr = TransformUtils.getSliceQDR(layout, da, qdr, 2, da.getEdgeCurrentSliceLong(2), hierarchicalQDR, noTotals, noDepth);
        }
        return qdr;
    }

    public static QDRLite getMemberQDRLiteImpl(String[][] layout, String dataLayer, DataAccessLong da, int edge, long[] hPos, int memberLayer, long hIndex, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        QDRLite qdr = TransformUtils.generateQDRLite(dataLayer);
        for (int l = 0; l <= memberLayer; ++l) {
            qdr = TransformUtils.getMemberQDRLite(layout, da, qdr, edge, hPos, l, l == memberLayer ? hIndex : hPos[l]);
        }
        if (flags == 1 && edge != 2) {
            qdr = TransformUtils.getSliceQDRLite(layout, da, qdr, 2, da.getEdgeCurrentSliceLong(2));
        }
        return qdr;
    }

    public static QDR getLayerQDRImpl(String[][] layout, String dataLayer, DataAccessLong da, int edge, int layer, int flags, boolean hierarchicalQDR, boolean noTotals, boolean noDepth) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        QDR qdr = TransformUtils.generateQDR(dataLayer, hierarchicalQDR);
        qdr = TransformUtils.getLayerQDR(layout, da, qdr, edge, layer, hierarchicalQDR);
        if (edge != 2 && flags == 1) {
            try {
                qdr = TransformUtils.getSliceQDR(layout, da, qdr, 2, da.getEdgeCurrentSliceLong(2), hierarchicalQDR, noTotals, noDepth);
            }
            catch (SliceOutOfRangeException se) {
                throw new TransformRuntimeException(se.getMessage(), se);
            }
        }
        return qdr;
    }

    protected static QDR getLayerQDR(String[][] layout, DataAccessLong da, QDR qdr, int edge, int layer, boolean hierarchicalQDR) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        String dim = TransformUtils.getItem(layout, edge, layer);
        if (dim == null) {
            return qdr;
        }
        if (hierarchicalQDR) {
            String hier = null;
            if (dim != null) {
                try {
                    hier = (String)da.getMemberMetadata(edge, layer, 0L, "hierarchy");
                }
                catch (SliceOutOfRangeException e) {
                    Logger.getLogger("oracle.dss.util.transform").log(Level.SEVERE, "Bad slice", e);
                }
            }
            ((HierarchicalQDR)qdr).addDimMemberPair(dim, null, hier, null);
        } else {
            qdr.addDimMemberPair(dim, (String)null);
        }
        return qdr;
    }

    protected static QDRLite getMemberQDRLite(String[][] layout, DataAccessLong da, QDRLite qdr, int edge, long[] hPos, int memberLayer, long hIndex) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        Object aggObj;
        boolean agg;
        boolean total;
        String dim = TransformUtils.getItem(layout, edge, memberLayer);
        if (dim == null) {
            return qdr;
        }
        String member = TransformUtils._makeString(da.getMemberMetadata(edge, hPos, memberLayer, hIndex, "value"));
        int type = 0;
        Object totalObj = da.getMemberMetadata(edge, hPos, memberLayer, hIndex, "isTotal");
        boolean bl = total = totalObj instanceof Boolean ? (Boolean)totalObj : false;
        if (total) {
            type = 4;
        }
        boolean bl2 = agg = (aggObj = da.getMemberMetadata(edge, hPos, memberLayer, hIndex, "isAgg")) instanceof Boolean ? (Boolean)aggObj : false;
        if (agg) {
            type = 5;
        }
        qdr.addDimMemberPair(dim, member);
        return qdr;
    }

    protected static QDR getMemberQDR(String[][] layout, DataAccessLong da, QDR qdr, int edge, long[] hPos, int memberLayer, long hIndex, boolean hierarchicalQDR) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        Object aggObj;
        boolean agg;
        boolean total;
        String dim = TransformUtils.getItem(layout, edge, memberLayer);
        if (dim == null) {
            return qdr;
        }
        String member = TransformUtils._makeString(da.getMemberMetadata(edge, hPos, memberLayer, hIndex, "value"));
        int type = 0;
        Object totalObj = da.getMemberMetadata(edge, hPos, memberLayer, hIndex, "isTotal");
        boolean bl = total = totalObj instanceof Boolean ? (Boolean)totalObj : false;
        if (total) {
            type = 4;
        }
        boolean bl2 = agg = (aggObj = da.getMemberMetadata(edge, hPos, memberLayer, hIndex, "isAgg")) instanceof Boolean ? (Boolean)aggObj : false;
        if (agg) {
            type = 5;
        }
        if (hierarchicalQDR) {
            String hier = null;
            String level = null;
            if (dim != null && (hier = TransformUtils._makeString(da.getMemberMetadata(edge, hPos, memberLayer, hIndex, "hierarchy"))) != null) {
                level = TransformUtils._makeString(da.getMemberMetadata(edge, hPos, memberLayer, hIndex, "level"));
            }
            HierarchicalQDRMember qdrMem = new HierarchicalQDRMember(type, member, hier, level);
            ((HierarchicalQDR)qdr).addDimMemberPair(dim, qdrMem);
        } else {
            QDRMember qdrMem = new QDRMember(type, member);
            qdr.addDimMemberPair(dim, qdrMem);
        }
        return qdr;
    }

    protected static QDRLite getMemberQDRLite(String[][] layout, DataAccessLong da, QDRLite qdr, int edge, int layer, long slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        Object aggObj;
        boolean agg;
        boolean total;
        String dim = TransformUtils.getItem(layout, edge, layer);
        if (dim == null) {
            return qdr;
        }
        int type = 0;
        String member = TransformUtils._makeString(da.getMemberMetadata(edge, layer, (int)slice, "value"));
        Object totalObj = da.getMemberMetadata(edge, layer, (int)slice, "isTotal");
        boolean bl = total = totalObj instanceof Boolean ? (Boolean)totalObj : false;
        if (total) {
            type = 4;
        }
        boolean bl2 = agg = (aggObj = da.getMemberMetadata(edge, layer, (int)slice, "isAgg")) instanceof Boolean ? (Boolean)aggObj : false;
        if (agg) {
            type = 5;
        }
        qdr.addDimMemberPair(dim, member);
        return qdr;
    }

    protected static QDR getMemberQDR(String[][] layout, DataAccessLong da, QDR qdr, int edge, int layer, long slice, boolean hierarchicalQDR) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        Object aggObj;
        boolean agg;
        boolean total;
        String dim = TransformUtils.getItem(layout, edge, layer);
        if (dim == null) {
            return qdr;
        }
        int type = 0;
        String member = TransformUtils._makeString(da.getMemberMetadata(edge, layer, (int)slice, "value"));
        Object totalObj = da.getMemberMetadata(edge, layer, (int)slice, "isTotal");
        boolean bl = total = totalObj instanceof Boolean ? (Boolean)totalObj : false;
        if (total) {
            type = 4;
        }
        boolean bl2 = agg = (aggObj = da.getMemberMetadata(edge, layer, (int)slice, "isAgg")) instanceof Boolean ? (Boolean)aggObj : false;
        if (agg) {
            type = 5;
        }
        if (hierarchicalQDR) {
            String hier = null;
            String level = null;
            if (dim != null && (hier = TransformUtils._makeString(da.getMemberMetadata(edge, layer, (int)slice, "hierarchy"))) != null) {
                level = TransformUtils._makeString(da.getMemberMetadata(edge, layer, (int)slice, "level"));
            }
            ((HierarchicalQDR)qdr).addDimMemberPair(dim, new HierarchicalQDRMember(type, member, hier, level));
        } else {
            qdr.addDimMemberPair(dim, new QDRMember(type, member));
        }
        return qdr;
    }

    protected static QDRLite getSliceQDRLite(String[][] layout, String dataLayer, DataAccessLong da, long pageSlice, int edge, long slice, int flags) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        QDRLite qdr = TransformUtils.generateQDRLite(dataLayer);
        qdr = TransformUtils.getSliceQDRLite(layout, da, qdr, edge, slice);
        if (flags == 1 && edge != 2 && da.getEdgeCount() > 2) {
            qdr = TransformUtils.getSliceQDRLite(layout, da, qdr, 2, pageSlice);
        }
        return qdr;
    }

    protected static QDR getSliceQDR(String[][] layout, String dataLayer, DataAccessLong da, long pageSlice, int edge, long slice, int flags, boolean hierarchicalQDR, boolean noTotals, boolean noDepth) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        QDR qdr = TransformUtils.generateQDR(dataLayer, hierarchicalQDR);
        qdr = TransformUtils.getSliceQDR(layout, da, qdr, edge, slice, hierarchicalQDR, noTotals, noDepth);
        if (flags == 1 && edge != 2 && da.getEdgeCount() > 2) {
            qdr = TransformUtils.getSliceQDR(layout, da, qdr, 2, pageSlice, hierarchicalQDR, noTotals, noDepth);
        }
        return qdr;
    }

    protected static QDRLite getValueQDRLite(String[][] layout, DataAccessLong da, QDRLite qdr, long row, long column) throws EdgeOutOfRangeException, RowOutOfRangeException, ColumnOutOfRangeException {
        try {
            TransformUtils.addEdgeToQDRLite(layout, da, qdr, 0, column);
        }
        catch (SliceOutOfRangeException se) {
            throw new ColumnOutOfRangeException(column, -1L, se);
        }
        try {
            TransformUtils.addEdgeToQDRLite(layout, da, qdr, 1, row);
        }
        catch (SliceOutOfRangeException se) {
            throw new RowOutOfRangeException(row, -1L, se);
        }
        return qdr;
    }

    protected static QDR getValueQDR(String[][] layout, DataAccessLong da, QDR qdr, long row, long column, boolean hierarchicalQDR, boolean noTotals, boolean noDepth) throws EdgeOutOfRangeException, RowOutOfRangeException, ColumnOutOfRangeException {
        try {
            TransformUtils.addEdgeToQDR(layout, da, qdr, 0, column, hierarchicalQDR, noTotals, noDepth);
        }
        catch (SliceOutOfRangeException se) {
            throw new ColumnOutOfRangeException(column, -1L, se);
        }
        try {
            TransformUtils.addEdgeToQDR(layout, da, qdr, 1, row, hierarchicalQDR, noTotals, noDepth);
        }
        catch (SliceOutOfRangeException se) {
            throw new RowOutOfRangeException(row, -1L, se);
        }
        return qdr;
    }

    protected static QDRLite getSliceQDRLite(String[][] layout, DataAccessLong da, QDRLite qdr, int edge, long slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        TransformUtils.addEdgeToQDRLite(layout, da, qdr, edge, slice);
        return qdr;
    }

    protected static QDR getSliceQDR(String[][] layout, DataAccessLong da, QDR qdr, int edge, long slice, boolean hierarchicalQDR, boolean noTotals, boolean noDepth) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        TransformUtils.addEdgeToQDR(layout, da, qdr, edge, slice, hierarchicalQDR, noTotals, noDepth);
        return qdr;
    }

    protected static void addEdgeToQDRLite(String[][] layout, DataAccessLong da, QDRLite qdr, int edge, long index) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        String dimName = null;
        if (edge >= da.getEdgeCount()) {
            return;
        }
        long limit = da.getSliceMemberCount(edge, index);
        int depth = 0;
        while ((long)depth < limit) {
            dimName = TransformUtils.getItem(layout, edge, depth);
            if (dimName != null) {
                try {
                    Object aggObj;
                    boolean agg;
                    boolean total;
                    int type = 0;
                    String value = (String)da.getMemberMetadata(edge, depth, (int)index, "value");
                    Object totalObj = da.getMemberMetadata(edge, depth, (int)index, "isTotal");
                    boolean bl = total = totalObj instanceof Boolean ? (Boolean)totalObj : false;
                    if (total) {
                        type = 4;
                    }
                    boolean bl2 = agg = (aggObj = da.getMemberMetadata(edge, depth, (int)index, "isAgg")) instanceof Boolean ? (Boolean)aggObj : false;
                    if (agg) {
                        type = 5;
                    }
                    qdr.addDimMemberPair(dimName, value);
                }
                catch (LayerOutOfRangeException e) {
                    throw new TransformRuntimeException(e.getMessage(), e);
                }
            }
            ++depth;
        }
    }

    protected static void addEdgeToQDR(String[][] layout, DataAccessLong da, QDR qdr, int edge, long index, boolean hierarchicalQDR, boolean noTotals, boolean noDepth) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        String dimName = null;
        if (edge >= da.getEdgeCount()) {
            return;
        }
        long limit = noDepth ? (long)da.getLayerCount(edge) : da.getSliceMemberCount(edge, index);
        int depthLoc = 0;
        int depth = 0;
        while ((long)depth < limit) {
            dimName = TransformUtils.getItem(layout, edge, depthLoc);
            if (dimName != null) {
                try {
                    int type = 0;
                    Object value = da.getMemberMetadata(edge, depthLoc, (int)index, "value");
                    if (!noTotals) {
                        Object aggObj;
                        boolean agg;
                        boolean total;
                        Object totalObj = da.getMemberMetadata(edge, depthLoc, (int)index, "isTotal");
                        boolean bl = total = totalObj instanceof Boolean ? (Boolean)totalObj : false;
                        if (total) {
                            type = 4;
                        }
                        boolean bl2 = agg = (aggObj = da.getMemberMetadata(edge, depthLoc, (int)index, "isAgg")) instanceof Boolean ? (Boolean)aggObj : false;
                        if (agg) {
                            type = 5;
                        }
                    }
                    if (hierarchicalQDR) {
                        String hier = null;
                        String level = null;
                        hier = TransformUtils._makeString(da.getMemberMetadata(edge, depthLoc, (int)index, "hierarchy"));
                        if (hier != null) {
                            level = TransformUtils._makeString(da.getMemberMetadata(edge, depthLoc, (int)index, "level"));
                        }
                        ((HierarchicalQDR)qdr).addDimMemberPair(dimName, new HierarchicalQDRMember(type, (String)value, hier, level));
                    } else {
                        qdr.addDimMemberPair(dimName, new QDRMember(type, value));
                    }
                }
                catch (LayerOutOfRangeException e) {
                    throw new TransformRuntimeException(e.getMessage(), e);
                }
            }
            try {
                depthLoc = noDepth ? ++depthLoc : (depthLoc += da.getMemberDepth(edge, depthLoc, index));
            }
            catch (LayerOutOfRangeException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
            ++depth;
        }
    }

    protected static String getItem(String[][] layout, int edge, int layer) {
        if (layout != null && edge < layout.length && layer < layout[edge].length) {
            return layout[edge][layer];
        }
        return null;
    }

    public static String getMeasureName(DataAccessLong da, String dataLayer, String[][] layout, long row, long column) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        int[] edgeAndLayer = TransformUtils.getLayerAndEdge(dataLayer, layout);
        if (edgeAndLayer == null || edgeAndLayer.length < 2) {
            return null;
        }
        int edge = edgeAndLayer[0];
        int layer = edgeAndLayer[1];
        long measSlice = edge > 1 ? 0L : (edge == 0 ? column : row);
        String meas = (String)da.getMemberMetadata(edge, layer, measSlice, "value");
        return meas;
    }

    private static String getMeasureCellKey(String meas, String type) {
        return meas + " " + type;
    }

    public static Object getValueForAllMeasureCells(Map<String, Object> valueCache, DataAccessLong da, String[][] layout, String dataLayer, long row, long column, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, RowOutOfRangeException, ColumnOutOfRangeException {
        int[] edgeAndLayer = TransformUtils.getLayerAndEdge(dataLayer, layout);
        if (edgeAndLayer == null || edgeAndLayer.length < 2) {
            return null;
        }
        int edge = edgeAndLayer[0];
        int layer = edgeAndLayer[1];
        long measSlice = edge > 1 ? 0L : (edge == 0 ? column : row);
        String meas = (String)da.getMemberMetadata(edge, layer, measSlice, "value");
        if (meas == null) {
            return null;
        }
        String key = TransformUtils.getMeasureCellKey(meas, type);
        Object val = valueCache.get(key);
        if (val != null) {
            return val;
        }
        long rowCount = da.getEdgeExtentLong(1);
        long colCount = da.getEdgeExtentLong(0);
        Object currVal = null;
        String minKey = null;
        String maxKey = null;
        switch (edge) {
            case 0: {
                for (long c = 0L; c < colCount; ++c) {
                    if (TransformUtils.isSliceATotal(da, 0, c)) continue;
                    minKey = TransformUtils.getMeasureCellKey((String)da.getMemberMetadata(edge, layer, c, "value"), "dataCubeMin");
                    maxKey = TransformUtils.getMeasureCellKey((String)da.getMemberMetadata(edge, layer, c, "value"), "dataCubeMax");
                    for (long r = 0L; r < rowCount; ++r) {
                        if (TransformUtils.isSliceATotal(da, 1, r)) continue;
                        currVal = valueCache.get(minKey);
                        val = TransformUtils.getNewVal(currVal, da, r, c, "dataCubeMin");
                        if (val != null) {
                            valueCache.put(minKey, val);
                        }
                        if ((val = TransformUtils.getNewVal(currVal = valueCache.get(maxKey), da, r, c, "dataCubeMax")) == null) continue;
                        valueCache.put(maxKey, val);
                    }
                }
                break;
            }
            case 1: {
                for (long r = 0L; r < rowCount; ++r) {
                    if (TransformUtils.isSliceATotal(da, 1, r)) continue;
                    minKey = TransformUtils.getMeasureCellKey((String)da.getMemberMetadata(edge, layer, r, "value"), "dataCubeMin");
                    maxKey = TransformUtils.getMeasureCellKey((String)da.getMemberMetadata(edge, layer, r, "value"), "dataCubeMax");
                    for (long c = 0L; c < colCount; ++c) {
                        if (TransformUtils.isSliceATotal(da, 0, c)) continue;
                        currVal = valueCache.get(minKey);
                        val = TransformUtils.getNewVal(currVal, da, r, c, "dataCubeMin");
                        if (val != null) {
                            valueCache.put(minKey, val);
                        }
                        if ((val = TransformUtils.getNewVal(currVal = valueCache.get(maxKey), da, r, c, "dataCubeMax")) == null) continue;
                        valueCache.put(maxKey, val);
                    }
                }
                break;
            }
            default: {
                minKey = TransformUtils.getMeasureCellKey(meas, "dataCubeMin");
                maxKey = TransformUtils.getMeasureCellKey(meas, "dataCubeMax");
                for (long r = 0L; r < rowCount; ++r) {
                    if (TransformUtils.isSliceATotal(da, 1, r)) continue;
                    for (long c = 0L; c < colCount; ++c) {
                        if (TransformUtils.isTotal(da, r, c)) continue;
                        currVal = valueCache.get(minKey);
                        val = TransformUtils.getNewVal(currVal, da, r, c, "dataCubeMin");
                        if (val != null) {
                            valueCache.put(minKey, val);
                        }
                        if ((val = TransformUtils.getNewVal(currVal = valueCache.get(maxKey), da, r, c, "dataCubeMax")) == null) continue;
                        valueCache.put(maxKey, val);
                    }
                }
            }
        }
        val = valueCache.get(key);
        return val;
    }

    private static boolean isSliceATotal(DataAccessLong da, int edge, long slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        int layerCount = da.getLayerCount(edge);
        Object val = null;
        for (int l = layerCount - 1; l >= 0; --l) {
            val = da.getMemberMetadata(edge, l, slice, "isTotal");
            if (!(val instanceof Boolean) || !((Boolean)val).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static boolean isTotal(DataAccessLong da, long row, long column) throws RowOutOfRangeException, ColumnOutOfRangeException {
        Object val = da.getValue(row, column, "dataIsTotal");
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return false;
    }

    private static Object getNewVal(Object currVal, DataAccessLong da, long row, long column, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        Object val = da.getValue(row, column, "dataValue");
        if (val != null) {
            if (currVal == null) {
                return val;
            }
            if ("dataCubeMax".equals(type)) {
                return TransformUtils.max(val, currVal);
            }
            if ("dataCubeMin".equals(type)) {
                return TransformUtils.min(val, currVal);
            }
        }
        return currVal;
    }

    private static Object min(Object newVal, Object oldVal) {
        if (newVal instanceof Number && oldVal instanceof Number) {
            return Math.min(((Number)newVal).doubleValue(), ((Number)oldVal).doubleValue());
        }
        if (newVal instanceof BigInteger && oldVal instanceof BigInteger) {
            return ((BigInteger)newVal).min((BigInteger)oldVal);
        }
        if (newVal instanceof BigDecimal && oldVal instanceof BigDecimal) {
            return ((BigDecimal)newVal).min((BigDecimal)oldVal);
        }
        if (newVal instanceof String && oldVal instanceof String) {
            return ((String)newVal).compareTo((String)oldVal) < 0 ? newVal : oldVal;
        }
        if (newVal instanceof java.util.Date && oldVal instanceof java.util.Date) {
            return ((java.util.Date)newVal).compareTo((java.util.Date)oldVal) < 0 ? newVal : oldVal;
        }
        if (newVal instanceof Date && oldVal instanceof Date) {
            return ((Date)newVal).compareTo((Date)oldVal) < 0 ? newVal : oldVal;
        }
        return oldVal;
    }

    private static Object max(Object newVal, Object oldVal) {
        if (newVal instanceof Number && oldVal instanceof Number) {
            return Math.max(((Number)newVal).doubleValue(), ((Number)oldVal).doubleValue());
        }
        if (newVal instanceof BigInteger && oldVal instanceof BigInteger) {
            return ((BigInteger)newVal).max((BigInteger)oldVal);
        }
        if (newVal instanceof BigDecimal && oldVal instanceof BigDecimal) {
            return ((BigDecimal)newVal).max((BigDecimal)oldVal);
        }
        if (newVal instanceof String && oldVal instanceof String) {
            return ((String)newVal).compareTo((String)oldVal) > 0 ? newVal : oldVal;
        }
        if (newVal instanceof java.util.Date && oldVal instanceof java.util.Date) {
            return ((java.util.Date)newVal).compareTo((java.util.Date)oldVal) > 0 ? newVal : oldVal;
        }
        if (newVal instanceof Date && oldVal instanceof Date) {
            return ((Date)newVal).compareTo((Date)oldVal) > 0 ? newVal : oldVal;
        }
        return oldVal;
    }

    public static String _makeString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    protected static HierarchicalQDR getHierarchicalQDR(String measureDim) {
        return new HierarchicalQDR(measureDim);
    }

    public static List getUniqueMemberMetadata(DataAccessLong da, boolean isSymmetric, long parentLimit, int edge, int layer, String[] types, long start, long count) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        List retVal = new ArrayList<Object[]>();
        if (types == null) {
            return retVal;
        }
        if (isSymmetric) {
            long[] context = new long[layer];
            long numVals = da.getMemberSiblingCount(edge, context, layer);
            int i = 0;
            while ((long)i < numVals) {
                retVal.add(TransformUtils.getArrayOfMetadataTypes(da, edge, context, layer, i, types));
                ++i;
            }
            return retVal;
        }
        ArrayList uniqueTrack = new ArrayList();
        long[] hPos = new long[da.getLayerCount(edge)];
        Object[] rets = TransformUtils._accumulateMembers(da, edge, 0, layer, hPos, parentLimit, count > -1L ? count + start : -1L, 0L, retVal, uniqueTrack, types);
        retVal = (List)rets[0];
        if (start > 0L) {
            return new ArrayList(retVal.subList((int)start, retVal.size()));
        }
        return retVal;
    }

    private static Object[] _accumulateMembers(DataAccessLong da, int edge, int layer, int walkLayer, long[] hPos, long parentLimit, long uniqueLimit, long parentCount, List currentSet, List uniqueSet, String[] types) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (uniqueLimit > -1L && (long)uniqueSet.size() >= uniqueLimit || parentCount > -1L && parentCount >= parentLimit) {
            return new Object[]{currentSet, uniqueSet, new Long(parentCount)};
        }
        long count = da.getMemberSiblingCount(edge, hPos, layer);
        List currentSetTemp = currentSet;
        List uniqueSetTemp = uniqueSet;
        if (layer == walkLayer) {
            for (long i = 0L; i < count; ++i) {
                int pos;
                Object value = da.getMemberMetadata(edge, hPos, walkLayer, i, "value");
                if (value == null || (pos = uniqueSetTemp.indexOf(value)) != -1) continue;
                uniqueSetTemp.add(value);
                currentSetTemp.add(TransformUtils.getArrayOfMetadataTypes(da, edge, hPos, walkLayer, i, types));
                if (uniqueLimit > -1L && (long)uniqueSetTemp.size() >= uniqueLimit) break;
            }
            return new Object[]{currentSetTemp, uniqueSetTemp, new Long(parentCount)};
        }
        long parents = parentCount;
        for (long i = 0L; i < count; ++i) {
            hPos[layer] = i;
            Object[] rets = TransformUtils._accumulateMembers(da, edge, layer + 1, walkLayer, hPos, parentLimit, uniqueLimit, parents, currentSetTemp, uniqueSetTemp, types);
            currentSetTemp = (List)rets[0];
            uniqueSetTemp = (List)rets[1];
            parents = ((Long)rets[2]).intValue();
            if (parentLimit > -1L && ++parents >= parentLimit) break;
        }
        return new Object[]{currentSetTemp, uniqueSetTemp, new Long(parentCount)};
    }

    public static int[] getLayerAndEdge(String layerName, String[][] layout) {
        for (int e = 0; e < layout.length; ++e) {
            if (layout[e] == null) continue;
            for (int l = 0; l < layout[e].length; ++l) {
                if (layout[e][l] == null || !layout[e][l].equals(layerName)) continue;
                int[] val = new int[]{e, l};
                return val;
            }
        }
        return null;
    }

    private static long[] _findMember(DataAccess da, int edge, int layer, int walkLayer, int[] hPos, String value) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (layer == walkLayer) {
            int pos = da.findMember(edge, hPos, walkLayer, value, "value", 1);
            if (pos == -1) {
                return null;
            }
            hPos[walkLayer] = pos;
            return TransformUtils.getLongFromIntArray(hPos);
        }
        long count = da.getMemberSiblingCount(edge, hPos, layer);
        for (long i = 0L; i < count; ++i) {
            hPos[layer] = (int)i;
            long[] rethPos = TransformUtils._findMember(da, edge, layer + 1, walkLayer, hPos, value);
            if (rethPos == null) continue;
            return rethPos;
        }
        return null;
    }

    public static List getCorrespondingMemberMetadata(DataAccess da, int edge, int layer, String[] values, String[] types, boolean inDataAccess, boolean isSymmetric) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        ArrayList<Object[]> retVal = new ArrayList<Object[]>();
        if (!inDataAccess) {
            return retVal;
        }
        if (values == null || types == null) {
            return retVal;
        }
        for (int i = 0; i < values.length; ++i) {
            long[] context;
            if (isSymmetric) {
                context = new long[layer + 1];
                long pos = -1L;
                try {
                    pos = da.findMember(edge, TransformUtils.getIntFromLongArray(context), layer, values[i], "value", 1);
                }
                catch (SliceOutOfRangeException e) {
                    throw new LayerOutOfRangeException(e.getMessage(), e);
                }
                if (pos == -1L) {
                    retVal.add(null);
                    continue;
                }
                try {
                    retVal.add(TransformUtils.getArrayOfMetadataTypes((DataAccessLong)((Object)da), edge, context, layer, pos, types));
                    continue;
                }
                catch (SliceOutOfRangeException e) {
                    throw new LayerOutOfRangeException(e.getMessage(), e);
                }
            }
            context = new long[layer + 1];
            long[] hPos = null;
            try {
                hPos = TransformUtils._findMember(da, edge, 0, layer, TransformUtils.getIntFromLongArray(context), values[i]);
            }
            catch (SliceOutOfRangeException e) {
                throw new LayerOutOfRangeException(e.getMessage(), e);
            }
            if (hPos != null) {
                try {
                    retVal.add(TransformUtils.getArrayOfMetadataTypes((DataAccessLong)((Object)da), edge, hPos, layer, hPos[layer], types));
                    continue;
                }
                catch (SliceOutOfRangeException e) {
                    throw new LayerOutOfRangeException(e.getMessage(), e);
                }
            }
            retVal.add(null);
        }
        return retVal;
    }

    public static Object[] getArrayOfMetadataTypes(DataAccessLong da, int edge, long[] hPos, int memberLayer, long index, String[] types) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        Object[] retArray = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            retArray[i] = da.getMemberMetadata(edge, hPos, memberLayer, index, types[i]);
        }
        return retArray;
    }

    public static boolean compareStrings(String s1, String s2, int flags) {
        if (s2 == null) {
            return false;
        }
        if ((flags & 2) > 0) {
            return s2.indexOf(s1) > -1;
        }
        if ((flags & 4) > 0) {
            return s2.startsWith(s1);
        }
        if ((flags & 8) > 0) {
            return s2.endsWith(s1);
        }
        return s2.equals(s1);
    }

    public static String[] getMeasList(BaseProjection proj) throws TransformException {
        MemberInterface[] dataItems = proj.getDataItems();
        String[] measList = null;
        if (dataItems != null) {
            measList = new String[dataItems.length];
            for (int i = 0; i < dataItems.length; ++i) {
                measList[i] = dataItems[i].getValue();
            }
        }
        return measList;
    }

    public static class NullMarker {
    }
}

